package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 核验挂起原因
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum VerifyHangType {

    _0("0", "默认"),
    _1("1", "稍后处理"),
    _2("2", "数据有误");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VerifyHangType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VerifyHangType fromCode(String code) {
        return Stream.of(VerifyHangType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
