package com.xforceplus.ultraman.app.imagesaas.metadata.validator;

import com.xforceplus.ultraman.app.imagesaas.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.imagesaas.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(ImageType.class)) {
            isValid = null != ImageType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageType.class.getSimpleName());
            }
        }
        if(clazz.equals(SignStatus.class)) {
            isValid = null != SignStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SignStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillDataStatus.class)) {
            isValid = null != BillDataStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillDataStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyStatus.class)) {
            isValid = null != VerifyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VerifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsPublic.class)) {
            isValid = null != IsPublic.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsPublic.class.getSimpleName());
            }
        }
        if(clazz.equals(IsSecret.class)) {
            isValid = null != IsSecret.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsSecret.class.getSimpleName());
            }
        }
        if(clazz.equals(BackType.class)) {
            isValid = null != BackType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BackType.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageSource.class)) {
            isValid = null != ImageSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageSource.class.getSimpleName());
            }
        }
        if(clazz.equals(RecStatus.class)) {
            isValid = null != RecStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FileType.class)) {
            isValid = null != FileType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FileType.class.getSimpleName());
            }
        }
        if(clazz.equals(YesNo.class)) {
            isValid = null != YesNo.fromCode(value);
            if(!isValid) {
                unValidMsg(context, YesNo.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageStatus.class)) {
            isValid = null != ImageStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckStatus.class)) {
            isValid = null != CheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LogisticsStatus.class)) {
            isValid = null != LogisticsStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LogisticsStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSheet.class)) {
            isValid = null != InvoiceSheet.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceSheet.class.getSimpleName());
            }
        }
        if(clazz.equals(TicketType.class)) {
            isValid = null != TicketType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TicketType.class.getSimpleName());
            }
        }
        if(clazz.equals(ExceptionStatus.class)) {
            isValid = null != ExceptionStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExceptionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BackStatus.class)) {
            isValid = null != BackStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfigDataMappingType.class)) {
            isValid = null != ConfigDataMappingType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ConfigDataMappingType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(UseStatus.class)) {
            isValid = null != UseStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageCategory.class)) {
            isValid = null != ImageCategory.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(UnqualityType.class)) {
            isValid = null != UnqualityType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UnqualityType.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyHangType.class)) {
            isValid = null != VerifyHangType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VerifyHangType.class.getSimpleName());
            }
        }
        if(clazz.equals(BackReason.class)) {
            isValid = null != BackReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BackReason.class.getSimpleName());
            }
        }
        if(clazz.equals(HangType.class)) {
            isValid = null != HangType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HangType.class.getSimpleName());
            }
        }
        if(clazz.equals(TicketStatus.class)) {
            isValid = null != TicketStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TicketStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageFileType.class)) {
            isValid = null != ImageFileType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageFileType.class.getSimpleName());
            }
        }
        if(clazz.equals(ExtStatus.class)) {
            isValid = null != ExtStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExtStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PrepaymentStatus.class)) {
            isValid = null != PrepaymentStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PrepaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PageCode.class)) {
            isValid = null != PageCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PageCode.class.getSimpleName());
            }
        }
        if(clazz.equals(MacthStatus.class)) {
            isValid = null != MacthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MacthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CurrencyType.class)) {
            isValid = null != CurrencyType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CurrencyType.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialInvoiceFlag.class)) {
            isValid = null != SpecialInvoiceFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SpecialInvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(BillCheckStatus.class)) {
            isValid = null != BillCheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillCheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SalesListConfig.class)) {
            isValid = null != SalesListConfig.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SalesListConfig.class.getSimpleName());
            }
        }
        if(clazz.equals(BackOrig.class)) {
            isValid = null != BackOrig.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BackOrig.class.getSimpleName());
            }
        }
        if(clazz.equals(CalculateStatus.class)) {
            isValid = null != CalculateStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CalculateStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatus.class)) {
            isValid = null != HandleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OkOrFail.class)) {
            isValid = null != OkOrFail.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OkOrFail.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadStatus.class)) {
            isValid = null != UploadStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UploadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ExpensesType.class)) {
            isValid = null != ExpensesType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExpensesType.class.getSimpleName());
            }
        }
        if(clazz.equals(CommitStatus.class)) {
            isValid = null != CommitStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CommitStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillCodeSubType.class)) {
            isValid = null != BillCodeSubType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillCodeSubType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskType.class)) {
            isValid = null != TaskType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskHistoryType.class)) {
            isValid = null != TaskHistoryType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaskHistoryType.class.getSimpleName());
            }
        }
        if(clazz.equals(OperationEntity.class)) {
            isValid = null != OperationEntity.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OperationEntity.class.getSimpleName());
            }
        }
        if(clazz.equals(OperationType.class)) {
            isValid = null != OperationType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OperationType.class.getSimpleName());
            }
        }
        if(clazz.equals(VehicleSheet.class)) {
            isValid = null != VehicleSheet.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VehicleSheet.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessType.class)) {
            isValid = null != BusinessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(FileOperationType.class)) {
            isValid = null != FileOperationType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FileOperationType.class.getSimpleName());
            }
        }
        if(clazz.equals(TransformStatus.class)) {
            isValid = null != TransformStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TransformStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillUse.class)) {
            isValid = null != BillUse.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillUse.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemOrigExternal.class)) {
            isValid = null != SystemOrigExternal.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SystemOrigExternal.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareStatus.class)) {
            isValid = null != CompareStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CompareStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ManyModel.class)) {
            isValid = null != ManyModel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ManyModel.class.getSimpleName());
            }
        }
        if(clazz.equals(BillTypeCode.class)) {
            isValid = null != BillTypeCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillTypeCode.class.getSimpleName());
            }
        }
        if(clazz.equals(PayStatus.class)) {
            isValid = null != PayStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MachineCode.class)) {
            isValid = null != MachineCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MachineCode.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleDefineEnums.class)) {
            isValid = null != RuleDefineEnums.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RuleDefineEnums.class.getSimpleName());
            }
        }
        if(clazz.equals(DeployMode.class)) {
            isValid = null != DeployMode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DeployMode.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageExt2.class)) {
            isValid = null != ImageExt2.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageExt2.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageExt4.class)) {
            isValid = null != ImageExt4.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageExt4.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageExt6.class)) {
            isValid = null != ImageExt6.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageExt6.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageExt8.class)) {
            isValid = null != ImageExt8.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageExt8.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageExt10.class)) {
            isValid = null != ImageExt10.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageExt10.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessLogType.class)) {
            isValid = null != BusinessLogType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessLogType.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementType.class)) {
            isValid = null != SettlementType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SettlementType.class.getSimpleName());
            }
        }
        if(clazz.equals(TicketCheckOptions.class)) {
            isValid = null != TicketCheckOptions.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TicketCheckOptions.class.getSimpleName());
            }
        }
        if(clazz.equals(TicketCheckIcons.class)) {
            isValid = null != TicketCheckIcons.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TicketCheckIcons.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckSignStatus.class)) {
            isValid = null != CheckSignStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckSignStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = null != ChargeUpStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = null != PaymentStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditBackStatus.class)) {
            isValid = null != AuditBackStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditBackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeSystem.class)) {
            isValid = null != IncomeSystem.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IncomeSystem.class.getSimpleName());
            }
        }
        if(clazz.equals(PayeeSubject.class)) {
            isValid = null != PayeeSubject.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PayeeSubject.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckCategory.class)) {
            isValid = null != CheckCategory.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckType.class)) {
            isValid = null != CheckType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckType.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckGroup.class)) {
            isValid = null != CheckGroup.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckGroup.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomsFormType.class)) {
            isValid = null != CustomsFormType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CustomsFormType.class.getSimpleName());
            }
        }
        if(clazz.equals(HttpMethod.class)) {
            isValid = null != HttpMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HttpMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(ReimbursementStatus.class)) {
            isValid = null != ReimbursementStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReimbursementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsHooked.class)) {
            isValid = null != IsHooked.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsHooked.class.getSimpleName());
            }
        }
        if(clazz.equals(TransformScene.class)) {
            isValid = null != TransformScene.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TransformScene.class.getSimpleName());
            }
        }
        if(clazz.equals(SnaphostFormat.class)) {
            isValid = null != SnaphostFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnaphostFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MultipurposeTicketModel.class)) {
            isValid = null != MultipurposeTicketModel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MultipurposeTicketModel.class.getSimpleName());
            }
        }
        if(clazz.equals(ManySplitUrlModel.class)) {
            isValid = null != ManySplitUrlModel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ManySplitUrlModel.class.getSimpleName());
            }
        }
        if(clazz.equals(IsConfirm.class)) {
            isValid = null != IsConfirm.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsConfirm.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiveStatus.class)) {
            isValid = null != ReceiveStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceiveStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(BillCheckOptions.class)) {
            isValid = null != BillCheckOptions.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillCheckOptions.class.getSimpleName());
            }
        }
        if(clazz.equals(BillCheckIcons.class)) {
            isValid = null != BillCheckIcons.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillCheckIcons.class.getSimpleName());
            }
        }
        if(clazz.equals(VoucherType.class)) {
            isValid = null != VoucherType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VoucherType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
