package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据检测项
 * </p>
 *
 * @author ultraman
 * @since 2023-10-26
 */
public enum BillCheckOptions {

    COMPARE_COUNT_CHECK("compare_count_check", "张数不一致异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillCheckOptions(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillCheckOptions fromCode(String code) {
        return Stream.of(BillCheckOptions.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
