package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-26
 */
public enum BillDataStatus {

    _0("0", "待提交"),
    _2("2", "暂挂起"),
    _6("6", "已提交"),
    _3("3", "已锁定"),
    _4("4", "已退回"),
    _5("5", "已作废"),
    _1("1", "已完成");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillDataStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillDataStatus fromCode(String code) {
        return Stream.of(BillDataStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
