package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 计算状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-26
 */
public enum CalculateStatus {

    _0("0", "默认"),
    _1("1", "已完成"),
    _99("99", "计算中");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CalculateStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CalculateStatus fromCode(String code) {
        return Stream.of(CalculateStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
