package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 检测种类
 * </p>
 *
 * @author ultraman
 * @since 2023-10-26
 */
public enum CheckCategory {

    BILL("BILL", "单据"),
    TICKET("TICKET", "单证"),
    COOP("COOP", "协同"),
    COMPARE_BILL("COMPARE_BILL", "收单单据"),
    COMPARE_TICKET("COMPARE_TICKET", "收单单证");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckCategory fromCode(String code) {
        return Stream.of(CheckCategory.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
