package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 费报类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-26
 */
public enum ExpensesType {

    _0("0", "-"),
    _1("1", "差旅报销单"),
    _2("2", "费用报销单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExpensesType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExpensesType fromCode(String code) {
        return Stream.of(ExpensesType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
