package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 收入系统
 * </p>
 *
 * @author ultraman
 * @since 2023-10-26
 */
public enum IncomeSystem {

    _1("1", "税务系统"),
    _2("2", "海关系统");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IncomeSystem(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IncomeSystem fromCode(String code) {
        return Stream.of(IncomeSystem.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
