package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 页面代码
 * </p>
 *
 * @author ultraman
 * @since 2023-10-26
 */
public enum PageCode {

    SCAN("scan", "影像采集"),
    ADVANCE_PAYMENT("advancePayment", "预付款"),
    PERSON_TICKET("personTicket", "个人单证池"),
    SCAN_DETAIL("scanDetail", "影像详情");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PageCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PageCode fromCode(String code) {
        return Stream.of(PageCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
