package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 科目
 * </p>
 *
 * @author ultraman
 * @since 2023-10-26
 */
public enum PayeeSubject {

    _1("1", "进口增值税"),
    _2("2", "进口关税"),
    _3("3", "进口消费税"),
    _4("4", "特别关税"),
    _5("5", "进口废弃电子电器产品处理基金");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PayeeSubject(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PayeeSubject fromCode(String code) {
        return Stream.of(PayeeSubject.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
