package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 识别状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-26
 */
public enum RecStatus {

    _0("0", "等待识别"),
    _1("1", "正在识别"),
    _2("2", "识别完成"),
    _3("3", "识别失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RecStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecStatus fromCode(String code) {
        return Stream.of(RecStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
