package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 外部系统来源
 * </p>
 *
 * @author ultraman
 * @since 2023-10-26
 */
public enum SystemOrigExternal {

    _0("0", "-");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SystemOrigExternal(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SystemOrigExternal fromCode(String code) {
        return Stream.of(SystemOrigExternal.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
