package com.xforceplus.ultraman.app.imagesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * ticket
 * </p>
 *
 * @author ultraman
 * @since 2023-10-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Ticket implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 影像ID
   */
  private Long imageId;
  /**
   * 业务单号
   */
  private String billCode;
  /**
   * 扫描批次号
   */
  private String batchNo;
  /**
   * 预警状态
   */
  private String warningStatus;
  /**
   * 预警信息
   */
  private String warningInfo;
  /**
   * 异常状态
   */
  private String exceptionStatus;
  /**
   * 异常信息
   */
  private String exceptionInfo;
  /**
   * 验真状态
   */
  private String checkStatus;
  /**
   * 验真备注
   */
  private String checkRemark;
  /**
   * 验真任务ID
   */
  private String checkTaskId;
  /**
   * 验真请求时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkRequestTime;
  /**
   * 验真返回时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkResponseTime;
  /**
   * 验真人ID
   */
  private Long checkUserId;
  /**
   * 验真人姓名
   */
  private String checkUserName;
  /**
   * 是否已挂接
   */
  private String isHooked;
  /**
   * x点坐标
   */
  private Long xPoint;
  /**
   * y点坐标
   */
  private Long yPoint;
  /**
   * 宽度
   */
  private Long width;
  /**
   * 高度
   */
  private Long height;
  /**
   * 角度
   */
  private Long angle;
  /**
   * 单证Code
   */
  private String ticketCode;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 是否公共
   */
  private String isPublic;
  /**
   * 扩展字段
   */
  private String extFields;
  /**
   * 是否复用
   */
  private String isReuse;
  /**
   * 单证状态
   */
  private String ticketStatus;
  /**
   * 保留字段1
   */
  private String reserved1;
  /**
   * 保留字段2
   */
  private String reserved2;
  /**
   * 保留字段3
   */
  private String reserved3;
  /**
   * 是否重复
   */
  private String isRepeat;
  /**
   * 重复标识
   */
  private String repeatTag;
  /**
   * 用户代码
   */
  private String createUserCode;
  /**
   * 系统来源
   */
  private String systemOrig;
  /**
   * 上传所属单据对象
   */
  private String billEntityCode;
  /**
   * 复用标识
   */
  private String reuseTag;
  /**
   * 租户名称
   */
  private String tenantCode;
  /**
   * 退回状态
   */
  private String backStatus;
  /**
   * 退回时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime backTime;
  /**
   * 扫描人ID
   */
  private Long scanUserId;
  /**
   * 扫描人名称
   */
  private String scanUserName;
  /**
   * 是否有销货清单
   */
  private String isSalesList;
  /**
   * 计算状态
   */
  private String calculateStatus;
  /**
   * 单证校验状态
   */
  private String ticketCheckStatus;
  /**
   * 处理状态
   */
  private String handleStatus;
  /**
   * 发票提交状态
   */
  private String commitStatus;
  /**
   * 提交人ID
   */
  private Long commitUserId;
  /**
   * 提交人姓名
   */
  private String commitUserName;
  /**
   * 提交时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime commitTime;
  /**
   * 挂接时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime hookTime;
  /**
   * 退回类型
   */
  private String backType;
  /**
   * 退回原因
   */
  private String backReason;
  /**
   * 退回备注
   */
  private String backRemark;
  /**
   * 退回人
   */
  private String backUser;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 上传状态
   */
  private String uploadStatus;
  /**
   * 购方编号
   */
  private String purchaserNo;
  /**
   * 购方代码
   */
  private String purchaserCode;
  /**
   * 销方编号
   */
  private String sellerNo;
  /**
   * 销方代码
   */
  private String sellerCode;
  /**
   * 扫描时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime scanTime;
  /**
   * 发票状态
   */
  private String invoiceStatus;
  /**
   * 所属组织ID
   */
  private Long orgId;
  /**
   * 所属组织
   */
  private String orgName;
  /**
   * 所属组织代码
   */
  private String orgCode;
  /**
   * 备注
   */
  private String remark;
  /**
   * 原发票代码
   */
  private String originInvoiceCode;
  /**
   * 原发票号码
   */
  private String originInvoiceNo;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 校验码
   */
  private String checkCode;
  /**
   * 发票联次
   */
  private String invoiceSheet;
  /**
   * 机器编码
   */
  private String machineCode;
  /**
   * 密文
   */
  private String cipherText;
  /**
   * 收款人
   */
  private String payee;
  /**
   * 复核人
   */
  private String recheck;
  /**
   * 开票人
   */
  private String drawer;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 是否税局代开
   */
  private String isReplace;
  /**
   * 特殊发票标记
   */
  private String specialInvoiceFlag;
  /**
   * 购方地址
   */
  private String purchaserAddress;
  /**
   * 购方电话
   */
  private String purchaserTel;
  /**
   * 购方地址电话
   */
  private String purchaserAddrTel;
  /**
   * 购方银行名称
   */
  private String purchaserBankName;
  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;
  /**
   * 购方银行名称账号
   */
  private String purchaserBankNameAccount;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方电话
   */
  private String sellerTel;
  /**
   * 销方地址电话
   */
  private String sellerAddrTel;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 销方银行账号
   */
  private String sellerBankAccount;
  /**
   * 销方银行名称账号
   */
  private String sellerBankNameAccount;
  /**
   * 机动车类型
   */
  private String vehicleType;
  /**
   * 机动车品牌
   */
  private String vehicleBrand;
  /**
   * 产地
   */
  private String productionArea;
  /**
   * 引擎编号
   */
  private String engineNo;
  /**
   * 商检单号
   */
  private String commodityInspectionNo;
  /**
   * 合格证号
   */
  private String certificationNo;
  /**
   * 车辆编号
   */
  private String vehicleNo;
  /**
   * 进口编号
   */
  private String importCertificateNo;
  /**
   * 税务局编码
   */
  private String chargeTaxAuthorityCode;
  /**
   * 税务局名称
   */
  private String chargeTaxAuthorityName;
  /**
   * 主管税务机关
   */
  private String taxPaidProof;
  /**
   * 吨位
   */
  private String tonnage;
  /**
   * 最大载人数
   */
  private String maxCapacity;
  /**
   * 地区编码
   */
  private String dqCode;
  /**
   * 地区名称
   */
  private String dqName;
  /**
   * 是否电票
   */
  private String isElectricInvoice;
  /**
   * 是否有源文件
   */
  private String isSourceFile;
  /**
   * 电票版式
   */
  private String sourceFileType;
  /**
   * 币种
   */
  private String currencyType;
  /**
   * 发票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrewDate;
  /**
   * 是否连号
   */
  private String isJoin;
  /**
   * 二维码
   */
  private String qrcode;
  /**
   * 打印发票代码
   */
  private String invoiceCodeP;
  /**
   * 打印发票号码
   */
  private String invoiceNoP;
  /**
   * 系统来源
   */
  private String systemSource;
  /**
   * 单证初始值
   */
  private String ticketInitialValue;
  /**
   * 是否变更
   */
  private String isChange;
  /**
   * 单证变更值
   */
  private String ticketChangeValue;
  /**
   * 个人备注
   */
  private String personRemark;
  /**
   * 是否新增
   */
  private String isAdd;
  /**
   * 是否有章
   */
  private String isStamper;
  /**
   * 单据类型
   */
  private String billTypeCode;
  /**
   * 流水号
   */
  private String serialNumber;
  /**
   * 是否存在其他联次
   */
  private String isExistSheet;
  /**
   * 异常类型
   */
  private String exceptionKey;
  /**
   * 异常明细
   */
  private String exceptionDetail;
  /**
   * 预警类型
   */
  private String warningKey;
  /**
   * 预警明细
   */
  private String warningDetail;
  /**
   * 验签状态
   */
  private String checkSignStatus;
  /**
   * 验签备注
   */
  private String checkSignRemark;
  /**
   * 验签任务ID
   */
  private String checkSignTaskId;
  /**
   * 验签请求时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkSignRequestTime;
  /**
   * 验签人ID
   */
  private Long checkSignUserId;
  /**
   * 验签人姓名
   */
  private String checkSignUserName;
  /**
   * 记账状态	
   */
  private String chargeUpStatus;
  /**
   * 记账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeUpPeriod;
  /**
   * 记账单号
   */
  private String chargeUpNo;
  /**
   * 记账金额
   */
  private BigDecimal chargeUpAmount;
  /**
   * 付款状态	
   */
  private String paymentStatus;
  /**
   * 付款单号
   */
  private String paymentNo;
  /**
   * 付款金额
   */
  private BigDecimal paymentAmount;
  /**
   * 占用金额
   */
  private BigDecimal usedAmount;
  /**
   * 余额
   */
  private BigDecimal balanceAmount;
  /**
   * 记账人
   */
  private String chargeUpPerson;
  /**
   * 付款人姓名
   */
  private String paymentUserName;
  /**
   * 是否原始发票
   */
  private String isOriginalTicket;
  /**
   * 三方业务凭证(id或key)
   */
  private String businessKey;
  /**
   * 签收状态
   */
  private String signForStatus;
  /**
   * 明细标签
   */
  private String allSystemLabels;
  /**
   * 付款日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;
  /**
   * 是否采集发票
   */
  private String isCollection;
  /**
   * 终审退回状态
   */
  private String auditBackStatus;
  /**
   * 验真解决方案
   */
  private String checkSolution;
  /**
   * 区域组织代码
   */
  private String areaCode;
  /**
   * 区域组织名称
   */
  private String areaName;
  /**
   * 根组织
   */
  private String rootRegion;
  /**
   * 自定义组织
   */
  private String customRegion;
  /**
   * 报销状态
   */
  private String reimbursementStatus;
  /**
   * 国税ofd地址
   */
  private String ofdUrl;
  /**
   * 国税pdf地址
   */
  private String pdfUrl;
  /**
   * 国税xml地址
   */
  private String xmlUrl;
  /**
   * 扩展字段1
   */
  private String ext1;
  /**
   * 扩展字段2
   */
  private String ext2;
  /**
   * 扩展字段3
   */
  private String ext3;
  /**
   * 扩展字段4
   */
  private String ext4;
  /**
   * 扩展字段5
   */
  private String ext5;
  /**
   * 扩展字段6
   */
  private String ext6;
  /**
   * 扩展字段7
   */
  private String ext7;
  /**
   * 扩展字段8
   */
  private String ext8;
  /**
   * 扩展字段9
   */
  private String ext9;
  /**
   * 扩展字段10
   */
  private String ext10;
  /**
   * 是覆盖单证
   */
  private Boolean isCoverTicket;
  /**
   * 单证比对状态
   */
  private String compareStatus;
  /**
   * 是复制新增单证
   */
  private Boolean copyFlag;
  /**
   * 原影像ID
   */
  private Long mainImageId;
  /**
   * 发票原始位置url
   */
  private String originMoreUrl;
  /**
   * 报销时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reimbursementTime;
  /**
   * 单据系统来源
   */
  private String billSystemSource;
  /**
   * 已删除
   */
  private Boolean isDelete;
  /**
   * 是否产值回挂
   */
  private Boolean isReplaceOrder;

  /**
   * 对一关联关系 关联对象 image
   */
  private Long imageOTMTicketId;
  /**
   * 对一关联关系 关联对象 baseBill
   */
  private Long billOTMTicketId;
  /**
   * 对一关联关系 关联对象 ticket
   */
  private Long ticketOTMTicketId;
  /**
   * 对一关联关系 关联对象 orgInfo
   */
  private Long areaId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("image_id", imageId);
      map.put("bill_code", billCode);
      map.put("batch_no", batchNo);
      map.put("warning_status", warningStatus);
      map.put("warning_info", warningInfo);
      map.put("exception_status", exceptionStatus);
      map.put("exception_info", exceptionInfo);
      map.put("check_status", checkStatus);
      map.put("check_remark", checkRemark);
      map.put("check_task_id", checkTaskId);
      map.put("check_request_time", BocpGenUtils.toTimestamp(checkRequestTime));
      map.put("check_response_time", BocpGenUtils.toTimestamp(checkResponseTime));
      map.put("check_user_id", checkUserId);
      map.put("check_user_name", checkUserName);
      map.put("is_hooked", isHooked);
      map.put("x_point", xPoint);
      map.put("y_point", yPoint);
      map.put("width", width);
      map.put("height", height);
      map.put("angle", angle);
      map.put("ticket_code", ticketCode);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("amount_with_tax", amountWithTax);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("is_public", isPublic);
      map.put("ext_fields", extFields);
      map.put("is_reuse", isReuse);
      map.put("ticket_status", ticketStatus);
      map.put("reserved1", reserved1);
      map.put("reserved2", reserved2);
      map.put("reserved3", reserved3);
      map.put("is_repeat", isRepeat);
      map.put("repeat_tag", repeatTag);
      map.put("create_user_code", createUserCode);
      map.put("system_orig", systemOrig);
      map.put("bill_entity_code", billEntityCode);
      map.put("reuse_tag", reuseTag);
      map.put("tenant_code", tenantCode);
      map.put("back_status", backStatus);
      map.put("back_time", BocpGenUtils.toTimestamp(backTime));
      map.put("scan_user_id", scanUserId);
      map.put("scan_user_name", scanUserName);
      map.put("is_sales_list", isSalesList);
      map.put("calculate_status", calculateStatus);
      map.put("ticket_check_status", ticketCheckStatus);
      map.put("handle_status", handleStatus);
      map.put("commit_status", commitStatus);
      map.put("commit_user_id", commitUserId);
      map.put("commit_user_name", commitUserName);
      map.put("commit_time", BocpGenUtils.toTimestamp(commitTime));
      map.put("hook_time", BocpGenUtils.toTimestamp(hookTime));
      map.put("back_type", backType);
      map.put("back_reason", backReason);
      map.put("back_remark", backRemark);
      map.put("back_user", backUser);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_date", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("upload_status", uploadStatus);
      map.put("purchaser_no", purchaserNo);
      map.put("purchaser_code", purchaserCode);
      map.put("seller_no", sellerNo);
      map.put("seller_code", sellerCode);
      map.put("scan_time", BocpGenUtils.toTimestamp(scanTime));
      map.put("invoice_status", invoiceStatus);
      map.put("org_id", orgId);
      map.put("org_name", orgName);
      map.put("org_code", orgCode);
      map.put("remark", remark);
      map.put("origin_invoice_code", originInvoiceCode);
      map.put("origin_invoice_no", originInvoiceNo);
      map.put("invoice_type", invoiceType);
      map.put("check_code", checkCode);
      map.put("invoice_sheet", invoiceSheet);
      map.put("machine_code", machineCode);
      map.put("cipher_text", cipherText);
      map.put("payee", payee);
      map.put("recheck", recheck);
      map.put("drawer", drawer);
      map.put("tax_rate", taxRate);
      map.put("is_replace", isReplace);
      map.put("special_invoice_flag", specialInvoiceFlag);
      map.put("purchaser_address", purchaserAddress);
      map.put("purchaser_tel", purchaserTel);
      map.put("purchaser_addr_tel", purchaserAddrTel);
      map.put("purchaser_bank_name", purchaserBankName);
      map.put("purchaser_bank_account", purchaserBankAccount);
      map.put("purchaser_bank_name_account", purchaserBankNameAccount);
      map.put("seller_address", sellerAddress);
      map.put("seller_tel", sellerTel);
      map.put("seller_addr_tel", sellerAddrTel);
      map.put("seller_bank_name", sellerBankName);
      map.put("seller_bank_account", sellerBankAccount);
      map.put("seller_bank_name_account", sellerBankNameAccount);
      map.put("vehicle_type", vehicleType);
      map.put("vehicle_brand", vehicleBrand);
      map.put("production_area", productionArea);
      map.put("engine_no", engineNo);
      map.put("commodity_inspection_no", commodityInspectionNo);
      map.put("certification_no", certificationNo);
      map.put("vehicle_no", vehicleNo);
      map.put("import_certificate_no", importCertificateNo);
      map.put("charge_tax_authority_code", chargeTaxAuthorityCode);
      map.put("charge_tax_authority_name", chargeTaxAuthorityName);
      map.put("tax_paid_proof", taxPaidProof);
      map.put("tonnage", tonnage);
      map.put("max_capacity", maxCapacity);
      map.put("dq_code", dqCode);
      map.put("dq_name", dqName);
      map.put("is_electric_invoice", isElectricInvoice);
      map.put("is_source_file", isSourceFile);
      map.put("source_file_type", sourceFileType);
      map.put("currency_type", currencyType);
      map.put("paper_drew_date", BocpGenUtils.toTimestamp(paperDrewDate));
      map.put("is_join", isJoin);
      map.put("qrcode", qrcode);
      map.put("invoice_code_p", invoiceCodeP);
      map.put("invoice_no_p", invoiceNoP);
      map.put("system_source", systemSource);
      map.put("ticket_initial_value", ticketInitialValue);
      map.put("is_change", isChange);
      map.put("ticket_change_value", ticketChangeValue);
      map.put("person_remark", personRemark);
      map.put("is_add", isAdd);
      map.put("is_stamper", isStamper);
      map.put("bill_type_code", billTypeCode);
      map.put("serial_number", serialNumber);
      map.put("is_exist_sheet", isExistSheet);
      map.put("exception_key", exceptionKey);
      map.put("exception_detail", exceptionDetail);
      map.put("warning_key", warningKey);
      map.put("warning_detail", warningDetail);
      map.put("check_sign_status", checkSignStatus);
      map.put("check_sign_remark", checkSignRemark);
      map.put("check_sign_task_id", checkSignTaskId);
      map.put("check_sign_request_time", BocpGenUtils.toTimestamp(checkSignRequestTime));
      map.put("check_sign_user_id", checkSignUserId);
      map.put("check_sign_user_name", checkSignUserName);
      map.put("charge_up_status", chargeUpStatus);
      map.put("charge_up_period", BocpGenUtils.toTimestamp(chargeUpPeriod));
      map.put("charge_up_no", chargeUpNo);
      map.put("charge_up_amount", chargeUpAmount);
      map.put("payment_status", paymentStatus);
      map.put("payment_no", paymentNo);
      map.put("payment_amount", paymentAmount);
      map.put("used_amount", usedAmount);
      map.put("balance_amount", balanceAmount);
      map.put("charge_up_person", chargeUpPerson);
      map.put("payment_user_name", paymentUserName);
      map.put("is_original_ticket", isOriginalTicket);
      map.put("business_key", businessKey);
      map.put("sign_for_status", signForStatus);
      map.put("all_system_labels", allSystemLabels);
      map.put("payment_date", BocpGenUtils.toTimestamp(paymentDate));
      map.put("is_collection", isCollection);
      map.put("audit_back_status", auditBackStatus);
      map.put("check_solution", checkSolution);
      map.put("area_code", areaCode);
      map.put("area_name", areaName);
      map.put("root_region", rootRegion);
      map.put("custom_region", customRegion);
      map.put("reimbursement_status", reimbursementStatus);
      map.put("ofd_url", ofdUrl);
      map.put("pdf_url", pdfUrl);
      map.put("xml_url", xmlUrl);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("is_cover_ticket", isCoverTicket);
      map.put("compare_status", compareStatus);
      map.put("copy_flag", copyFlag);
      map.put("main_image_id", mainImageId);
      map.put("origin_more_url", originMoreUrl);
      map.put("reimbursement_time", BocpGenUtils.toTimestamp(reimbursementTime));
      map.put("bill_system_source", billSystemSource);
      map.put("is_delete", isDelete);
      map.put("is_replace_order", isReplaceOrder);

      map.put("imageOTMTicket.id", imageOTMTicketId);
      map.put("billOTMTicket.id", billOTMTicketId);
      map.put("ticketOTMTicket.id", ticketOTMTicketId);
      map.put("area.id", areaId);
      return map;
  }

  public static Ticket fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Ticket entity = new Ticket();

    if(map.containsKey("image_id")) {
      Object obj = map.get("image_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setImageId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_status")) {
      Object obj = map.get("warning_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarningStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_info")) {
      Object obj = map.get("warning_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarningInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_status")) {
      Object obj = map.get("exception_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_status")) {
      Object obj = map.get("check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_remark")) {
      Object obj = map.get("check_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_task_id")) {
      Object obj = map.get("check_task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_request_time")) {
      Object obj = map.get("check_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckRequestTime(null);
      }
    }
    if(map.containsKey("check_response_time")) {
      Object obj = map.get("check_response_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckResponseTime(null);
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_hooked")) {
      Object obj = map.get("is_hooked");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsHooked((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("x_point")) {
      Object obj = map.get("x_point");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setXPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setXPoint(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("y_point")) {
      Object obj = map.get("y_point");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setYPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setYPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setYPoint(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("width")) {
      Object obj = map.get("width");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWidth((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWidth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setWidth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("height")) {
      Object obj = map.get("height");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHeight((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setHeight(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setHeight(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("angle")) {
      Object obj = map.get("angle");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAngle((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAngle(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAngle(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ticket_code")) {
      Object obj = map.get("ticket_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsPublic((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext_fields")) {
      Object obj = map.get("ext_fields");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtFields((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_reuse")) {
      Object obj = map.get("is_reuse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsReuse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_status")) {
      Object obj = map.get("ticket_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserved1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserved2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserved3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_repeat")) {
      Object obj = map.get("is_repeat");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsRepeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("repeat_tag")) {
      Object obj = map.get("repeat_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRepeatTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_entity_code")) {
      Object obj = map.get("bill_entity_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillEntityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reuse_tag")) {
      Object obj = map.get("reuse_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReuseTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_status")) {
      Object obj = map.get("back_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_time")) {
      Object obj = map.get("back_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBackTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBackTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBackTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBackTime(null);
      }
    }
    if(map.containsKey("scan_user_id")) {
      Object obj = map.get("scan_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setScanUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setScanUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("scan_user_name")) {
      Object obj = map.get("scan_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setScanUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_sales_list")) {
      Object obj = map.get("is_sales_list");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsSalesList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("calculate_status")) {
      Object obj = map.get("calculate_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCalculateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_check_status")) {
      Object obj = map.get("ticket_check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handle_status")) {
      Object obj = map.get("handle_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_status")) {
      Object obj = map.get("commit_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCommitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_id")) {
      Object obj = map.get("commit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCommitUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCommitUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_name")) {
      Object obj = map.get("commit_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCommitUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_time")) {
      Object obj = map.get("commit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCommitTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCommitTime(null);
      }
    }
    if(map.containsKey("hook_time")) {
      Object obj = map.get("hook_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHookTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setHookTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setHookTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setHookTime(null);
      }
    }
    if(map.containsKey("back_type")) {
      Object obj = map.get("back_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_reason")) {
      Object obj = map.get("back_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_remark")) {
      Object obj = map.get("back_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_user")) {
      Object obj = map.get("back_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_date")) {
      Object obj = map.get("invoice_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upload_status")) {
      Object obj = map.get("upload_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUploadStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_code")) {
      Object obj = map.get("purchaser_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scan_time")) {
      Object obj = map.get("scan_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setScanTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setScanTime(null);
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_sheet")) {
      Object obj = map.get("invoice_sheet");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceSheet((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recheck")) {
      Object obj = map.get("recheck");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("drawer")) {
      Object obj = map.get("drawer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDrawer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_replace")) {
      Object obj = map.get("is_replace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsReplace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("special_invoice_flag")) {
      Object obj = map.get("special_invoice_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name_account")) {
      Object obj = map.get("purchaser_bank_name_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name_account")) {
      Object obj = map.get("seller_bank_name_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_brand")) {
      Object obj = map.get("vehicle_brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("production_area")) {
      Object obj = map.get("production_area");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductionArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("engine_no")) {
      Object obj = map.get("engine_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEngineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commodity_inspection_no")) {
      Object obj = map.get("commodity_inspection_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCommodityInspectionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("certification_no")) {
      Object obj = map.get("certification_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCertificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_no")) {
      Object obj = map.get("vehicle_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("import_certificate_no")) {
      Object obj = map.get("import_certificate_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImportCertificateNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_tax_authority_code")) {
      Object obj = map.get("charge_tax_authority_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeTaxAuthorityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_tax_authority_name")) {
      Object obj = map.get("charge_tax_authority_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeTaxAuthorityName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_paid_proof")) {
      Object obj = map.get("tax_paid_proof");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPaidProof((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTonnage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("max_capacity")) {
      Object obj = map.get("max_capacity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaxCapacity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dq_code")) {
      Object obj = map.get("dq_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDqCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dq_name")) {
      Object obj = map.get("dq_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDqName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_electric_invoice")) {
      Object obj = map.get("is_electric_invoice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsElectricInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_source_file")) {
      Object obj = map.get("is_source_file");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsSourceFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source_file_type")) {
      Object obj = map.get("source_file_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency_type")) {
      Object obj = map.get("currency_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrencyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("is_join")) {
      Object obj = map.get("is_join");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsJoin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qrcode")) {
      Object obj = map.get("qrcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQrcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code_p")) {
      Object obj = map.get("invoice_code_p");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCodeP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no_p")) {
      Object obj = map.get("invoice_no_p");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNoP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_initial_value")) {
      Object obj = map.get("ticket_initial_value");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketInitialValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_change")) {
      Object obj = map.get("is_change");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsChange((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_change_value")) {
      Object obj = map.get("ticket_change_value");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketChangeValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("person_remark")) {
      Object obj = map.get("person_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPersonRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_add")) {
      Object obj = map.get("is_add");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsAdd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_stamper")) {
      Object obj = map.get("is_stamper");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsStamper((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type_code")) {
      Object obj = map.get("bill_type_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSerialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_exist_sheet")) {
      Object obj = map.get("is_exist_sheet");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsExistSheet((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_key")) {
      Object obj = map.get("exception_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_detail")) {
      Object obj = map.get("exception_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_key")) {
      Object obj = map.get("warning_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarningKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_detail")) {
      Object obj = map.get("warning_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarningDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_sign_status")) {
      Object obj = map.get("check_sign_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckSignStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_sign_remark")) {
      Object obj = map.get("check_sign_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckSignRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_sign_task_id")) {
      Object obj = map.get("check_sign_task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckSignTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_sign_request_time")) {
      Object obj = map.get("check_sign_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckSignRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckSignRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckSignRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckSignRequestTime(null);
      }
    }
    if(map.containsKey("check_sign_user_id")) {
      Object obj = map.get("check_sign_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckSignUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckSignUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCheckSignUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_sign_user_name")) {
      Object obj = map.get("check_sign_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckSignUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeUpPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeUpPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeUpPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeUpPeriod(null);
      }
    }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_amount")) {
      Object obj = map.get("charge_up_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChargeUpAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChargeUpAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChargeUpAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeUpAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChargeUpAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_no")) {
      Object obj = map.get("payment_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_amount")) {
      Object obj = map.get("payment_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("used_amount")) {
      Object obj = map.get("used_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUsedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUsedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUsedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUsedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUsedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("balance_amount")) {
      Object obj = map.get("balance_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBalanceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBalanceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBalanceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBalanceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBalanceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_person")) {
      Object obj = map.get("charge_up_person");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_user_name")) {
      Object obj = map.get("payment_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_original_ticket")) {
      Object obj = map.get("is_original_ticket");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsOriginalTicket((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_key")) {
      Object obj = map.get("business_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_for_status")) {
      Object obj = map.get("sign_for_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSignForStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("all_system_labels")) {
      Object obj = map.get("all_system_labels");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllSystemLabels((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_date")) {
      Object obj = map.get("payment_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("is_collection")) {
      Object obj = map.get("is_collection");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCollection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_back_status")) {
      Object obj = map.get("audit_back_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditBackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_solution")) {
      Object obj = map.get("check_solution");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckSolution((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area_code")) {
      Object obj = map.get("area_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAreaCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area_name")) {
      Object obj = map.get("area_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAreaName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("root_region")) {
      Object obj = map.get("root_region");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRootRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custom_region")) {
      Object obj = map.get("custom_region");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reimbursement_status")) {
      Object obj = map.get("reimbursement_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReimbursementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ofd_url")) {
      Object obj = map.get("ofd_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOfdUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdf_url")) {
      Object obj = map.get("pdf_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xml_url")) {
      Object obj = map.get("xml_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_cover_ticket")) {
      Object obj = map.get("is_cover_ticket");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsCoverTicket((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsCoverTicket(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("compare_status")) {
      Object obj = map.get("compare_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompareStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("copy_flag")) {
      Object obj = map.get("copy_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setCopyFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCopyFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("main_image_id")) {
      Object obj = map.get("main_image_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMainImageId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMainImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMainImageId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("origin_more_url")) {
      Object obj = map.get("origin_more_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginMoreUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reimbursement_time")) {
      Object obj = map.get("reimbursement_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReimbursementTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReimbursementTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReimbursementTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReimbursementTime(null);
      }
    }
    if(map.containsKey("bill_system_source")) {
      Object obj = map.get("bill_system_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillSystemSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_delete")) {
      Object obj = map.get("is_delete");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsDelete((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("is_replace_order")) {
      Object obj = map.get("is_replace_order");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsReplaceOrder((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsReplaceOrder(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }

    if(map.containsKey("imageOTMTicket.id")) {
       Object obj = map.get("imageOTMTicket.id");
       if(obj instanceof Long) {
         entity.setImageOTMTicketId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setImageOTMTicketId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("billOTMTicket.id")) {
       Object obj = map.get("billOTMTicket.id");
       if(obj instanceof Long) {
         entity.setBillOTMTicketId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setBillOTMTicketId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("ticketOTMTicket.id")) {
       Object obj = map.get("ticketOTMTicket.id");
       if(obj instanceof Long) {
         entity.setTicketOTMTicketId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setTicketOTMTicketId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("area.id")) {
       Object obj = map.get("area.id");
       if(obj instanceof Long) {
         entity.setAreaId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setAreaId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("image_id")) {
      Object obj = map.get("image_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setImageId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setImageId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_status")) {
      Object obj = map.get("warning_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWarningStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_info")) {
      Object obj = map.get("warning_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWarningInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_status")) {
      Object obj = map.get("exception_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExceptionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExceptionInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_status")) {
      Object obj = map.get("check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_remark")) {
      Object obj = map.get("check_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_task_id")) {
      Object obj = map.get("check_task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_request_time")) {
      Object obj = map.get("check_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCheckRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCheckRequestTime(null);
      }
    }
    if(map.containsKey("check_response_time")) {
      Object obj = map.get("check_response_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckResponseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCheckResponseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckResponseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCheckResponseTime(null);
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_hooked")) {
      Object obj = map.get("is_hooked");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsHooked((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("x_point")) {
      Object obj = map.get("x_point");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setXPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setXPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setXPoint(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("y_point")) {
      Object obj = map.get("y_point");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setYPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setYPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setYPoint(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("width")) {
      Object obj = map.get("width");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setWidth((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setWidth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setWidth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("height")) {
      Object obj = map.get("height");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setHeight((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setHeight(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setHeight(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("angle")) {
      Object obj = map.get("angle");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAngle((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAngle(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setAngle(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ticket_code")) {
      Object obj = map.get("ticket_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTicketCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsPublic((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext_fields")) {
      Object obj = map.get("ext_fields");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExtFields((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_reuse")) {
      Object obj = map.get("is_reuse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsReuse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_status")) {
      Object obj = map.get("ticket_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTicketStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReserved1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReserved2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReserved3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_repeat")) {
      Object obj = map.get("is_repeat");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsRepeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("repeat_tag")) {
      Object obj = map.get("repeat_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRepeatTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_entity_code")) {
      Object obj = map.get("bill_entity_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillEntityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reuse_tag")) {
      Object obj = map.get("reuse_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReuseTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_status")) {
      Object obj = map.get("back_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_time")) {
      Object obj = map.get("back_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBackTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setBackTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBackTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setBackTime(null);
      }
    }
    if(map.containsKey("scan_user_id")) {
      Object obj = map.get("scan_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setScanUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setScanUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setScanUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("scan_user_name")) {
      Object obj = map.get("scan_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setScanUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_sales_list")) {
      Object obj = map.get("is_sales_list");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsSalesList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("calculate_status")) {
      Object obj = map.get("calculate_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCalculateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_check_status")) {
      Object obj = map.get("ticket_check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTicketCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handle_status")) {
      Object obj = map.get("handle_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_status")) {
      Object obj = map.get("commit_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCommitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_id")) {
      Object obj = map.get("commit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCommitUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCommitUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCommitUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_name")) {
      Object obj = map.get("commit_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCommitUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_time")) {
      Object obj = map.get("commit_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCommitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCommitTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCommitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCommitTime(null);
      }
    }
    if(map.containsKey("hook_time")) {
      Object obj = map.get("hook_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setHookTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setHookTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setHookTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setHookTime(null);
      }
    }
    if(map.containsKey("back_type")) {
      Object obj = map.get("back_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBackType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_reason")) {
      Object obj = map.get("back_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBackReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_remark")) {
      Object obj = map.get("back_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBackRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_user")) {
      Object obj = map.get("back_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBackUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_date")) {
      Object obj = map.get("invoice_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setInvoiceDate(null);
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upload_status")) {
      Object obj = map.get("upload_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUploadStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_code")) {
      Object obj = map.get("purchaser_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scan_time")) {
      Object obj = map.get("scan_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setScanTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setScanTime(null);
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_sheet")) {
      Object obj = map.get("invoice_sheet");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceSheet((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recheck")) {
      Object obj = map.get("recheck");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("drawer")) {
      Object obj = map.get("drawer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDrawer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_replace")) {
      Object obj = map.get("is_replace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsReplace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("special_invoice_flag")) {
      Object obj = map.get("special_invoice_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_address")) {
      Object obj = map.get("purchaser_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tel")) {
      Object obj = map.get("purchaser_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name")) {
      Object obj = map.get("purchaser_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_account")) {
      Object obj = map.get("purchaser_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name_account")) {
      Object obj = map.get("purchaser_bank_name_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_address")) {
      Object obj = map.get("seller_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tel")) {
      Object obj = map.get("seller_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name")) {
      Object obj = map.get("seller_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_account")) {
      Object obj = map.get("seller_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name_account")) {
      Object obj = map.get("seller_bank_name_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVehicleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_brand")) {
      Object obj = map.get("vehicle_brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVehicleBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("production_area")) {
      Object obj = map.get("production_area");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setProductionArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("engine_no")) {
      Object obj = map.get("engine_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEngineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commodity_inspection_no")) {
      Object obj = map.get("commodity_inspection_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCommodityInspectionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("certification_no")) {
      Object obj = map.get("certification_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCertificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_no")) {
      Object obj = map.get("vehicle_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVehicleNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("import_certificate_no")) {
      Object obj = map.get("import_certificate_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setImportCertificateNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_tax_authority_code")) {
      Object obj = map.get("charge_tax_authority_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeTaxAuthorityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_tax_authority_name")) {
      Object obj = map.get("charge_tax_authority_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeTaxAuthorityName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_paid_proof")) {
      Object obj = map.get("tax_paid_proof");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxPaidProof((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTonnage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("max_capacity")) {
      Object obj = map.get("max_capacity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMaxCapacity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dq_code")) {
      Object obj = map.get("dq_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDqCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dq_name")) {
      Object obj = map.get("dq_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDqName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_electric_invoice")) {
      Object obj = map.get("is_electric_invoice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsElectricInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_source_file")) {
      Object obj = map.get("is_source_file");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsSourceFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source_file_type")) {
      Object obj = map.get("source_file_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSourceFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency_type")) {
      Object obj = map.get("currency_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCurrencyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("is_join")) {
      Object obj = map.get("is_join");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsJoin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qrcode")) {
      Object obj = map.get("qrcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setQrcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code_p")) {
      Object obj = map.get("invoice_code_p");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCodeP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no_p")) {
      Object obj = map.get("invoice_no_p");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNoP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSystemSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_initial_value")) {
      Object obj = map.get("ticket_initial_value");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTicketInitialValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_change")) {
      Object obj = map.get("is_change");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsChange((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_change_value")) {
      Object obj = map.get("ticket_change_value");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTicketChangeValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("person_remark")) {
      Object obj = map.get("person_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPersonRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_add")) {
      Object obj = map.get("is_add");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsAdd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_stamper")) {
      Object obj = map.get("is_stamper");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsStamper((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type_code")) {
      Object obj = map.get("bill_type_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSerialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_exist_sheet")) {
      Object obj = map.get("is_exist_sheet");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsExistSheet((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_key")) {
      Object obj = map.get("exception_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExceptionKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_detail")) {
      Object obj = map.get("exception_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExceptionDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_key")) {
      Object obj = map.get("warning_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWarningKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_detail")) {
      Object obj = map.get("warning_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWarningDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_sign_status")) {
      Object obj = map.get("check_sign_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckSignStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_sign_remark")) {
      Object obj = map.get("check_sign_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckSignRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_sign_task_id")) {
      Object obj = map.get("check_sign_task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckSignTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_sign_request_time")) {
      Object obj = map.get("check_sign_request_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckSignRequestTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCheckSignRequestTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckSignRequestTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCheckSignRequestTime(null);
      }
    }
    if(map.containsKey("check_sign_user_id")) {
      Object obj = map.get("check_sign_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckSignUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckSignUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCheckSignUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_sign_user_name")) {
      Object obj = map.get("check_sign_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckSignUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setChargeUpPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setChargeUpPeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setChargeUpPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setChargeUpPeriod(null);
      }
    }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeUpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_amount")) {
      Object obj = map.get("charge_up_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setChargeUpAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setChargeUpAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setChargeUpAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setChargeUpAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setChargeUpAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_no")) {
      Object obj = map.get("payment_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_amount")) {
      Object obj = map.get("payment_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPaymentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPaymentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPaymentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaymentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPaymentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("used_amount")) {
      Object obj = map.get("used_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUsedAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUsedAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUsedAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUsedAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUsedAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("balance_amount")) {
      Object obj = map.get("balance_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBalanceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBalanceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBalanceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBalanceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBalanceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_person")) {
      Object obj = map.get("charge_up_person");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeUpPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_user_name")) {
      Object obj = map.get("payment_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_original_ticket")) {
      Object obj = map.get("is_original_ticket");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsOriginalTicket((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_key")) {
      Object obj = map.get("business_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_for_status")) {
      Object obj = map.get("sign_for_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSignForStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("all_system_labels")) {
      Object obj = map.get("all_system_labels");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAllSystemLabels((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_date")) {
      Object obj = map.get("payment_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaymentDate(null);
      }
    }
    if(map.containsKey("is_collection")) {
      Object obj = map.get("is_collection");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIsCollection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_back_status")) {
      Object obj = map.get("audit_back_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuditBackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_solution")) {
      Object obj = map.get("check_solution");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckSolution((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area_code")) {
      Object obj = map.get("area_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAreaCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area_name")) {
      Object obj = map.get("area_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAreaName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("root_region")) {
      Object obj = map.get("root_region");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRootRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custom_region")) {
      Object obj = map.get("custom_region");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reimbursement_status")) {
      Object obj = map.get("reimbursement_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReimbursementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ofd_url")) {
      Object obj = map.get("ofd_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOfdUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdf_url")) {
      Object obj = map.get("pdf_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xml_url")) {
      Object obj = map.get("xml_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_cover_ticket")) {
      Object obj = map.get("is_cover_ticket");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsCoverTicket((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsCoverTicket(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("compare_status")) {
      Object obj = map.get("compare_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompareStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("copy_flag")) {
      Object obj = map.get("copy_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setCopyFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCopyFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("main_image_id")) {
      Object obj = map.get("main_image_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMainImageId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMainImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setMainImageId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("origin_more_url")) {
      Object obj = map.get("origin_more_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginMoreUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reimbursement_time")) {
      Object obj = map.get("reimbursement_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReimbursementTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReimbursementTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReimbursementTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReimbursementTime(null);
      }
    }
    if(map.containsKey("bill_system_source")) {
      Object obj = map.get("bill_system_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillSystemSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_delete")) {
      Object obj = map.get("is_delete");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsDelete((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("is_replace_order")) {
      Object obj = map.get("is_replace_order");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setIsReplaceOrder((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIsReplaceOrder(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
  if(map.containsKey("imageOTMTicket.id")) {
    Object obj = map.get("imageOTMTicket.id");
    if(obj instanceof Long) {
        this.setImageOTMTicketId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setImageOTMTicketId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("billOTMTicket.id")) {
    Object obj = map.get("billOTMTicket.id");
    if(obj instanceof Long) {
        this.setBillOTMTicketId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setBillOTMTicketId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("ticketOTMTicket.id")) {
    Object obj = map.get("ticketOTMTicket.id");
    if(obj instanceof Long) {
        this.setTicketOTMTicketId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setTicketOTMTicketId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("area.id")) {
    Object obj = map.get("area.id");
    if(obj instanceof Long) {
        this.setAreaId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setAreaId(Long.parseLong((String)obj));
    }
  }
  }
}
