package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * audit_back_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum AuditBackStatus {

    _0("0", "未退回"),
    _1("1", "已退回");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuditBackStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuditBackStatus fromCode(String code) {
        return Stream.of(AuditBackStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
