package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * back_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum BackType {

    _0("0", "全选"),
    _1("1", "审批驳回"),
    _2("2", "核验退回");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BackType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BackType fromCode(String code) {
        return Stream.of(BackType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
