package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_type_code
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum BillTypeCode {

    A("A", "扫描发票"),
    B("B", "扫描无订单发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillTypeCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillTypeCode fromCode(String code) {
        return Stream.of(BillTypeCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
