package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * check_group
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum CheckGroup {

    _1("1", "基础校验"),
    _2("2", "业务敏感信息校验"),
    _3("3", "挂接关系校验");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckGroup(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckGroup fromCode(String code) {
        return Stream.of(CheckGroup.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
