package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * config_data_mapping_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum ConfigDataMappingType {

    _1("1", "单据"),
    _2("2", "单证"),
    _3("3", "附件");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ConfigDataMappingType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ConfigDataMappingType fromCode(String code) {
        return Stream.of(ConfigDataMappingType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
