package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * image_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum ImageType {

    _1("1", "单据"),
    _2("2", "单证"),
    _3("3", "多票"),
    _99("99", "附件"),
    _4("4", "其他"),
    _5("5", "文件"),
    _9("9", "销货清单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImageType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImageType fromCode(String code) {
        return Stream.of(ImageType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
