package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_hooked
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum IsHooked {

    _0("0", "未挂接"),
    _1("1", "已挂接");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsHooked(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsHooked fromCode(String code) {
        return Stream.of(IsHooked.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
