package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_public
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum IsPublic {

    _0("0", "个人单证"),
    _1("1", "影像采集"),
    _2("2", "扫描待办"),
    _3("3", "协同采集");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsPublic(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsPublic fromCode(String code) {
        return Stream.of(IsPublic.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
