package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * many_model
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum ManyModel {

    _0("0", "多票模式"),
    _1("1", "拆票模式"),
    _2("2", "无多票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ManyModel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ManyModel fromCode(String code) {
        return Stream.of(ManyModel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
