package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * many_split_url_model
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum ManySplitUrlModel {

    _0("0", "切割地址"),
    _1("1", "多票原始位置地址");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ManySplitUrlModel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ManySplitUrlModel fromCode(String code) {
        return Stream.of(ManySplitUrlModel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
