package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * operation_entity
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum OperationEntity {

    BILL("bill", "单据"),
    TICKET("ticket", "单证"),
    IMAGE("image", "影像");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OperationEntity(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperationEntity fromCode(String code) {
        return Stream.of(OperationEntity.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
