package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sales_list_config
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum SalesListConfig {

    _0("0", "不启用"),
    _1("1", "异常"),
    _2("2", "预警");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SalesListConfig(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesListConfig fromCode(String code) {
        return Stream.of(SalesListConfig.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
