package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * special_invoice_flag
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum SpecialInvoiceFlag {

    _0("0", "无"),
    _1("1", "成品油"),
    _2("2", "通行费（可抵扣）"),
    _3("3", "区块链"),
    _5("5", "建筑服务"),
    _6("6", "货物运输服务"),
    _7("7", "不动产销售"),
    _8("8", "不动产经营租赁服务"),
    _9("9", "旅客运输服务");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SpecialInvoiceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SpecialInvoiceFlag fromCode(String code) {
        return Stream.of(SpecialInvoiceFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
