package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * transform_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum TransformStatus {

    _0("0", "无需转换"),
    _1("1", "转换中"),
    _2("2", "转换完成"),
    _3("3", "转换失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TransformStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TransformStatus fromCode(String code) {
        return Stream.of(TransformStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
