package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * voucher_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public enum VoucherType {

    T("t", "火车票"),
    P("p", "飞机票行程单"),
    BUS("bus", "客运票"),
    WITHHOLD("withhold", "代扣代缴通用缴款书");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VoucherType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VoucherType fromCode(String code) {
        return Stream.of(VoucherType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
