package com.xforceplus.ultraman.app.imagesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * ticket_customs_payment
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketCustomsPayment extends Ticket {

  /**
   * 海关口岸
   */
  private String customName;
  /**
   * 收入系统
   */
  private String incomeSystem;
  /**
   * 收入机关
   */
  private String payeeAuthority;
  /**
   * 科目
   */
  private String payeeSubject;
  /**
   * 预算级次
   */
  private String payeeBudgetLevel;
  /**
   * 收款国库
   */
  private String payeeTreasury;
  /**
   * 收款国库账号
   */
  private String payeeTreasuryId;
  /**
   * 缴款单位账号
   */
  private String payerAccount;
  /**
   * 缴款单位开户行
   */
  private String payerBank;
  /**
   * 金额人民币（大写）
   */
  private String amountCapital;
  /**
   * 申请单位编号
   */
  private String applicationCode;
  /**
   * 报关单编号
   */
  private String declarationFormNo;
  /**
   * 合同（批文）号
   */
  private String contractNo;
  /**
   * 运输工具（号）
   */
  private String transportNo;
  /**
   * 缴款期限
   */
  private String electronicPayPeriod;
  /**
   * 提/装货单号
   */
  private String pickLoadCode;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("custom_name", customName);
      map.put("income_system", incomeSystem);
      map.put("payee_authority", payeeAuthority);
      map.put("payee_subject", payeeSubject);
      map.put("payee_budget_level", payeeBudgetLevel);
      map.put("payee_treasury", payeeTreasury);
      map.put("payee_treasury_id", payeeTreasuryId);
      map.put("payer_account", payerAccount);
      map.put("payer_bank", payerBank);
      map.put("amount_capital", amountCapital);
      map.put("application_code", applicationCode);
      map.put("declaration_form_no", declarationFormNo);
      map.put("contract_no", contractNo);
      map.put("transport_no", transportNo);
      map.put("electronic_pay_period", electronicPayPeriod);
      map.put("pick_load_code", pickLoadCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static TicketCustomsPayment fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketCustomsPayment entity = new TicketCustomsPayment();

    entity.setParentByOQSMap(map);
    if(map.containsKey("custom_name")) {
      Object obj = map.get("custom_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("income_system")) {
      Object obj = map.get("income_system");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIncomeSystem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee_authority")) {
      Object obj = map.get("payee_authority");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayeeAuthority((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee_subject")) {
      Object obj = map.get("payee_subject");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayeeSubject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee_budget_level")) {
      Object obj = map.get("payee_budget_level");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayeeBudgetLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee_treasury")) {
      Object obj = map.get("payee_treasury");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayeeTreasury((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee_treasury_id")) {
      Object obj = map.get("payee_treasury_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayeeTreasuryId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_account")) {
      Object obj = map.get("payer_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_bank")) {
      Object obj = map.get("payer_bank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayerBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_capital")) {
      Object obj = map.get("amount_capital");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountCapital((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("application_code")) {
      Object obj = map.get("application_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplicationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("declaration_form_no")) {
      Object obj = map.get("declaration_form_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeclarationFormNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract_no")) {
      Object obj = map.get("contract_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transport_no")) {
      Object obj = map.get("transport_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransportNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronic_pay_period")) {
      Object obj = map.get("electronic_pay_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElectronicPayPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pick_load_code")) {
      Object obj = map.get("pick_load_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPickLoadCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("custom_name")) {
      Object obj = map.get("custom_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCustomName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("income_system")) {
      Object obj = map.get("income_system");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIncomeSystem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee_authority")) {
      Object obj = map.get("payee_authority");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayeeAuthority((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee_subject")) {
      Object obj = map.get("payee_subject");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayeeSubject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee_budget_level")) {
      Object obj = map.get("payee_budget_level");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayeeBudgetLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee_treasury")) {
      Object obj = map.get("payee_treasury");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayeeTreasury((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee_treasury_id")) {
      Object obj = map.get("payee_treasury_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayeeTreasuryId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_account")) {
      Object obj = map.get("payer_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_bank")) {
      Object obj = map.get("payer_bank");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayerBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_capital")) {
      Object obj = map.get("amount_capital");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAmountCapital((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("application_code")) {
      Object obj = map.get("application_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setApplicationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("declaration_form_no")) {
      Object obj = map.get("declaration_form_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeclarationFormNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contract_no")) {
      Object obj = map.get("contract_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transport_no")) {
      Object obj = map.get("transport_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTransportNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronic_pay_period")) {
      Object obj = map.get("electronic_pay_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setElectronicPayPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pick_load_code")) {
      Object obj = map.get("pick_load_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPickLoadCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
