package com.xforceplus.ultraman.app.imagesaas.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2023-11-06
*/
public class EntityMeta {
    public interface Image {
        static Long id() {
            return 1295238096603955201L;
        }
        static String code() {
            return "image";
        }
        TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "image_type");
        TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "image_source");
        TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "require_ocr_flag");
        TypedField<String> FILE_URL = new TypedField<>(String.class, "file_url");
        TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "file_url_handle");
        TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "file_url_origin");
        TypedField<String> FILE_TYPE = new TypedField<>(String.class, "file_type");
        TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "file_type_handle");
        TypedField<String> FILE_ORDER = new TypedField<>(String.class, "file_order");
        TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "file_level");
        TypedField<String> REC_STATUS = new TypedField<>(String.class, "rec_status");
        TypedField<String> TASK_ID = new TypedField<>(String.class, "task_id");
        TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "copy_count");
        TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "rec_start_time");
        TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "rec_end_time");
        TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "bill_image_id");
        TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "ticket_image_id");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "is_manual_unhook");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "return_status");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "image_category");
        TypedField<String> RETURN_REASON = new TypedField<>(String.class, "return_reason");
        TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "return_remark");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "file_url_local");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> PAGE_CODE = new TypedField<>(String.class, "page_code");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "more_file_url");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "return_type");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> FILE_NAME = new TypedField<>(String.class, "file_name");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<Long> FILE_ID = new TypedField<>(Long.class, "file_id");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "ticket_pre_data");
        TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "file_all_images");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_IMAGE_ID = new TypedField<>(Long.class, "billOTMImage.id");
        /**
         * 对一关联关系 关联对象 imageFile
         */
        TypedField<Long> IMAGE_FILE_O_T_M_IMAGE_ID = new TypedField<>(Long.class, "imageFileOTMImage.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_O_T_M_IMAGE {
                static String code () {
                    return "billOTMImage" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMImage.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMImage.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMImage.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMImage.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMImage.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMImage.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMImage.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMImage.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMImage.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMImage.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMImage.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMImage.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMImage.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMImage.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMImage.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMImage.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMImage.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMImage.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMImage.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMImage.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMImage.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMImage.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMImage.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMImage.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMImage.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMImage.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMImage.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMImage.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMImage.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMImage.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMImage.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMImage.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMImage.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMImage.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMImage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMImage.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMImage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMImage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMImage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMImage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMImage.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMImage.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMImage.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMImage.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMImage.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMImage.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMImage.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMImage.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMImage.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMImage.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMImage.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMImage.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMImage.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMImage.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMImage.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMImage.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMImage.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMImage.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMImage.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMImage.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMImage.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMImage.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMImage.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMImage.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMImage.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMImage.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMImage.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMImage.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMImage.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMImage.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMImage.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMImage.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMImage.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMImage.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMImage.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMImage.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMImage.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMImage.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMImage.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMImage.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMImage.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMImage.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMImage.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMImage.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMImage.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMImage.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMImage.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMImage.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMImage.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMImage.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMImage.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMImage.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMImage.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMImage.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMImage.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMImage.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMImage.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMImage.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMImage.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMImage.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMImage.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMImage.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMImage.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMImage.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMImage.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMImage.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMImage.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMImage.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMImage.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMImage.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMImage.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMImage.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMImage.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMImage.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMImage.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMImage.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMImage.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMImage.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMImage.back_flag");
            }
            interface IMAGE_FILE_O_T_M_IMAGE {
                static String code () {
                    return "imageFileOTMImage" ;
                }
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageFileOTMImage.file_url");
                TypedField<String> FILE_SUFFIX = new TypedField<>(String.class, "imageFileOTMImage.file_suffix");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageFileOTMImage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageFileOTMImage.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageFileOTMImage.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageFileOTMImage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageFileOTMImage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageFileOTMImage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageFileOTMImage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageFileOTMImage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageFileOTMImage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageFileOTMImage.delete_flag");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageFileOTMImage.task_id");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageFileOTMImage.file_name");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageFileOTMImage.bill_code");
                TypedField<String> BUSINESS_FILE_TYPE = new TypedField<>(String.class, "imageFileOTMImage.business_file_type");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageFileOTMImage.bill_entity_code");
                TypedField<String> TENANT = new TypedField<>(String.class, "imageFileOTMImage.tenant");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "imageFileOTMImage.system_orig");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageFileOTMImage.is_public");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageFileOTMImage.require_ocr_flag");
                TypedField<String> IS_TRANSFORM = new TypedField<>(String.class, "imageFileOTMImage.is_transform");
                TypedField<String> ATTACHMENT_NAME = new TypedField<>(String.class, "imageFileOTMImage.attachment_name");
                TypedField<String> FILE_OPERATION_TYPE = new TypedField<>(String.class, "imageFileOTMImage.file_operation_type");
                TypedField<String> TRANSFORM_STATUS = new TypedField<>(String.class, "imageFileOTMImage.transform_status");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageFileOTMImage.create_user_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageFileOTMImage.batch_no");
                TypedField<String> FILE_KEY = new TypedField<>(String.class, "imageFileOTMImage.file_key");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageFileOTMImage.file_order");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageFileOTMImage.serial_number");
                TypedField<String> TRANSFORM_TYPE = new TypedField<>(String.class, "imageFileOTMImage.transform_type");
                TypedField<String> TASK_TYPE = new TypedField<>(String.class, "imageFileOTMImage.task_type");
                TypedField<String> EXT = new TypedField<>(String.class, "imageFileOTMImage.ext");
                TypedField<String> FILE_MD5 = new TypedField<>(String.class, "imageFileOTMImage.file_md5");
                TypedField<String> TRANSFORM_SCENE = new TypedField<>(String.class, "imageFileOTMImage.transform_scene");
            }
        }
    }
    public interface Ticket {
        static Long id() {
            return 1295238137703940097L;
        }
        static String code() {
            return "ticket";
        }
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> IS_JOIN = new TypedField<>(String.class, "is_join");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticket_initial_value");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticket_change_value");
        TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "person_remark");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_STAMPER = new TypedField<>(String.class, "is_stamper");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "is_exist_sheet");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "check_sign_status");
        TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "check_sign_remark");
        TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "check_sign_task_id");
        TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_sign_request_time");
        TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "check_sign_user_id");
        TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "check_sign_user_name");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "charge_up_amount");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment_amount");
        TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "used_amount");
        TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "balance_amount");
        TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "charge_up_person");
        TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "payment_user_name");
        TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "is_original_ticket");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "business_key");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "all_system_labels");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "is_collection");
        TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "audit_back_status");
        TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "check_solution");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<String> ROOT_REGION = new TypedField<>(String.class, "root_region");
        TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "custom_region");
        TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "reimbursement_status");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofd_url");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdf_url");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xml_url");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "is_cover_ticket");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "copy_flag");
        TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "main_image_id");
        TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "origin_more_url");
        TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "reimbursement_time");
        TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "bill_system_source");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "is_delete");
        TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "is_replace_order");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_O_T_M_TICKET_ID = new TypedField<>(Long.class, "imageOTMTicket.id");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_TICKET_ID = new TypedField<>(Long.class, "billOTMTicket.id");
        /**
         * 对一关联关系 关联对象 ticket
         */
        TypedField<Long> TICKET_O_T_M_TICKET_ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> AREA_ID = new TypedField<>(Long.class, "area.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_O_T_M_TICKET {
                static String code () {
                    return "imageOTMTicket" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageOTMTicket.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageOTMTicket.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageOTMTicket.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageOTMTicket.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageOTMTicket.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageOTMTicket.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageOTMTicket.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageOTMTicket.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageOTMTicket.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageOTMTicket.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageOTMTicket.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageOTMTicket.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageOTMTicket.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageOTMTicket.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageOTMTicket.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageOTMTicket.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageOTMTicket.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageOTMTicket.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageOTMTicket.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageOTMTicket.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageOTMTicket.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageOTMTicket.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageOTMTicket.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageOTMTicket.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageOTMTicket.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageOTMTicket.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageOTMTicket.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageOTMTicket.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageOTMTicket.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageOTMTicket.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageOTMTicket.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageOTMTicket.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageOTMTicket.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageOTMTicket.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageOTMTicket.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageOTMTicket.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageOTMTicket.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageOTMTicket.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageOTMTicket.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageOTMTicket.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageOTMTicket.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageOTMTicket.file_all_images");
            }
            interface BILL_O_T_M_TICKET {
                static String code () {
                    return "billOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMTicket.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMTicket.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMTicket.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMTicket.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMTicket.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMTicket.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMTicket.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMTicket.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMTicket.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMTicket.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMTicket.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMTicket.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMTicket.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMTicket.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMTicket.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMTicket.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMTicket.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMTicket.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMTicket.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMTicket.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMTicket.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMTicket.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMTicket.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMTicket.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMTicket.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMTicket.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMTicket.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMTicket.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMTicket.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMTicket.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMTicket.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMTicket.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMTicket.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMTicket.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMTicket.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMTicket.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMTicket.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMTicket.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMTicket.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMTicket.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMTicket.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMTicket.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMTicket.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMTicket.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMTicket.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMTicket.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMTicket.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMTicket.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMTicket.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMTicket.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMTicket.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMTicket.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMTicket.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMTicket.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMTicket.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMTicket.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMTicket.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMTicket.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMTicket.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMTicket.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMTicket.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMTicket.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMTicket.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMTicket.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMTicket.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMTicket.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMTicket.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMTicket.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMTicket.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMTicket.back_flag");
            }
            interface TICKET_O_T_M_TICKET {
                static String code () {
                    return "ticketOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "ticketOTMTicket.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "ticketOTMTicket.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "ticketOTMTicket.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "ticketOTMTicket.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "ticketOTMTicket.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "ticketOTMTicket.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "ticketOTMTicket.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "ticketOTMTicket.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "ticketOTMTicket.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "ticketOTMTicket.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "ticketOTMTicket.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticketOTMTicket.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "ticketOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.delete_flag");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "ticketOTMTicket.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ticketOTMTicket.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "ticketOTMTicket.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "ticketOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "ticketOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "ticketOTMTicket.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "ticketOTMTicket.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "ticketOTMTicket.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "ticketOTMTicket.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "ticketOTMTicket.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "ticketOTMTicket.reuse_tag");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "ticketOTMTicket.tenant_code");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "ticketOTMTicket.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "ticketOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "ticketOTMTicket.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "ticketOTMTicket.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "ticketOTMTicket.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "ticketOTMTicket.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "ticketOTMTicket.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "ticketOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "ticketOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "ticketOTMTicket.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "ticketOTMTicket.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "ticketOTMTicket.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "ticketOTMTicket.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "ticketOTMTicket.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "ticketOTMTicket.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "ticketOTMTicket.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "ticketOTMTicket.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "ticketOTMTicket.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "ticketOTMTicket.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "ticketOTMTicket.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "ticketOTMTicket.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "ticketOTMTicket.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "ticketOTMTicket.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "ticketOTMTicket.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "ticketOTMTicket.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "ticketOTMTicket.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "ticketOTMTicket.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "ticketOTMTicket.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "ticketOTMTicket.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "ticketOTMTicket.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "ticketOTMTicket.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "ticketOTMTicket.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "ticketOTMTicket.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "ticketOTMTicket.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "ticketOTMTicket.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "ticketOTMTicket.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "ticketOTMTicket.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "ticketOTMTicket.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "ticketOTMTicket.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "ticketOTMTicket.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "ticketOTMTicket.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "ticketOTMTicket.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "ticketOTMTicket.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "ticketOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "ticketOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "ticketOTMTicket.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "ticketOTMTicket.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "ticketOTMTicket.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "ticketOTMTicket.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "ticketOTMTicket.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "ticketOTMTicket.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "ticketOTMTicket.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "ticketOTMTicket.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "ticketOTMTicket.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "ticketOTMTicket.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "ticketOTMTicket.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "ticketOTMTicket.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "ticketOTMTicket.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "ticketOTMTicket.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "ticketOTMTicket.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "ticketOTMTicket.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "ticketOTMTicket.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "ticketOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "ticketOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "ticketOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "ticketOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "ticketOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "ticketOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "ticketOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "ticketOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "ticketOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "ticketOTMTicket.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "ticketOTMTicket.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "ticketOTMTicket.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "ticketOTMTicket.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "ticketOTMTicket.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "ticketOTMTicket.is_replace_order");
            }
            interface AREA {
                static String code () {
                    return "area" ;
                }
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "area.orgName");
                TypedField<Long> ID = new TypedField<>(Long.class, "area.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "area.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "area.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "area.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "area.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "area.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "area.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "area.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "area.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "area.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "area.orgId");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "area.orgCode");
            }
        }
    }
    public interface ImageCopy {
        static Long id() {
            return 1295238192150200322L;
        }
        static String code() {
            return "imageCopy";
        }
        TypedField<String> FILE_URL = new TypedField<>(String.class, "file_url");
        TypedField<String> COPY_NAME = new TypedField<>(String.class, "copy_name");
        TypedField<Long> PARENT_IMAGE_ID = new TypedField<>(Long.class, "parent_image_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> FILE_TYPE = new TypedField<>(String.class, "file_type");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_COPY_MANY_TO_ONE_IMAGE_ID = new TypedField<>(Long.class, "imageCopyManyToOneImage.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_COPY_MANY_TO_ONE_IMAGE {
                static String code () {
                    return "imageCopyManyToOneImage" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageCopyManyToOneImage.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageCopyManyToOneImage.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageCopyManyToOneImage.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageCopyManyToOneImage.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageCopyManyToOneImage.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageCopyManyToOneImage.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageCopyManyToOneImage.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageCopyManyToOneImage.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageCopyManyToOneImage.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageCopyManyToOneImage.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageCopyManyToOneImage.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageCopyManyToOneImage.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageCopyManyToOneImage.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageCopyManyToOneImage.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageCopyManyToOneImage.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageCopyManyToOneImage.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageCopyManyToOneImage.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageCopyManyToOneImage.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageCopyManyToOneImage.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageCopyManyToOneImage.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageCopyManyToOneImage.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageCopyManyToOneImage.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageCopyManyToOneImage.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageCopyManyToOneImage.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageCopyManyToOneImage.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageCopyManyToOneImage.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageCopyManyToOneImage.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageCopyManyToOneImage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageCopyManyToOneImage.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageCopyManyToOneImage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageCopyManyToOneImage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageCopyManyToOneImage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageCopyManyToOneImage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageCopyManyToOneImage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageCopyManyToOneImage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageCopyManyToOneImage.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageCopyManyToOneImage.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageCopyManyToOneImage.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageCopyManyToOneImage.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageCopyManyToOneImage.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageCopyManyToOneImage.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageCopyManyToOneImage.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageCopyManyToOneImage.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageCopyManyToOneImage.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageCopyManyToOneImage.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageCopyManyToOneImage.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageCopyManyToOneImage.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageCopyManyToOneImage.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageCopyManyToOneImage.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageCopyManyToOneImage.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageCopyManyToOneImage.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageCopyManyToOneImage.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageCopyManyToOneImage.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageCopyManyToOneImage.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageCopyManyToOneImage.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageCopyManyToOneImage.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageCopyManyToOneImage.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageCopyManyToOneImage.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageCopyManyToOneImage.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageCopyManyToOneImage.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageCopyManyToOneImage.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageCopyManyToOneImage.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageCopyManyToOneImage.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageCopyManyToOneImage.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageCopyManyToOneImage.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageCopyManyToOneImage.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageCopyManyToOneImage.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageCopyManyToOneImage.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageCopyManyToOneImage.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageCopyManyToOneImage.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageCopyManyToOneImage.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageCopyManyToOneImage.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageCopyManyToOneImage.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageCopyManyToOneImage.file_all_images");
            }
        }
    }
    public interface Label {
        static Long id() {
            return 1295238201528664065L;
        }
        static String code() {
            return "label";
        }
        TypedField<String> LABEL_NAME = new TypedField<>(String.class, "label_name");
        TypedField<String> LABEL_REMARK = new TypedField<>(String.class, "label_remark");
        TypedField<String> ENABLE = new TypedField<>(String.class, "enable");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }
    public interface ConfigDataMapping {
        static Long id() {
            return 1295238210894544898L;
        }
        static String code() {
            return "configDataMapping";
        }
        TypedField<String> CONFIG_DATA_MAPPING_CODE = new TypedField<>(String.class, "config_data_mapping_code");
        TypedField<String> CONFIG_DATA_MAPPING_REMARK = new TypedField<>(String.class, "config_data_mapping_remark");
        TypedField<String> ENABLE = new TypedField<>(String.class, "enable");
        TypedField<String> IS_DEFAULT = new TypedField<>(String.class, "is_default");
        TypedField<String> DOCUMENT_TYPE = new TypedField<>(String.class, "document_type");
        TypedField<String> CONFIG_DATA_MAPPING_TYPE = new TypedField<>(String.class, "config_data_mapping_type");
        TypedField<String> ENTITY_CODE = new TypedField<>(String.class, "entity_code");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> TENANT = new TypedField<>(Long.class, "tenant");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface ConfigDataMappingItem {
        static Long id() {
            return 1295238223943024641L;
        }
        static String code() {
            return "configDataMappingItem";
        }
        TypedField<String> META_FIELD = new TypedField<>(String.class, "meta_field");
        TypedField<String> CONFIG_DATA_MAPPING_ITEM_FIELDS = new TypedField<>(String.class, "config_data_mapping_item_fields");
        TypedField<Long> CONFIG_DATA_MAPPING_ID = new TypedField<>(Long.class, "config_data_mapping_id");
        TypedField<String> DEFAULT_VALUE = new TypedField<>(String.class, "default_value");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> VALUE_EXPRESSION = new TypedField<>(String.class, "value_expression");
        /**
         * 对一关联关系 关联对象 configDataMapping
         */
        TypedField<Long> CDM_M_ITEM_ID = new TypedField<>(Long.class, "cdmMItem.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface CDM_M_ITEM {
                static String code () {
                    return "cdmMItem" ;
                }
                TypedField<String> CONFIG_DATA_MAPPING_CODE = new TypedField<>(String.class, "cdmMItem.config_data_mapping_code");
                TypedField<String> CONFIG_DATA_MAPPING_REMARK = new TypedField<>(String.class, "cdmMItem.config_data_mapping_remark");
                TypedField<String> ENABLE = new TypedField<>(String.class, "cdmMItem.enable");
                TypedField<String> IS_DEFAULT = new TypedField<>(String.class, "cdmMItem.is_default");
                TypedField<String> DOCUMENT_TYPE = new TypedField<>(String.class, "cdmMItem.document_type");
                TypedField<String> CONFIG_DATA_MAPPING_TYPE = new TypedField<>(String.class, "cdmMItem.config_data_mapping_type");
                TypedField<String> ENTITY_CODE = new TypedField<>(String.class, "cdmMItem.entity_code");
                TypedField<Long> ID = new TypedField<>(Long.class, "cdmMItem.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "cdmMItem.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "cdmMItem.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "cdmMItem.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "cdmMItem.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "cdmMItem.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "cdmMItem.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "cdmMItem.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "cdmMItem.delete_flag");
                TypedField<Long> TENANT = new TypedField<>(Long.class, "cdmMItem.tenant");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "cdmMItem.tenant_code");
            }
        }
    }
    public interface TicketInvoice {
        static Long id() {
            return 1295238234588168194L;
        }
        static String code() {
            return "ticketInvoice";
        }
        TypedField<String> EXT = new TypedField<>(String.class, "ext");
        TypedField<String> CPY_STATUS = new TypedField<>(String.class, "cpy_status");
        TypedField<String> CT_STATUS = new TypedField<>(String.class, "ct_status");
        TypedField<String> REPLACE_TAX_NO = new TypedField<>(String.class, "replace_tax_no");
        TypedField<String> REPLACE_COMPANY_NAME = new TypedField<>(String.class, "replace_company_name");
        TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "all_electric_invoice_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> IS_JOIN = new TypedField<>(String.class, "is_join");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticket_initial_value");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticket_change_value");
        TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "person_remark");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_STAMPER = new TypedField<>(String.class, "is_stamper");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "is_exist_sheet");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "check_sign_status");
        TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "check_sign_remark");
        TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "check_sign_task_id");
        TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_sign_request_time");
        TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "check_sign_user_id");
        TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "check_sign_user_name");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "charge_up_amount");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment_amount");
        TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "used_amount");
        TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "balance_amount");
        TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "charge_up_person");
        TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "payment_user_name");
        TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "is_original_ticket");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "business_key");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "all_system_labels");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "is_collection");
        TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "audit_back_status");
        TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "check_solution");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<String> ROOT_REGION = new TypedField<>(String.class, "root_region");
        TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "custom_region");
        TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "reimbursement_status");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofd_url");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdf_url");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xml_url");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "is_cover_ticket");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "copy_flag");
        TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "main_image_id");
        TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "origin_more_url");
        TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "reimbursement_time");
        TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "bill_system_source");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "is_delete");
        TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "is_replace_order");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_O_T_M_TICKET_ID = new TypedField<>(Long.class, "imageOTMTicket.id");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_TICKET_ID = new TypedField<>(Long.class, "billOTMTicket.id");
        /**
         * 对一关联关系 关联对象 ticket
         */
        TypedField<Long> TICKET_O_T_M_TICKET_ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> AREA_ID = new TypedField<>(Long.class, "area.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_O_T_M_TICKET {
                static String code () {
                    return "imageOTMTicket" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageOTMTicket.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageOTMTicket.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageOTMTicket.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageOTMTicket.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageOTMTicket.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageOTMTicket.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageOTMTicket.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageOTMTicket.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageOTMTicket.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageOTMTicket.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageOTMTicket.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageOTMTicket.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageOTMTicket.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageOTMTicket.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageOTMTicket.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageOTMTicket.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageOTMTicket.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageOTMTicket.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageOTMTicket.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageOTMTicket.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageOTMTicket.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageOTMTicket.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageOTMTicket.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageOTMTicket.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageOTMTicket.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageOTMTicket.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageOTMTicket.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageOTMTicket.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageOTMTicket.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageOTMTicket.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageOTMTicket.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageOTMTicket.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageOTMTicket.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageOTMTicket.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageOTMTicket.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageOTMTicket.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageOTMTicket.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageOTMTicket.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageOTMTicket.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageOTMTicket.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageOTMTicket.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageOTMTicket.file_all_images");
            }
            interface BILL_O_T_M_TICKET {
                static String code () {
                    return "billOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMTicket.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMTicket.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMTicket.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMTicket.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMTicket.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMTicket.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMTicket.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMTicket.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMTicket.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMTicket.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMTicket.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMTicket.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMTicket.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMTicket.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMTicket.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMTicket.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMTicket.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMTicket.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMTicket.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMTicket.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMTicket.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMTicket.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMTicket.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMTicket.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMTicket.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMTicket.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMTicket.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMTicket.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMTicket.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMTicket.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMTicket.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMTicket.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMTicket.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMTicket.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMTicket.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMTicket.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMTicket.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMTicket.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMTicket.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMTicket.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMTicket.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMTicket.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMTicket.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMTicket.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMTicket.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMTicket.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMTicket.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMTicket.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMTicket.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMTicket.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMTicket.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMTicket.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMTicket.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMTicket.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMTicket.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMTicket.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMTicket.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMTicket.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMTicket.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMTicket.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMTicket.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMTicket.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMTicket.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMTicket.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMTicket.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMTicket.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMTicket.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMTicket.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMTicket.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMTicket.back_flag");
            }
            interface TICKET_O_T_M_TICKET {
                static String code () {
                    return "ticketOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "ticketOTMTicket.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "ticketOTMTicket.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "ticketOTMTicket.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "ticketOTMTicket.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "ticketOTMTicket.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "ticketOTMTicket.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "ticketOTMTicket.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "ticketOTMTicket.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "ticketOTMTicket.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "ticketOTMTicket.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "ticketOTMTicket.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticketOTMTicket.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "ticketOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.delete_flag");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "ticketOTMTicket.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ticketOTMTicket.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "ticketOTMTicket.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "ticketOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "ticketOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "ticketOTMTicket.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "ticketOTMTicket.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "ticketOTMTicket.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "ticketOTMTicket.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "ticketOTMTicket.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "ticketOTMTicket.reuse_tag");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "ticketOTMTicket.tenant_code");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "ticketOTMTicket.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "ticketOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "ticketOTMTicket.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "ticketOTMTicket.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "ticketOTMTicket.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "ticketOTMTicket.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "ticketOTMTicket.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "ticketOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "ticketOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "ticketOTMTicket.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "ticketOTMTicket.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "ticketOTMTicket.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "ticketOTMTicket.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "ticketOTMTicket.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "ticketOTMTicket.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "ticketOTMTicket.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "ticketOTMTicket.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "ticketOTMTicket.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "ticketOTMTicket.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "ticketOTMTicket.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "ticketOTMTicket.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "ticketOTMTicket.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "ticketOTMTicket.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "ticketOTMTicket.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "ticketOTMTicket.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "ticketOTMTicket.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "ticketOTMTicket.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "ticketOTMTicket.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "ticketOTMTicket.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "ticketOTMTicket.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "ticketOTMTicket.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "ticketOTMTicket.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "ticketOTMTicket.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "ticketOTMTicket.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "ticketOTMTicket.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "ticketOTMTicket.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "ticketOTMTicket.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "ticketOTMTicket.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "ticketOTMTicket.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "ticketOTMTicket.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "ticketOTMTicket.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "ticketOTMTicket.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "ticketOTMTicket.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "ticketOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "ticketOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "ticketOTMTicket.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "ticketOTMTicket.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "ticketOTMTicket.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "ticketOTMTicket.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "ticketOTMTicket.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "ticketOTMTicket.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "ticketOTMTicket.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "ticketOTMTicket.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "ticketOTMTicket.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "ticketOTMTicket.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "ticketOTMTicket.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "ticketOTMTicket.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "ticketOTMTicket.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "ticketOTMTicket.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "ticketOTMTicket.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "ticketOTMTicket.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "ticketOTMTicket.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "ticketOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "ticketOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "ticketOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "ticketOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "ticketOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "ticketOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "ticketOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "ticketOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "ticketOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "ticketOTMTicket.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "ticketOTMTicket.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "ticketOTMTicket.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "ticketOTMTicket.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "ticketOTMTicket.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "ticketOTMTicket.is_replace_order");
            }
            interface AREA {
                static String code () {
                    return "area" ;
                }
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "area.orgName");
                TypedField<Long> ID = new TypedField<>(Long.class, "area.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "area.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "area.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "area.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "area.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "area.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "area.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "area.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "area.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "area.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "area.orgId");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "area.orgCode");
            }
        }
    }
    public interface TicketTrain {
        static Long id() {
            return 1295238288791158786L;
        }
        static String code() {
            return "ticketTrain";
        }
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> TRAINS = new TypedField<>(String.class, "trains");
        TypedField<String> START_STATION = new TypedField<>(String.class, "start_station");
        TypedField<String> END_STATION = new TypedField<>(String.class, "end_station");
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "start_date");
        TypedField<String> START_TIME = new TypedField<>(String.class, "start_time");
        TypedField<String> SEAT = new TypedField<>(String.class, "seat");
        TypedField<String> SEAT_TYPE = new TypedField<>(String.class, "seat_type");
        TypedField<String> CERTIFICATE_NO = new TypedField<>(String.class, "certificate_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> IS_JOIN = new TypedField<>(String.class, "is_join");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticket_initial_value");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticket_change_value");
        TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "person_remark");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_STAMPER = new TypedField<>(String.class, "is_stamper");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "is_exist_sheet");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "check_sign_status");
        TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "check_sign_remark");
        TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "check_sign_task_id");
        TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_sign_request_time");
        TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "check_sign_user_id");
        TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "check_sign_user_name");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "charge_up_amount");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment_amount");
        TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "used_amount");
        TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "balance_amount");
        TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "charge_up_person");
        TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "payment_user_name");
        TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "is_original_ticket");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "business_key");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "all_system_labels");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "is_collection");
        TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "audit_back_status");
        TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "check_solution");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<String> ROOT_REGION = new TypedField<>(String.class, "root_region");
        TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "custom_region");
        TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "reimbursement_status");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofd_url");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdf_url");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xml_url");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "is_cover_ticket");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "copy_flag");
        TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "main_image_id");
        TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "origin_more_url");
        TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "reimbursement_time");
        TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "bill_system_source");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "is_delete");
        TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "is_replace_order");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_O_T_M_TICKET_ID = new TypedField<>(Long.class, "imageOTMTicket.id");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_TICKET_ID = new TypedField<>(Long.class, "billOTMTicket.id");
        /**
         * 对一关联关系 关联对象 ticket
         */
        TypedField<Long> TICKET_O_T_M_TICKET_ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> AREA_ID = new TypedField<>(Long.class, "area.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_O_T_M_TICKET {
                static String code () {
                    return "imageOTMTicket" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageOTMTicket.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageOTMTicket.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageOTMTicket.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageOTMTicket.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageOTMTicket.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageOTMTicket.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageOTMTicket.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageOTMTicket.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageOTMTicket.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageOTMTicket.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageOTMTicket.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageOTMTicket.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageOTMTicket.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageOTMTicket.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageOTMTicket.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageOTMTicket.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageOTMTicket.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageOTMTicket.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageOTMTicket.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageOTMTicket.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageOTMTicket.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageOTMTicket.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageOTMTicket.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageOTMTicket.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageOTMTicket.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageOTMTicket.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageOTMTicket.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageOTMTicket.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageOTMTicket.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageOTMTicket.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageOTMTicket.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageOTMTicket.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageOTMTicket.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageOTMTicket.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageOTMTicket.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageOTMTicket.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageOTMTicket.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageOTMTicket.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageOTMTicket.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageOTMTicket.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageOTMTicket.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageOTMTicket.file_all_images");
            }
            interface BILL_O_T_M_TICKET {
                static String code () {
                    return "billOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMTicket.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMTicket.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMTicket.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMTicket.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMTicket.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMTicket.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMTicket.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMTicket.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMTicket.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMTicket.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMTicket.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMTicket.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMTicket.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMTicket.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMTicket.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMTicket.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMTicket.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMTicket.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMTicket.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMTicket.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMTicket.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMTicket.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMTicket.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMTicket.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMTicket.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMTicket.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMTicket.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMTicket.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMTicket.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMTicket.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMTicket.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMTicket.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMTicket.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMTicket.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMTicket.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMTicket.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMTicket.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMTicket.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMTicket.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMTicket.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMTicket.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMTicket.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMTicket.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMTicket.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMTicket.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMTicket.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMTicket.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMTicket.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMTicket.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMTicket.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMTicket.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMTicket.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMTicket.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMTicket.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMTicket.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMTicket.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMTicket.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMTicket.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMTicket.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMTicket.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMTicket.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMTicket.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMTicket.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMTicket.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMTicket.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMTicket.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMTicket.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMTicket.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMTicket.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMTicket.back_flag");
            }
            interface TICKET_O_T_M_TICKET {
                static String code () {
                    return "ticketOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "ticketOTMTicket.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "ticketOTMTicket.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "ticketOTMTicket.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "ticketOTMTicket.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "ticketOTMTicket.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "ticketOTMTicket.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "ticketOTMTicket.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "ticketOTMTicket.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "ticketOTMTicket.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "ticketOTMTicket.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "ticketOTMTicket.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticketOTMTicket.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "ticketOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.delete_flag");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "ticketOTMTicket.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ticketOTMTicket.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "ticketOTMTicket.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "ticketOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "ticketOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "ticketOTMTicket.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "ticketOTMTicket.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "ticketOTMTicket.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "ticketOTMTicket.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "ticketOTMTicket.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "ticketOTMTicket.reuse_tag");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "ticketOTMTicket.tenant_code");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "ticketOTMTicket.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "ticketOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "ticketOTMTicket.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "ticketOTMTicket.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "ticketOTMTicket.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "ticketOTMTicket.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "ticketOTMTicket.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "ticketOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "ticketOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "ticketOTMTicket.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "ticketOTMTicket.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "ticketOTMTicket.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "ticketOTMTicket.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "ticketOTMTicket.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "ticketOTMTicket.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "ticketOTMTicket.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "ticketOTMTicket.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "ticketOTMTicket.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "ticketOTMTicket.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "ticketOTMTicket.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "ticketOTMTicket.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "ticketOTMTicket.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "ticketOTMTicket.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "ticketOTMTicket.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "ticketOTMTicket.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "ticketOTMTicket.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "ticketOTMTicket.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "ticketOTMTicket.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "ticketOTMTicket.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "ticketOTMTicket.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "ticketOTMTicket.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "ticketOTMTicket.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "ticketOTMTicket.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "ticketOTMTicket.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "ticketOTMTicket.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "ticketOTMTicket.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "ticketOTMTicket.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "ticketOTMTicket.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "ticketOTMTicket.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "ticketOTMTicket.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "ticketOTMTicket.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "ticketOTMTicket.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "ticketOTMTicket.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "ticketOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "ticketOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "ticketOTMTicket.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "ticketOTMTicket.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "ticketOTMTicket.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "ticketOTMTicket.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "ticketOTMTicket.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "ticketOTMTicket.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "ticketOTMTicket.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "ticketOTMTicket.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "ticketOTMTicket.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "ticketOTMTicket.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "ticketOTMTicket.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "ticketOTMTicket.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "ticketOTMTicket.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "ticketOTMTicket.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "ticketOTMTicket.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "ticketOTMTicket.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "ticketOTMTicket.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "ticketOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "ticketOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "ticketOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "ticketOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "ticketOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "ticketOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "ticketOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "ticketOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "ticketOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "ticketOTMTicket.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "ticketOTMTicket.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "ticketOTMTicket.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "ticketOTMTicket.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "ticketOTMTicket.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "ticketOTMTicket.is_replace_order");
            }
            interface AREA {
                static String code () {
                    return "area" ;
                }
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "area.orgName");
                TypedField<Long> ID = new TypedField<>(Long.class, "area.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "area.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "area.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "area.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "area.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "area.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "area.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "area.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "area.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "area.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "area.orgId");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "area.orgCode");
            }
        }
    }
    public interface TicketMany {
        static Long id() {
            return 1295238319791259649L;
        }
        static String code() {
            return "ticketMany";
        }
        TypedField<Long> IMAGE_NUM = new TypedField<>(Long.class, "image_num");
        TypedField<Long> EXCEPTION_NUM = new TypedField<>(Long.class, "exception_num");
        TypedField<Long> WARNING_NUM = new TypedField<>(Long.class, "warning_num");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> IS_JOIN = new TypedField<>(String.class, "is_join");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticket_initial_value");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticket_change_value");
        TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "person_remark");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_STAMPER = new TypedField<>(String.class, "is_stamper");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "is_exist_sheet");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "check_sign_status");
        TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "check_sign_remark");
        TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "check_sign_task_id");
        TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_sign_request_time");
        TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "check_sign_user_id");
        TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "check_sign_user_name");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "charge_up_amount");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment_amount");
        TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "used_amount");
        TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "balance_amount");
        TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "charge_up_person");
        TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "payment_user_name");
        TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "is_original_ticket");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "business_key");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "all_system_labels");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "is_collection");
        TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "audit_back_status");
        TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "check_solution");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<String> ROOT_REGION = new TypedField<>(String.class, "root_region");
        TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "custom_region");
        TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "reimbursement_status");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofd_url");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdf_url");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xml_url");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "is_cover_ticket");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "copy_flag");
        TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "main_image_id");
        TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "origin_more_url");
        TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "reimbursement_time");
        TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "bill_system_source");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "is_delete");
        TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "is_replace_order");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_O_T_M_TICKET_ID = new TypedField<>(Long.class, "imageOTMTicket.id");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_TICKET_ID = new TypedField<>(Long.class, "billOTMTicket.id");
        /**
         * 对一关联关系 关联对象 ticket
         */
        TypedField<Long> TICKET_O_T_M_TICKET_ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> AREA_ID = new TypedField<>(Long.class, "area.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_O_T_M_TICKET {
                static String code () {
                    return "imageOTMTicket" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageOTMTicket.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageOTMTicket.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageOTMTicket.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageOTMTicket.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageOTMTicket.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageOTMTicket.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageOTMTicket.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageOTMTicket.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageOTMTicket.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageOTMTicket.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageOTMTicket.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageOTMTicket.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageOTMTicket.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageOTMTicket.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageOTMTicket.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageOTMTicket.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageOTMTicket.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageOTMTicket.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageOTMTicket.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageOTMTicket.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageOTMTicket.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageOTMTicket.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageOTMTicket.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageOTMTicket.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageOTMTicket.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageOTMTicket.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageOTMTicket.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageOTMTicket.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageOTMTicket.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageOTMTicket.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageOTMTicket.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageOTMTicket.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageOTMTicket.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageOTMTicket.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageOTMTicket.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageOTMTicket.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageOTMTicket.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageOTMTicket.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageOTMTicket.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageOTMTicket.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageOTMTicket.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageOTMTicket.file_all_images");
            }
            interface BILL_O_T_M_TICKET {
                static String code () {
                    return "billOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMTicket.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMTicket.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMTicket.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMTicket.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMTicket.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMTicket.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMTicket.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMTicket.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMTicket.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMTicket.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMTicket.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMTicket.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMTicket.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMTicket.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMTicket.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMTicket.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMTicket.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMTicket.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMTicket.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMTicket.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMTicket.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMTicket.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMTicket.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMTicket.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMTicket.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMTicket.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMTicket.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMTicket.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMTicket.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMTicket.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMTicket.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMTicket.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMTicket.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMTicket.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMTicket.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMTicket.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMTicket.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMTicket.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMTicket.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMTicket.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMTicket.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMTicket.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMTicket.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMTicket.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMTicket.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMTicket.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMTicket.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMTicket.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMTicket.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMTicket.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMTicket.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMTicket.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMTicket.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMTicket.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMTicket.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMTicket.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMTicket.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMTicket.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMTicket.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMTicket.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMTicket.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMTicket.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMTicket.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMTicket.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMTicket.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMTicket.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMTicket.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMTicket.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMTicket.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMTicket.back_flag");
            }
            interface TICKET_O_T_M_TICKET {
                static String code () {
                    return "ticketOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "ticketOTMTicket.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "ticketOTMTicket.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "ticketOTMTicket.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "ticketOTMTicket.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "ticketOTMTicket.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "ticketOTMTicket.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "ticketOTMTicket.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "ticketOTMTicket.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "ticketOTMTicket.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "ticketOTMTicket.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "ticketOTMTicket.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticketOTMTicket.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "ticketOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.delete_flag");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "ticketOTMTicket.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ticketOTMTicket.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "ticketOTMTicket.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "ticketOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "ticketOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "ticketOTMTicket.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "ticketOTMTicket.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "ticketOTMTicket.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "ticketOTMTicket.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "ticketOTMTicket.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "ticketOTMTicket.reuse_tag");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "ticketOTMTicket.tenant_code");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "ticketOTMTicket.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "ticketOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "ticketOTMTicket.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "ticketOTMTicket.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "ticketOTMTicket.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "ticketOTMTicket.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "ticketOTMTicket.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "ticketOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "ticketOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "ticketOTMTicket.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "ticketOTMTicket.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "ticketOTMTicket.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "ticketOTMTicket.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "ticketOTMTicket.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "ticketOTMTicket.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "ticketOTMTicket.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "ticketOTMTicket.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "ticketOTMTicket.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "ticketOTMTicket.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "ticketOTMTicket.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "ticketOTMTicket.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "ticketOTMTicket.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "ticketOTMTicket.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "ticketOTMTicket.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "ticketOTMTicket.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "ticketOTMTicket.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "ticketOTMTicket.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "ticketOTMTicket.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "ticketOTMTicket.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "ticketOTMTicket.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "ticketOTMTicket.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "ticketOTMTicket.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "ticketOTMTicket.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "ticketOTMTicket.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "ticketOTMTicket.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "ticketOTMTicket.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "ticketOTMTicket.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "ticketOTMTicket.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "ticketOTMTicket.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "ticketOTMTicket.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "ticketOTMTicket.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "ticketOTMTicket.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "ticketOTMTicket.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "ticketOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "ticketOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "ticketOTMTicket.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "ticketOTMTicket.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "ticketOTMTicket.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "ticketOTMTicket.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "ticketOTMTicket.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "ticketOTMTicket.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "ticketOTMTicket.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "ticketOTMTicket.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "ticketOTMTicket.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "ticketOTMTicket.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "ticketOTMTicket.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "ticketOTMTicket.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "ticketOTMTicket.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "ticketOTMTicket.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "ticketOTMTicket.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "ticketOTMTicket.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "ticketOTMTicket.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "ticketOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "ticketOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "ticketOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "ticketOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "ticketOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "ticketOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "ticketOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "ticketOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "ticketOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "ticketOTMTicket.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "ticketOTMTicket.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "ticketOTMTicket.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "ticketOTMTicket.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "ticketOTMTicket.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "ticketOTMTicket.is_replace_order");
            }
            interface AREA {
                static String code () {
                    return "area" ;
                }
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "area.orgName");
                TypedField<Long> ID = new TypedField<>(Long.class, "area.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "area.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "area.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "area.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "area.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "area.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "area.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "area.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "area.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "area.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "area.orgId");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "area.orgCode");
            }
        }
    }
    public interface TicketAttachment {
        static Long id() {
            return 1295238327391338497L;
        }
        static String code() {
            return "ticketAttachment";
        }
        TypedField<String> ATTACHMENT_NAME = new TypedField<>(String.class, "attachment_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> IS_JOIN = new TypedField<>(String.class, "is_join");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticket_initial_value");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticket_change_value");
        TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "person_remark");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_STAMPER = new TypedField<>(String.class, "is_stamper");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "is_exist_sheet");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "check_sign_status");
        TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "check_sign_remark");
        TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "check_sign_task_id");
        TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_sign_request_time");
        TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "check_sign_user_id");
        TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "check_sign_user_name");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "charge_up_amount");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment_amount");
        TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "used_amount");
        TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "balance_amount");
        TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "charge_up_person");
        TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "payment_user_name");
        TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "is_original_ticket");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "business_key");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "all_system_labels");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "is_collection");
        TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "audit_back_status");
        TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "check_solution");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<String> ROOT_REGION = new TypedField<>(String.class, "root_region");
        TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "custom_region");
        TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "reimbursement_status");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofd_url");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdf_url");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xml_url");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "is_cover_ticket");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "copy_flag");
        TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "main_image_id");
        TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "origin_more_url");
        TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "reimbursement_time");
        TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "bill_system_source");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "is_delete");
        TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "is_replace_order");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_O_T_M_TICKET_ID = new TypedField<>(Long.class, "imageOTMTicket.id");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_TICKET_ID = new TypedField<>(Long.class, "billOTMTicket.id");
        /**
         * 对一关联关系 关联对象 ticket
         */
        TypedField<Long> TICKET_O_T_M_TICKET_ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> AREA_ID = new TypedField<>(Long.class, "area.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_O_T_M_TICKET {
                static String code () {
                    return "imageOTMTicket" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageOTMTicket.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageOTMTicket.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageOTMTicket.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageOTMTicket.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageOTMTicket.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageOTMTicket.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageOTMTicket.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageOTMTicket.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageOTMTicket.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageOTMTicket.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageOTMTicket.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageOTMTicket.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageOTMTicket.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageOTMTicket.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageOTMTicket.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageOTMTicket.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageOTMTicket.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageOTMTicket.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageOTMTicket.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageOTMTicket.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageOTMTicket.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageOTMTicket.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageOTMTicket.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageOTMTicket.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageOTMTicket.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageOTMTicket.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageOTMTicket.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageOTMTicket.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageOTMTicket.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageOTMTicket.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageOTMTicket.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageOTMTicket.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageOTMTicket.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageOTMTicket.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageOTMTicket.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageOTMTicket.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageOTMTicket.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageOTMTicket.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageOTMTicket.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageOTMTicket.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageOTMTicket.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageOTMTicket.file_all_images");
            }
            interface BILL_O_T_M_TICKET {
                static String code () {
                    return "billOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMTicket.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMTicket.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMTicket.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMTicket.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMTicket.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMTicket.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMTicket.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMTicket.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMTicket.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMTicket.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMTicket.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMTicket.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMTicket.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMTicket.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMTicket.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMTicket.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMTicket.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMTicket.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMTicket.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMTicket.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMTicket.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMTicket.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMTicket.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMTicket.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMTicket.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMTicket.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMTicket.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMTicket.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMTicket.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMTicket.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMTicket.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMTicket.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMTicket.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMTicket.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMTicket.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMTicket.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMTicket.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMTicket.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMTicket.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMTicket.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMTicket.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMTicket.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMTicket.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMTicket.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMTicket.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMTicket.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMTicket.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMTicket.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMTicket.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMTicket.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMTicket.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMTicket.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMTicket.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMTicket.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMTicket.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMTicket.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMTicket.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMTicket.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMTicket.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMTicket.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMTicket.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMTicket.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMTicket.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMTicket.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMTicket.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMTicket.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMTicket.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMTicket.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMTicket.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMTicket.back_flag");
            }
            interface TICKET_O_T_M_TICKET {
                static String code () {
                    return "ticketOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "ticketOTMTicket.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "ticketOTMTicket.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "ticketOTMTicket.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "ticketOTMTicket.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "ticketOTMTicket.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "ticketOTMTicket.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "ticketOTMTicket.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "ticketOTMTicket.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "ticketOTMTicket.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "ticketOTMTicket.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "ticketOTMTicket.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticketOTMTicket.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "ticketOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.delete_flag");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "ticketOTMTicket.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ticketOTMTicket.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "ticketOTMTicket.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "ticketOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "ticketOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "ticketOTMTicket.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "ticketOTMTicket.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "ticketOTMTicket.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "ticketOTMTicket.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "ticketOTMTicket.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "ticketOTMTicket.reuse_tag");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "ticketOTMTicket.tenant_code");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "ticketOTMTicket.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "ticketOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "ticketOTMTicket.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "ticketOTMTicket.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "ticketOTMTicket.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "ticketOTMTicket.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "ticketOTMTicket.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "ticketOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "ticketOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "ticketOTMTicket.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "ticketOTMTicket.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "ticketOTMTicket.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "ticketOTMTicket.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "ticketOTMTicket.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "ticketOTMTicket.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "ticketOTMTicket.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "ticketOTMTicket.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "ticketOTMTicket.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "ticketOTMTicket.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "ticketOTMTicket.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "ticketOTMTicket.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "ticketOTMTicket.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "ticketOTMTicket.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "ticketOTMTicket.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "ticketOTMTicket.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "ticketOTMTicket.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "ticketOTMTicket.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "ticketOTMTicket.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "ticketOTMTicket.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "ticketOTMTicket.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "ticketOTMTicket.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "ticketOTMTicket.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "ticketOTMTicket.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "ticketOTMTicket.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "ticketOTMTicket.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "ticketOTMTicket.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "ticketOTMTicket.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "ticketOTMTicket.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "ticketOTMTicket.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "ticketOTMTicket.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "ticketOTMTicket.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "ticketOTMTicket.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "ticketOTMTicket.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "ticketOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "ticketOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "ticketOTMTicket.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "ticketOTMTicket.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "ticketOTMTicket.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "ticketOTMTicket.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "ticketOTMTicket.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "ticketOTMTicket.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "ticketOTMTicket.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "ticketOTMTicket.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "ticketOTMTicket.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "ticketOTMTicket.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "ticketOTMTicket.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "ticketOTMTicket.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "ticketOTMTicket.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "ticketOTMTicket.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "ticketOTMTicket.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "ticketOTMTicket.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "ticketOTMTicket.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "ticketOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "ticketOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "ticketOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "ticketOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "ticketOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "ticketOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "ticketOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "ticketOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "ticketOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "ticketOTMTicket.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "ticketOTMTicket.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "ticketOTMTicket.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "ticketOTMTicket.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "ticketOTMTicket.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "ticketOTMTicket.is_replace_order");
            }
            interface AREA {
                static String code () {
                    return "area" ;
                }
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "area.orgName");
                TypedField<Long> ID = new TypedField<>(Long.class, "area.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "area.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "area.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "area.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "area.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "area.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "area.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "area.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "area.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "area.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "area.orgId");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "area.orgCode");
            }
        }
    }
    public interface TicketTaxi {
        static Long id() {
            return 1295238331791163393L;
        }
        static String code() {
            return "ticketTaxi";
        }
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "start_date");
        TypedField<String> GET_ON_TIME = new TypedField<>(String.class, "get_on_time");
        TypedField<String> MILEAGE = new TypedField<>(String.class, "mileage");
        TypedField<String> GET_OFF_TIME = new TypedField<>(String.class, "get_off_time");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> PLACE = new TypedField<>(String.class, "place");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> IS_JOIN = new TypedField<>(String.class, "is_join");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticket_initial_value");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticket_change_value");
        TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "person_remark");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_STAMPER = new TypedField<>(String.class, "is_stamper");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "is_exist_sheet");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "check_sign_status");
        TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "check_sign_remark");
        TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "check_sign_task_id");
        TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_sign_request_time");
        TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "check_sign_user_id");
        TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "check_sign_user_name");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "charge_up_amount");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment_amount");
        TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "used_amount");
        TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "balance_amount");
        TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "charge_up_person");
        TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "payment_user_name");
        TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "is_original_ticket");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "business_key");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "all_system_labels");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "is_collection");
        TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "audit_back_status");
        TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "check_solution");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<String> ROOT_REGION = new TypedField<>(String.class, "root_region");
        TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "custom_region");
        TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "reimbursement_status");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofd_url");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdf_url");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xml_url");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "is_cover_ticket");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "copy_flag");
        TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "main_image_id");
        TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "origin_more_url");
        TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "reimbursement_time");
        TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "bill_system_source");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "is_delete");
        TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "is_replace_order");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_O_T_M_TICKET_ID = new TypedField<>(Long.class, "imageOTMTicket.id");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_TICKET_ID = new TypedField<>(Long.class, "billOTMTicket.id");
        /**
         * 对一关联关系 关联对象 ticket
         */
        TypedField<Long> TICKET_O_T_M_TICKET_ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> AREA_ID = new TypedField<>(Long.class, "area.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_O_T_M_TICKET {
                static String code () {
                    return "imageOTMTicket" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageOTMTicket.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageOTMTicket.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageOTMTicket.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageOTMTicket.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageOTMTicket.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageOTMTicket.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageOTMTicket.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageOTMTicket.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageOTMTicket.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageOTMTicket.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageOTMTicket.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageOTMTicket.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageOTMTicket.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageOTMTicket.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageOTMTicket.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageOTMTicket.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageOTMTicket.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageOTMTicket.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageOTMTicket.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageOTMTicket.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageOTMTicket.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageOTMTicket.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageOTMTicket.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageOTMTicket.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageOTMTicket.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageOTMTicket.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageOTMTicket.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageOTMTicket.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageOTMTicket.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageOTMTicket.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageOTMTicket.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageOTMTicket.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageOTMTicket.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageOTMTicket.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageOTMTicket.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageOTMTicket.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageOTMTicket.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageOTMTicket.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageOTMTicket.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageOTMTicket.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageOTMTicket.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageOTMTicket.file_all_images");
            }
            interface BILL_O_T_M_TICKET {
                static String code () {
                    return "billOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMTicket.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMTicket.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMTicket.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMTicket.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMTicket.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMTicket.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMTicket.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMTicket.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMTicket.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMTicket.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMTicket.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMTicket.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMTicket.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMTicket.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMTicket.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMTicket.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMTicket.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMTicket.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMTicket.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMTicket.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMTicket.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMTicket.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMTicket.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMTicket.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMTicket.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMTicket.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMTicket.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMTicket.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMTicket.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMTicket.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMTicket.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMTicket.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMTicket.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMTicket.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMTicket.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMTicket.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMTicket.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMTicket.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMTicket.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMTicket.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMTicket.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMTicket.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMTicket.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMTicket.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMTicket.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMTicket.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMTicket.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMTicket.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMTicket.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMTicket.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMTicket.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMTicket.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMTicket.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMTicket.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMTicket.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMTicket.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMTicket.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMTicket.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMTicket.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMTicket.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMTicket.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMTicket.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMTicket.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMTicket.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMTicket.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMTicket.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMTicket.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMTicket.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMTicket.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMTicket.back_flag");
            }
            interface TICKET_O_T_M_TICKET {
                static String code () {
                    return "ticketOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "ticketOTMTicket.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "ticketOTMTicket.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "ticketOTMTicket.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "ticketOTMTicket.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "ticketOTMTicket.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "ticketOTMTicket.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "ticketOTMTicket.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "ticketOTMTicket.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "ticketOTMTicket.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "ticketOTMTicket.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "ticketOTMTicket.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticketOTMTicket.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "ticketOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.delete_flag");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "ticketOTMTicket.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ticketOTMTicket.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "ticketOTMTicket.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "ticketOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "ticketOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "ticketOTMTicket.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "ticketOTMTicket.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "ticketOTMTicket.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "ticketOTMTicket.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "ticketOTMTicket.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "ticketOTMTicket.reuse_tag");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "ticketOTMTicket.tenant_code");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "ticketOTMTicket.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "ticketOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "ticketOTMTicket.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "ticketOTMTicket.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "ticketOTMTicket.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "ticketOTMTicket.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "ticketOTMTicket.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "ticketOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "ticketOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "ticketOTMTicket.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "ticketOTMTicket.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "ticketOTMTicket.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "ticketOTMTicket.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "ticketOTMTicket.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "ticketOTMTicket.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "ticketOTMTicket.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "ticketOTMTicket.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "ticketOTMTicket.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "ticketOTMTicket.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "ticketOTMTicket.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "ticketOTMTicket.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "ticketOTMTicket.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "ticketOTMTicket.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "ticketOTMTicket.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "ticketOTMTicket.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "ticketOTMTicket.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "ticketOTMTicket.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "ticketOTMTicket.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "ticketOTMTicket.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "ticketOTMTicket.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "ticketOTMTicket.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "ticketOTMTicket.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "ticketOTMTicket.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "ticketOTMTicket.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "ticketOTMTicket.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "ticketOTMTicket.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "ticketOTMTicket.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "ticketOTMTicket.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "ticketOTMTicket.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "ticketOTMTicket.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "ticketOTMTicket.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "ticketOTMTicket.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "ticketOTMTicket.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "ticketOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "ticketOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "ticketOTMTicket.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "ticketOTMTicket.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "ticketOTMTicket.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "ticketOTMTicket.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "ticketOTMTicket.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "ticketOTMTicket.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "ticketOTMTicket.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "ticketOTMTicket.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "ticketOTMTicket.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "ticketOTMTicket.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "ticketOTMTicket.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "ticketOTMTicket.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "ticketOTMTicket.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "ticketOTMTicket.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "ticketOTMTicket.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "ticketOTMTicket.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "ticketOTMTicket.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "ticketOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "ticketOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "ticketOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "ticketOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "ticketOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "ticketOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "ticketOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "ticketOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "ticketOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "ticketOTMTicket.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "ticketOTMTicket.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "ticketOTMTicket.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "ticketOTMTicket.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "ticketOTMTicket.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "ticketOTMTicket.is_replace_order");
            }
            interface AREA {
                static String code () {
                    return "area" ;
                }
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "area.orgName");
                TypedField<Long> ID = new TypedField<>(Long.class, "area.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "area.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "area.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "area.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "area.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "area.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "area.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "area.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "area.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "area.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "area.orgId");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "area.orgCode");
            }
        }
    }
    public interface ConfigBillTicketRel {
        static Long id() {
            return 1295238340750196738L;
        }
        static String code() {
            return "configBillTicketRel";
        }
        TypedField<Long> CONFIG_BILL_TYPE_ID = new TypedField<>(Long.class, "config_bill_type_id");
        TypedField<Long> CONFIG_TICKET_TYPE_ID = new TypedField<>(Long.class, "config_ticket_type_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }
    public interface BaseBill {
        static Long id() {
            return 1295238353597349889L;
        }
        static String code() {
            return "baseBill";
        }
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "bill_amount_with_tax");
        TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "bill_tax_amount");
        TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "bill_amount_without_tax");
        TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "bill_create_user");
        TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "bill_create_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "scan_create_time");
        TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "package_code");
        TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "logistics_status");
        TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "logistics_time");
        TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "sign_status");
        TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "sign_time");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logistic_remark");
        TypedField<String> HANG_TYPE = new TypedField<>(String.class, "hang_type");
        TypedField<String> HANG_REASON = new TypedField<>(String.class, "hang_reason");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "bill_data_status");
        TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "bill_data_time");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "verify_time");
        TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "ticket_count");
        TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "image_count");
        TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "exception_count");
        TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "warning_count");
        TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "is_exception");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> IS_SECRET = new TypedField<>(String.class, "is_secret");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "unquality_type");
        TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "unquality_reason");
        TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "verify_hang_type");
        TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "verify_hang_reason");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "is_prepayment");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> EXT_STATUS = new TypedField<>(String.class, "ext_status");
        TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "prepayment_status");
        TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "prepayment_time");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "bill_check_status");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "bill_check_time");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> BACK_ORIG = new TypedField<>(String.class, "back_orig");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> IS_WARNING = new TypedField<>(String.class, "is_warning");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "is_push_bill");
        TypedField<String> IS_COVER = new TypedField<>(String.class, "is_cover");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "business_type");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> BILL_USE = new TypedField<>(String.class, "bill_use");
        TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "system_orig_external");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "audit_remark");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "pay_status");
        TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "complete_time");
        TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "settlement_type");
        TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "ticket_exception");
        TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "ticket_warning");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "main_bill_data_status");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "receive_status");
        TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "compare_triggered");
        TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "electric_count");
        TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "paper_count");
        TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "commit_remark");
        TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "audit_user_id");
        TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "audit_user_name");
        TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "bill_create_email");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "normal_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "special_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "special_tax_amount");
        TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_normal_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_special_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "coop_special_tax_amount");
        TypedField<String> BACK_FLAG = new TypedField<>(String.class, "back_flag");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> BILL_O_T_O_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_O_T_O_IMAGE {
                static String code () {
                    return "billOTOImage" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "billOTOImage.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "billOTOImage.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "billOTOImage.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "billOTOImage.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "billOTOImage.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "billOTOImage.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "billOTOImage.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "billOTOImage.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "billOTOImage.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "billOTOImage.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "billOTOImage.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "billOTOImage.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "billOTOImage.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "billOTOImage.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "billOTOImage.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTOImage.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "billOTOImage.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "billOTOImage.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTOImage.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "billOTOImage.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "billOTOImage.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "billOTOImage.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTOImage.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTOImage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTOImage.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTOImage.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTOImage.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTOImage.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTOImage.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "billOTOImage.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "billOTOImage.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "billOTOImage.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "billOTOImage.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTOImage.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "billOTOImage.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTOImage.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTOImage.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTOImage.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTOImage.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTOImage.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTOImage.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "billOTOImage.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTOImage.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTOImage.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTOImage.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTOImage.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "billOTOImage.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "billOTOImage.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "billOTOImage.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTOImage.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTOImage.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTOImage.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTOImage.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTOImage.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTOImage.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTOImage.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTOImage.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTOImage.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTOImage.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTOImage.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTOImage.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "billOTOImage.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "billOTOImage.file_all_images");
            }
        }
    }
    public interface SalesBill {
        static Long id() {
            return 1295238424023908353L;
        }
        static String code() {
            return "salesBill";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "bill_amount_with_tax");
        TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "bill_tax_amount");
        TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "bill_amount_without_tax");
        TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "bill_create_user");
        TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "bill_create_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "scan_create_time");
        TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "package_code");
        TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "logistics_status");
        TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "logistics_time");
        TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "sign_status");
        TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "sign_time");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logistic_remark");
        TypedField<String> HANG_TYPE = new TypedField<>(String.class, "hang_type");
        TypedField<String> HANG_REASON = new TypedField<>(String.class, "hang_reason");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "bill_data_status");
        TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "bill_data_time");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "verify_time");
        TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "ticket_count");
        TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "image_count");
        TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "exception_count");
        TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "warning_count");
        TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "is_exception");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> IS_SECRET = new TypedField<>(String.class, "is_secret");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "unquality_type");
        TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "unquality_reason");
        TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "verify_hang_type");
        TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "verify_hang_reason");
        TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "is_prepayment");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> EXT_STATUS = new TypedField<>(String.class, "ext_status");
        TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "prepayment_status");
        TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "prepayment_time");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "bill_check_status");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "bill_check_time");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> BACK_ORIG = new TypedField<>(String.class, "back_orig");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> IS_WARNING = new TypedField<>(String.class, "is_warning");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "is_push_bill");
        TypedField<String> IS_COVER = new TypedField<>(String.class, "is_cover");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "business_type");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> BILL_USE = new TypedField<>(String.class, "bill_use");
        TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "system_orig_external");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "audit_remark");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "pay_status");
        TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "complete_time");
        TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "settlement_type");
        TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "ticket_exception");
        TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "ticket_warning");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "main_bill_data_status");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "receive_status");
        TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "compare_triggered");
        TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "electric_count");
        TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "paper_count");
        TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "commit_remark");
        TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "audit_user_id");
        TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "audit_user_name");
        TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "bill_create_email");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "normal_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "special_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "special_tax_amount");
        TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_normal_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_special_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "coop_special_tax_amount");
        TypedField<String> BACK_FLAG = new TypedField<>(String.class, "back_flag");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> BILL_O_T_O_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_O_T_O_IMAGE {
                static String code () {
                    return "billOTOImage" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "billOTOImage.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "billOTOImage.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "billOTOImage.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "billOTOImage.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "billOTOImage.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "billOTOImage.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "billOTOImage.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "billOTOImage.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "billOTOImage.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "billOTOImage.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "billOTOImage.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "billOTOImage.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "billOTOImage.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "billOTOImage.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "billOTOImage.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTOImage.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "billOTOImage.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "billOTOImage.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTOImage.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "billOTOImage.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "billOTOImage.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "billOTOImage.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTOImage.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTOImage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTOImage.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTOImage.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTOImage.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTOImage.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTOImage.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "billOTOImage.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "billOTOImage.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "billOTOImage.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "billOTOImage.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTOImage.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "billOTOImage.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTOImage.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTOImage.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTOImage.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTOImage.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTOImage.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTOImage.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "billOTOImage.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTOImage.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTOImage.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTOImage.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTOImage.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "billOTOImage.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "billOTOImage.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "billOTOImage.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTOImage.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTOImage.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTOImage.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTOImage.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTOImage.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTOImage.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTOImage.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTOImage.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTOImage.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTOImage.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTOImage.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTOImage.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "billOTOImage.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "billOTOImage.file_all_images");
            }
        }
    }
    public interface TicketForm {
        static Long id() {
            return 1295238426414661634L;
        }
        static String code() {
            return "ticketForm";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customer_no");
        TypedField<String> ADDRESS = new TypedField<>(String.class, "address");
        TypedField<String> CONTRACTNO = new TypedField<>(String.class, "contractno");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> IS_JOIN = new TypedField<>(String.class, "is_join");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticket_initial_value");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticket_change_value");
        TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "person_remark");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_STAMPER = new TypedField<>(String.class, "is_stamper");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "is_exist_sheet");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "check_sign_status");
        TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "check_sign_remark");
        TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "check_sign_task_id");
        TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_sign_request_time");
        TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "check_sign_user_id");
        TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "check_sign_user_name");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "charge_up_amount");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment_amount");
        TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "used_amount");
        TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "balance_amount");
        TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "charge_up_person");
        TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "payment_user_name");
        TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "is_original_ticket");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "business_key");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "all_system_labels");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "is_collection");
        TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "audit_back_status");
        TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "check_solution");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<String> ROOT_REGION = new TypedField<>(String.class, "root_region");
        TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "custom_region");
        TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "reimbursement_status");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofd_url");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdf_url");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xml_url");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "is_cover_ticket");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "copy_flag");
        TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "main_image_id");
        TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "origin_more_url");
        TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "reimbursement_time");
        TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "bill_system_source");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "is_delete");
        TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "is_replace_order");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_O_T_M_TICKET_ID = new TypedField<>(Long.class, "imageOTMTicket.id");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_TICKET_ID = new TypedField<>(Long.class, "billOTMTicket.id");
        /**
         * 对一关联关系 关联对象 ticket
         */
        TypedField<Long> TICKET_O_T_M_TICKET_ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> AREA_ID = new TypedField<>(Long.class, "area.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_O_T_M_TICKET {
                static String code () {
                    return "imageOTMTicket" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageOTMTicket.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageOTMTicket.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageOTMTicket.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageOTMTicket.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageOTMTicket.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageOTMTicket.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageOTMTicket.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageOTMTicket.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageOTMTicket.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageOTMTicket.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageOTMTicket.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageOTMTicket.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageOTMTicket.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageOTMTicket.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageOTMTicket.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageOTMTicket.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageOTMTicket.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageOTMTicket.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageOTMTicket.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageOTMTicket.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageOTMTicket.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageOTMTicket.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageOTMTicket.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageOTMTicket.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageOTMTicket.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageOTMTicket.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageOTMTicket.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageOTMTicket.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageOTMTicket.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageOTMTicket.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageOTMTicket.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageOTMTicket.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageOTMTicket.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageOTMTicket.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageOTMTicket.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageOTMTicket.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageOTMTicket.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageOTMTicket.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageOTMTicket.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageOTMTicket.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageOTMTicket.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageOTMTicket.file_all_images");
            }
            interface BILL_O_T_M_TICKET {
                static String code () {
                    return "billOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMTicket.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMTicket.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMTicket.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMTicket.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMTicket.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMTicket.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMTicket.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMTicket.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMTicket.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMTicket.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMTicket.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMTicket.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMTicket.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMTicket.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMTicket.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMTicket.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMTicket.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMTicket.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMTicket.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMTicket.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMTicket.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMTicket.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMTicket.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMTicket.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMTicket.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMTicket.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMTicket.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMTicket.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMTicket.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMTicket.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMTicket.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMTicket.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMTicket.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMTicket.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMTicket.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMTicket.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMTicket.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMTicket.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMTicket.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMTicket.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMTicket.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMTicket.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMTicket.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMTicket.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMTicket.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMTicket.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMTicket.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMTicket.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMTicket.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMTicket.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMTicket.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMTicket.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMTicket.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMTicket.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMTicket.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMTicket.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMTicket.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMTicket.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMTicket.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMTicket.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMTicket.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMTicket.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMTicket.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMTicket.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMTicket.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMTicket.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMTicket.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMTicket.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMTicket.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMTicket.back_flag");
            }
            interface TICKET_O_T_M_TICKET {
                static String code () {
                    return "ticketOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "ticketOTMTicket.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "ticketOTMTicket.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "ticketOTMTicket.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "ticketOTMTicket.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "ticketOTMTicket.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "ticketOTMTicket.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "ticketOTMTicket.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "ticketOTMTicket.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "ticketOTMTicket.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "ticketOTMTicket.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "ticketOTMTicket.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticketOTMTicket.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "ticketOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.delete_flag");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "ticketOTMTicket.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ticketOTMTicket.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "ticketOTMTicket.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "ticketOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "ticketOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "ticketOTMTicket.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "ticketOTMTicket.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "ticketOTMTicket.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "ticketOTMTicket.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "ticketOTMTicket.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "ticketOTMTicket.reuse_tag");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "ticketOTMTicket.tenant_code");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "ticketOTMTicket.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "ticketOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "ticketOTMTicket.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "ticketOTMTicket.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "ticketOTMTicket.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "ticketOTMTicket.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "ticketOTMTicket.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "ticketOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "ticketOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "ticketOTMTicket.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "ticketOTMTicket.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "ticketOTMTicket.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "ticketOTMTicket.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "ticketOTMTicket.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "ticketOTMTicket.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "ticketOTMTicket.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "ticketOTMTicket.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "ticketOTMTicket.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "ticketOTMTicket.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "ticketOTMTicket.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "ticketOTMTicket.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "ticketOTMTicket.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "ticketOTMTicket.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "ticketOTMTicket.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "ticketOTMTicket.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "ticketOTMTicket.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "ticketOTMTicket.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "ticketOTMTicket.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "ticketOTMTicket.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "ticketOTMTicket.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "ticketOTMTicket.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "ticketOTMTicket.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "ticketOTMTicket.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "ticketOTMTicket.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "ticketOTMTicket.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "ticketOTMTicket.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "ticketOTMTicket.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "ticketOTMTicket.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "ticketOTMTicket.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "ticketOTMTicket.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "ticketOTMTicket.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "ticketOTMTicket.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "ticketOTMTicket.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "ticketOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "ticketOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "ticketOTMTicket.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "ticketOTMTicket.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "ticketOTMTicket.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "ticketOTMTicket.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "ticketOTMTicket.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "ticketOTMTicket.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "ticketOTMTicket.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "ticketOTMTicket.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "ticketOTMTicket.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "ticketOTMTicket.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "ticketOTMTicket.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "ticketOTMTicket.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "ticketOTMTicket.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "ticketOTMTicket.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "ticketOTMTicket.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "ticketOTMTicket.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "ticketOTMTicket.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "ticketOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "ticketOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "ticketOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "ticketOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "ticketOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "ticketOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "ticketOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "ticketOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "ticketOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "ticketOTMTicket.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "ticketOTMTicket.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "ticketOTMTicket.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "ticketOTMTicket.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "ticketOTMTicket.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "ticketOTMTicket.is_replace_order");
            }
            interface AREA {
                static String code () {
                    return "area" ;
                }
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "area.orgName");
                TypedField<Long> ID = new TypedField<>(Long.class, "area.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "area.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "area.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "area.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "area.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "area.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "area.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "area.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "area.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "area.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "area.orgId");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "area.orgCode");
            }
        }
    }
    public interface ConfigSettings {
        static Long id() {
            return 1295238442260742145L;
        }
        static String code() {
            return "configSettings";
        }
        TypedField<String> IS_DEFAULT = new TypedField<>(String.class, "is_default");
        TypedField<String> ENABLE = new TypedField<>(String.class, "enable");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> TENANT = new TypedField<>(Long.class, "tenant");
        TypedField<Long> IMAGE_TO_ANNEX_SECONDS = new TypedField<>(Long.class, "image_to_annex_seconds");
        TypedField<String> SCAN_IS_SUPPORT_ALL_TENANT = new TypedField<>(String.class, "scan_is_support_all_tenant");
        TypedField<Long> SEARCH_NO_REAL_DAY = new TypedField<>(Long.class, "search_no_real_day");
        TypedField<String> TICKET_AUTO_SEND_VERIFY = new TypedField<>(String.class, "ticket_auto_send_verify");
        TypedField<String> IS_ALL_PUSH_DATA = new TypedField<>(String.class, "is_all_push_data");
        TypedField<String> TICKET_IS_SUPPORT_REUSE = new TypedField<>(String.class, "ticket_is_support_reuse");
        TypedField<String> TICKET_IS_CHECK_BLACK = new TypedField<>(String.class, "ticket_is_check_black");
        TypedField<String> TICKET_IS_CHECK_SENSITIVE = new TypedField<>(String.class, "ticket_is_check_sensitive");
        TypedField<String> TICKET_IS_CHECK_LEGALPERSON = new TypedField<>(String.class, "ticket_is_check_legalperson");
        TypedField<String> BILL_CODE_IS_NEED_TRANS = new TypedField<>(String.class, "bill_code_is_need_trans");
        TypedField<String> EMPTY_URL = new TypedField<>(String.class, "empty_url");
        TypedField<String> IS_SUPPORT_PSZS = new TypedField<>(String.class, "is_support_pszs");
        TypedField<String> DEBUG_MODEL = new TypedField<>(String.class, "debug_model");
        TypedField<String> SPLIT_MORE_IMAGE = new TypedField<>(String.class, "split_more_image");
        TypedField<String> BILL_TYPE_CODE_NEED_LIST = new TypedField<>(String.class, "bill_type_code_need_list");
        TypedField<String> BILL_CODE_REGEX_SPLIT = new TypedField<>(String.class, "bill_code_regex_split");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> EXTENSION1 = new TypedField<>(String.class, "extension1");
        TypedField<String> EXTENSION2 = new TypedField<>(String.class, "extension2");
        TypedField<String> EXTENSION3 = new TypedField<>(String.class, "extension3");
        TypedField<String> SALES_LIST_CONFIG = new TypedField<>(String.class, "sales_list_config");
        TypedField<String> SCAN_CLIENT_SCAN_MODEL = new TypedField<>(String.class, "scan_client_scan_model");
        TypedField<Long> SHAREPOINT_SEND_IMAGE_NUM = new TypedField<>(Long.class, "sharepoint_send_image_num");
        TypedField<String> WEBSOCKET_URL = new TypedField<>(String.class, "websocket_url");
        TypedField<String> DISCERN_ENTITY_CODES = new TypedField<>(String.class, "discern_entity_codes");
        TypedField<Long> FILE_TO_ANNEX_SECONDS = new TypedField<>(Long.class, "file_to_annex_seconds");
        TypedField<Long> VERIFY_TO_ANNEX_SECONDS = new TypedField<>(Long.class, "verify_to_annex_seconds");
        TypedField<String> IS_MULTIPURPOSE_TICKET = new TypedField<>(String.class, "is_multipurpose_ticket");
        TypedField<String> IS_CHECK_N_VAT_PERMISSION = new TypedField<>(String.class, "is_check_n_vat_permission");
        TypedField<String> IS_AUTO_COMPARE = new TypedField<>(String.class, "is_auto_compare");
        TypedField<String> BILL_CANNOT_DELETE_CONTENT = new TypedField<>(String.class, "bill_cannot_delete_content");
        TypedField<String> OPEN_RESET_LEVEL = new TypedField<>(String.class, "open_reset_level");
        TypedField<String> MULTIPURPOSE_TICKET_MODEL = new TypedField<>(String.class, "multipurpose_ticket_model");
        TypedField<String> MANY_SPLIT_URL_MODEL = new TypedField<>(String.class, "many_split_url_model");
        TypedField<String> IS_CHECK_BILL_ORG = new TypedField<>(String.class, "is_check_bill_org");
        TypedField<Boolean> ENABLE_FLOW = new TypedField<>(Boolean.class, "enable_flow");
    }
    public interface TravelExpenseBill {
        static Long id() {
            return 1295238469200756737L;
        }
        static String code() {
            return "travelExpenseBill";
        }
        TypedField<String> BUSINESS_USER = new TypedField<>(String.class, "business_user");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "bill_amount_with_tax");
        TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "bill_tax_amount");
        TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "bill_amount_without_tax");
        TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "bill_create_user");
        TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "bill_create_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "scan_create_time");
        TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "package_code");
        TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "logistics_status");
        TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "logistics_time");
        TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "sign_status");
        TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "sign_time");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logistic_remark");
        TypedField<String> HANG_TYPE = new TypedField<>(String.class, "hang_type");
        TypedField<String> HANG_REASON = new TypedField<>(String.class, "hang_reason");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "bill_data_status");
        TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "bill_data_time");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "verify_time");
        TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "ticket_count");
        TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "image_count");
        TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "exception_count");
        TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "warning_count");
        TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "is_exception");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> IS_SECRET = new TypedField<>(String.class, "is_secret");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "unquality_type");
        TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "unquality_reason");
        TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "verify_hang_type");
        TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "verify_hang_reason");
        TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "is_prepayment");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> EXT_STATUS = new TypedField<>(String.class, "ext_status");
        TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "prepayment_status");
        TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "prepayment_time");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "bill_check_status");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "bill_check_time");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> BACK_ORIG = new TypedField<>(String.class, "back_orig");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> IS_WARNING = new TypedField<>(String.class, "is_warning");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "is_push_bill");
        TypedField<String> IS_COVER = new TypedField<>(String.class, "is_cover");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "business_type");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> BILL_USE = new TypedField<>(String.class, "bill_use");
        TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "system_orig_external");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "audit_remark");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "pay_status");
        TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "complete_time");
        TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "settlement_type");
        TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "ticket_exception");
        TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "ticket_warning");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "main_bill_data_status");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "receive_status");
        TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "compare_triggered");
        TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "electric_count");
        TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "paper_count");
        TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "commit_remark");
        TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "audit_user_id");
        TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "audit_user_name");
        TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "bill_create_email");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "normal_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "special_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "special_tax_amount");
        TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_normal_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_special_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "coop_special_tax_amount");
        TypedField<String> BACK_FLAG = new TypedField<>(String.class, "back_flag");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> BILL_O_T_O_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_O_T_O_IMAGE {
                static String code () {
                    return "billOTOImage" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "billOTOImage.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "billOTOImage.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "billOTOImage.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "billOTOImage.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "billOTOImage.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "billOTOImage.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "billOTOImage.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "billOTOImage.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "billOTOImage.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "billOTOImage.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "billOTOImage.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "billOTOImage.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "billOTOImage.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "billOTOImage.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "billOTOImage.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTOImage.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "billOTOImage.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "billOTOImage.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTOImage.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "billOTOImage.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "billOTOImage.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "billOTOImage.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTOImage.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTOImage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTOImage.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTOImage.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTOImage.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTOImage.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTOImage.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "billOTOImage.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "billOTOImage.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "billOTOImage.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "billOTOImage.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTOImage.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "billOTOImage.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTOImage.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTOImage.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTOImage.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTOImage.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTOImage.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTOImage.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "billOTOImage.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTOImage.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTOImage.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTOImage.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTOImage.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "billOTOImage.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "billOTOImage.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "billOTOImage.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTOImage.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTOImage.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTOImage.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTOImage.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTOImage.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTOImage.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTOImage.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTOImage.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTOImage.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTOImage.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTOImage.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTOImage.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "billOTOImage.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "billOTOImage.file_all_images");
            }
        }
    }
    public interface TicketInvoiceDetail {
        static Long id() {
            return 1295238471784448002L;
        }
        static String code() {
            return "ticketInvoiceDetail";
        }
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargo_name");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "item_spec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> TICKET_ID = new TypedField<>(Long.class, "ticket_id");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<String> CURRENT_DATE_START = new TypedField<>(String.class, "current_date_start");
        TypedField<String> CURRENT_DATE_END = new TypedField<>(String.class, "current_date_end");
        TypedField<String> LICENSE_PLATE_NUM = new TypedField<>(String.class, "license_plate_num");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> ROW_NUM = new TypedField<>(String.class, "row_num");
    }
    public interface ConfigDictionary {
        static Long id() {
            return 1295238499873701890L;
        }
        static String code() {
            return "configDictionary";
        }
        TypedField<String> DICT_CODE = new TypedField<>(String.class, "dict_code");
        TypedField<String> DICT_DESC = new TypedField<>(String.class, "dict_desc");
        TypedField<String> DICT_VALUE = new TypedField<>(String.class, "dict_value");
        TypedField<Long> TENANT = new TypedField<>(Long.class, "tenant");
        TypedField<String> IS_DEFAULT = new TypedField<>(String.class, "is_default");
        TypedField<String> ENABLE = new TypedField<>(String.class, "enable");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }
    public interface TicketQuota {
        static Long id() {
            return 1295238514205638658L;
        }
        static String code() {
            return "ticketQuota";
        }
        TypedField<String> FILE_NAME = new TypedField<>(String.class, "file_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> IS_JOIN = new TypedField<>(String.class, "is_join");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticket_initial_value");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticket_change_value");
        TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "person_remark");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_STAMPER = new TypedField<>(String.class, "is_stamper");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "is_exist_sheet");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "check_sign_status");
        TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "check_sign_remark");
        TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "check_sign_task_id");
        TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_sign_request_time");
        TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "check_sign_user_id");
        TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "check_sign_user_name");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "charge_up_amount");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment_amount");
        TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "used_amount");
        TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "balance_amount");
        TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "charge_up_person");
        TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "payment_user_name");
        TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "is_original_ticket");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "business_key");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "all_system_labels");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "is_collection");
        TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "audit_back_status");
        TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "check_solution");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<String> ROOT_REGION = new TypedField<>(String.class, "root_region");
        TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "custom_region");
        TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "reimbursement_status");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofd_url");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdf_url");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xml_url");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "is_cover_ticket");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "copy_flag");
        TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "main_image_id");
        TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "origin_more_url");
        TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "reimbursement_time");
        TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "bill_system_source");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "is_delete");
        TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "is_replace_order");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_O_T_M_TICKET_ID = new TypedField<>(Long.class, "imageOTMTicket.id");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_TICKET_ID = new TypedField<>(Long.class, "billOTMTicket.id");
        /**
         * 对一关联关系 关联对象 ticket
         */
        TypedField<Long> TICKET_O_T_M_TICKET_ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> AREA_ID = new TypedField<>(Long.class, "area.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_O_T_M_TICKET {
                static String code () {
                    return "imageOTMTicket" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageOTMTicket.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageOTMTicket.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageOTMTicket.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageOTMTicket.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageOTMTicket.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageOTMTicket.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageOTMTicket.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageOTMTicket.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageOTMTicket.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageOTMTicket.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageOTMTicket.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageOTMTicket.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageOTMTicket.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageOTMTicket.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageOTMTicket.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageOTMTicket.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageOTMTicket.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageOTMTicket.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageOTMTicket.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageOTMTicket.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageOTMTicket.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageOTMTicket.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageOTMTicket.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageOTMTicket.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageOTMTicket.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageOTMTicket.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageOTMTicket.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageOTMTicket.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageOTMTicket.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageOTMTicket.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageOTMTicket.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageOTMTicket.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageOTMTicket.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageOTMTicket.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageOTMTicket.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageOTMTicket.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageOTMTicket.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageOTMTicket.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageOTMTicket.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageOTMTicket.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageOTMTicket.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageOTMTicket.file_all_images");
            }
            interface BILL_O_T_M_TICKET {
                static String code () {
                    return "billOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMTicket.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMTicket.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMTicket.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMTicket.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMTicket.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMTicket.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMTicket.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMTicket.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMTicket.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMTicket.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMTicket.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMTicket.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMTicket.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMTicket.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMTicket.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMTicket.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMTicket.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMTicket.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMTicket.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMTicket.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMTicket.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMTicket.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMTicket.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMTicket.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMTicket.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMTicket.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMTicket.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMTicket.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMTicket.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMTicket.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMTicket.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMTicket.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMTicket.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMTicket.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMTicket.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMTicket.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMTicket.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMTicket.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMTicket.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMTicket.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMTicket.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMTicket.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMTicket.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMTicket.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMTicket.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMTicket.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMTicket.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMTicket.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMTicket.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMTicket.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMTicket.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMTicket.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMTicket.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMTicket.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMTicket.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMTicket.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMTicket.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMTicket.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMTicket.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMTicket.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMTicket.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMTicket.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMTicket.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMTicket.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMTicket.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMTicket.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMTicket.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMTicket.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMTicket.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMTicket.back_flag");
            }
            interface TICKET_O_T_M_TICKET {
                static String code () {
                    return "ticketOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "ticketOTMTicket.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "ticketOTMTicket.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "ticketOTMTicket.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "ticketOTMTicket.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "ticketOTMTicket.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "ticketOTMTicket.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "ticketOTMTicket.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "ticketOTMTicket.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "ticketOTMTicket.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "ticketOTMTicket.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "ticketOTMTicket.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticketOTMTicket.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "ticketOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.delete_flag");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "ticketOTMTicket.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ticketOTMTicket.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "ticketOTMTicket.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "ticketOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "ticketOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "ticketOTMTicket.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "ticketOTMTicket.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "ticketOTMTicket.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "ticketOTMTicket.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "ticketOTMTicket.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "ticketOTMTicket.reuse_tag");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "ticketOTMTicket.tenant_code");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "ticketOTMTicket.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "ticketOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "ticketOTMTicket.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "ticketOTMTicket.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "ticketOTMTicket.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "ticketOTMTicket.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "ticketOTMTicket.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "ticketOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "ticketOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "ticketOTMTicket.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "ticketOTMTicket.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "ticketOTMTicket.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "ticketOTMTicket.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "ticketOTMTicket.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "ticketOTMTicket.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "ticketOTMTicket.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "ticketOTMTicket.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "ticketOTMTicket.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "ticketOTMTicket.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "ticketOTMTicket.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "ticketOTMTicket.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "ticketOTMTicket.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "ticketOTMTicket.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "ticketOTMTicket.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "ticketOTMTicket.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "ticketOTMTicket.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "ticketOTMTicket.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "ticketOTMTicket.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "ticketOTMTicket.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "ticketOTMTicket.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "ticketOTMTicket.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "ticketOTMTicket.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "ticketOTMTicket.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "ticketOTMTicket.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "ticketOTMTicket.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "ticketOTMTicket.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "ticketOTMTicket.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "ticketOTMTicket.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "ticketOTMTicket.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "ticketOTMTicket.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "ticketOTMTicket.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "ticketOTMTicket.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "ticketOTMTicket.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "ticketOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "ticketOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "ticketOTMTicket.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "ticketOTMTicket.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "ticketOTMTicket.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "ticketOTMTicket.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "ticketOTMTicket.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "ticketOTMTicket.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "ticketOTMTicket.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "ticketOTMTicket.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "ticketOTMTicket.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "ticketOTMTicket.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "ticketOTMTicket.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "ticketOTMTicket.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "ticketOTMTicket.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "ticketOTMTicket.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "ticketOTMTicket.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "ticketOTMTicket.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "ticketOTMTicket.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "ticketOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "ticketOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "ticketOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "ticketOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "ticketOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "ticketOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "ticketOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "ticketOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "ticketOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "ticketOTMTicket.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "ticketOTMTicket.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "ticketOTMTicket.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "ticketOTMTicket.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "ticketOTMTicket.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "ticketOTMTicket.is_replace_order");
            }
            interface AREA {
                static String code () {
                    return "area" ;
                }
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "area.orgName");
                TypedField<Long> ID = new TypedField<>(Long.class, "area.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "area.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "area.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "area.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "area.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "area.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "area.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "area.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "area.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "area.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "area.orgId");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "area.orgCode");
            }
        }
    }
    public interface TicketPlane {
        static Long id() {
            return 1295238517556887554L;
        }
        static String code() {
            return "ticketPlane";
        }
        TypedField<String> NAME_OF_PASSENGER = new TypedField<>(String.class, "name_of_passenger");
        TypedField<String> ID_NO = new TypedField<>(String.class, "id_no");
        TypedField<String> E_TICKET_NO = new TypedField<>(String.class, "e_ticket_no");
        TypedField<String> ENDORSEMENTS = new TypedField<>(String.class, "endorsements");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serial_no");
        TypedField<String> INFORMATION = new TypedField<>(String.class, "information");
        TypedField<String> AGENT_CODE = new TypedField<>(String.class, "agent_code");
        TypedField<String> ISSUED_BY = new TypedField<>(String.class, "issued_by");
        TypedField<LocalDateTime> DATE_OF_ISSUE = new TypedField<>(LocalDateTime.class, "date_of_issue");
        TypedField<String> INSURANCE = new TypedField<>(String.class, "insurance");
        TypedField<BigDecimal> FARE = new TypedField<>(BigDecimal.class, "fare");
        TypedField<BigDecimal> CAAC_DEVELOPMENT_FUND = new TypedField<>(BigDecimal.class, "caac_development_fund");
        TypedField<BigDecimal> FUEL_SURCHARGE = new TypedField<>(BigDecimal.class, "fuel_surcharge");
        TypedField<BigDecimal> TOTAL = new TypedField<>(BigDecimal.class, "total");
        TypedField<BigDecimal> TAX = new TypedField<>(BigDecimal.class, "tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> IS_JOIN = new TypedField<>(String.class, "is_join");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticket_initial_value");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticket_change_value");
        TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "person_remark");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_STAMPER = new TypedField<>(String.class, "is_stamper");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "is_exist_sheet");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "check_sign_status");
        TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "check_sign_remark");
        TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "check_sign_task_id");
        TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_sign_request_time");
        TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "check_sign_user_id");
        TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "check_sign_user_name");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "charge_up_amount");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment_amount");
        TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "used_amount");
        TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "balance_amount");
        TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "charge_up_person");
        TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "payment_user_name");
        TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "is_original_ticket");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "business_key");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "all_system_labels");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "is_collection");
        TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "audit_back_status");
        TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "check_solution");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<String> ROOT_REGION = new TypedField<>(String.class, "root_region");
        TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "custom_region");
        TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "reimbursement_status");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofd_url");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdf_url");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xml_url");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "is_cover_ticket");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "copy_flag");
        TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "main_image_id");
        TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "origin_more_url");
        TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "reimbursement_time");
        TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "bill_system_source");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "is_delete");
        TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "is_replace_order");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_O_T_M_TICKET_ID = new TypedField<>(Long.class, "imageOTMTicket.id");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_TICKET_ID = new TypedField<>(Long.class, "billOTMTicket.id");
        /**
         * 对一关联关系 关联对象 ticket
         */
        TypedField<Long> TICKET_O_T_M_TICKET_ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> AREA_ID = new TypedField<>(Long.class, "area.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_O_T_M_TICKET {
                static String code () {
                    return "imageOTMTicket" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageOTMTicket.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageOTMTicket.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageOTMTicket.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageOTMTicket.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageOTMTicket.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageOTMTicket.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageOTMTicket.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageOTMTicket.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageOTMTicket.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageOTMTicket.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageOTMTicket.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageOTMTicket.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageOTMTicket.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageOTMTicket.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageOTMTicket.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageOTMTicket.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageOTMTicket.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageOTMTicket.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageOTMTicket.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageOTMTicket.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageOTMTicket.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageOTMTicket.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageOTMTicket.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageOTMTicket.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageOTMTicket.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageOTMTicket.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageOTMTicket.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageOTMTicket.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageOTMTicket.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageOTMTicket.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageOTMTicket.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageOTMTicket.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageOTMTicket.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageOTMTicket.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageOTMTicket.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageOTMTicket.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageOTMTicket.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageOTMTicket.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageOTMTicket.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageOTMTicket.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageOTMTicket.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageOTMTicket.file_all_images");
            }
            interface BILL_O_T_M_TICKET {
                static String code () {
                    return "billOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMTicket.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMTicket.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMTicket.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMTicket.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMTicket.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMTicket.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMTicket.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMTicket.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMTicket.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMTicket.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMTicket.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMTicket.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMTicket.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMTicket.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMTicket.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMTicket.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMTicket.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMTicket.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMTicket.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMTicket.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMTicket.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMTicket.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMTicket.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMTicket.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMTicket.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMTicket.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMTicket.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMTicket.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMTicket.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMTicket.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMTicket.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMTicket.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMTicket.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMTicket.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMTicket.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMTicket.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMTicket.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMTicket.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMTicket.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMTicket.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMTicket.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMTicket.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMTicket.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMTicket.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMTicket.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMTicket.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMTicket.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMTicket.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMTicket.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMTicket.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMTicket.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMTicket.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMTicket.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMTicket.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMTicket.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMTicket.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMTicket.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMTicket.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMTicket.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMTicket.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMTicket.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMTicket.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMTicket.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMTicket.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMTicket.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMTicket.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMTicket.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMTicket.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMTicket.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMTicket.back_flag");
            }
            interface TICKET_O_T_M_TICKET {
                static String code () {
                    return "ticketOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "ticketOTMTicket.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "ticketOTMTicket.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "ticketOTMTicket.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "ticketOTMTicket.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "ticketOTMTicket.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "ticketOTMTicket.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "ticketOTMTicket.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "ticketOTMTicket.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "ticketOTMTicket.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "ticketOTMTicket.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "ticketOTMTicket.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticketOTMTicket.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "ticketOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.delete_flag");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "ticketOTMTicket.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ticketOTMTicket.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "ticketOTMTicket.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "ticketOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "ticketOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "ticketOTMTicket.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "ticketOTMTicket.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "ticketOTMTicket.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "ticketOTMTicket.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "ticketOTMTicket.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "ticketOTMTicket.reuse_tag");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "ticketOTMTicket.tenant_code");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "ticketOTMTicket.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "ticketOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "ticketOTMTicket.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "ticketOTMTicket.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "ticketOTMTicket.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "ticketOTMTicket.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "ticketOTMTicket.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "ticketOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "ticketOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "ticketOTMTicket.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "ticketOTMTicket.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "ticketOTMTicket.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "ticketOTMTicket.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "ticketOTMTicket.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "ticketOTMTicket.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "ticketOTMTicket.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "ticketOTMTicket.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "ticketOTMTicket.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "ticketOTMTicket.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "ticketOTMTicket.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "ticketOTMTicket.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "ticketOTMTicket.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "ticketOTMTicket.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "ticketOTMTicket.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "ticketOTMTicket.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "ticketOTMTicket.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "ticketOTMTicket.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "ticketOTMTicket.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "ticketOTMTicket.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "ticketOTMTicket.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "ticketOTMTicket.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "ticketOTMTicket.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "ticketOTMTicket.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "ticketOTMTicket.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "ticketOTMTicket.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "ticketOTMTicket.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "ticketOTMTicket.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "ticketOTMTicket.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "ticketOTMTicket.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "ticketOTMTicket.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "ticketOTMTicket.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "ticketOTMTicket.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "ticketOTMTicket.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "ticketOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "ticketOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "ticketOTMTicket.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "ticketOTMTicket.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "ticketOTMTicket.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "ticketOTMTicket.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "ticketOTMTicket.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "ticketOTMTicket.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "ticketOTMTicket.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "ticketOTMTicket.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "ticketOTMTicket.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "ticketOTMTicket.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "ticketOTMTicket.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "ticketOTMTicket.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "ticketOTMTicket.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "ticketOTMTicket.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "ticketOTMTicket.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "ticketOTMTicket.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "ticketOTMTicket.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "ticketOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "ticketOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "ticketOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "ticketOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "ticketOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "ticketOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "ticketOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "ticketOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "ticketOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "ticketOTMTicket.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "ticketOTMTicket.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "ticketOTMTicket.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "ticketOTMTicket.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "ticketOTMTicket.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "ticketOTMTicket.is_replace_order");
            }
            interface AREA {
                static String code () {
                    return "area" ;
                }
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "area.orgName");
                TypedField<Long> ID = new TypedField<>(Long.class, "area.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "area.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "area.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "area.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "area.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "area.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "area.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "area.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "area.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "area.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "area.orgId");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "area.orgCode");
            }
        }
    }
    public interface TicketBus {
        static Long id() {
            return 1295238530781528066L;
        }
        static String code() {
            return "ticketBus";
        }
        TypedField<String> TRAINS = new TypedField<>(String.class, "trains");
        TypedField<String> START_STATION = new TypedField<>(String.class, "start_station");
        TypedField<String> END_STATION = new TypedField<>(String.class, "end_station");
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "start_date");
        TypedField<String> START_TIME = new TypedField<>(String.class, "start_time");
        TypedField<String> SEAT = new TypedField<>(String.class, "seat");
        TypedField<String> CARRIER = new TypedField<>(String.class, "carrier");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> IS_JOIN = new TypedField<>(String.class, "is_join");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticket_initial_value");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticket_change_value");
        TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "person_remark");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_STAMPER = new TypedField<>(String.class, "is_stamper");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "is_exist_sheet");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "check_sign_status");
        TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "check_sign_remark");
        TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "check_sign_task_id");
        TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_sign_request_time");
        TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "check_sign_user_id");
        TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "check_sign_user_name");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "charge_up_amount");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment_amount");
        TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "used_amount");
        TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "balance_amount");
        TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "charge_up_person");
        TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "payment_user_name");
        TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "is_original_ticket");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "business_key");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "all_system_labels");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "is_collection");
        TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "audit_back_status");
        TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "check_solution");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<String> ROOT_REGION = new TypedField<>(String.class, "root_region");
        TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "custom_region");
        TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "reimbursement_status");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofd_url");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdf_url");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xml_url");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "is_cover_ticket");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "copy_flag");
        TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "main_image_id");
        TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "origin_more_url");
        TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "reimbursement_time");
        TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "bill_system_source");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "is_delete");
        TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "is_replace_order");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_O_T_M_TICKET_ID = new TypedField<>(Long.class, "imageOTMTicket.id");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_TICKET_ID = new TypedField<>(Long.class, "billOTMTicket.id");
        /**
         * 对一关联关系 关联对象 ticket
         */
        TypedField<Long> TICKET_O_T_M_TICKET_ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> AREA_ID = new TypedField<>(Long.class, "area.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_O_T_M_TICKET {
                static String code () {
                    return "imageOTMTicket" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageOTMTicket.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageOTMTicket.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageOTMTicket.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageOTMTicket.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageOTMTicket.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageOTMTicket.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageOTMTicket.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageOTMTicket.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageOTMTicket.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageOTMTicket.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageOTMTicket.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageOTMTicket.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageOTMTicket.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageOTMTicket.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageOTMTicket.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageOTMTicket.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageOTMTicket.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageOTMTicket.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageOTMTicket.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageOTMTicket.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageOTMTicket.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageOTMTicket.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageOTMTicket.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageOTMTicket.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageOTMTicket.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageOTMTicket.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageOTMTicket.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageOTMTicket.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageOTMTicket.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageOTMTicket.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageOTMTicket.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageOTMTicket.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageOTMTicket.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageOTMTicket.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageOTMTicket.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageOTMTicket.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageOTMTicket.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageOTMTicket.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageOTMTicket.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageOTMTicket.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageOTMTicket.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageOTMTicket.file_all_images");
            }
            interface BILL_O_T_M_TICKET {
                static String code () {
                    return "billOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMTicket.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMTicket.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMTicket.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMTicket.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMTicket.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMTicket.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMTicket.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMTicket.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMTicket.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMTicket.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMTicket.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMTicket.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMTicket.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMTicket.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMTicket.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMTicket.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMTicket.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMTicket.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMTicket.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMTicket.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMTicket.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMTicket.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMTicket.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMTicket.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMTicket.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMTicket.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMTicket.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMTicket.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMTicket.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMTicket.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMTicket.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMTicket.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMTicket.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMTicket.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMTicket.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMTicket.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMTicket.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMTicket.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMTicket.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMTicket.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMTicket.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMTicket.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMTicket.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMTicket.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMTicket.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMTicket.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMTicket.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMTicket.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMTicket.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMTicket.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMTicket.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMTicket.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMTicket.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMTicket.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMTicket.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMTicket.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMTicket.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMTicket.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMTicket.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMTicket.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMTicket.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMTicket.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMTicket.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMTicket.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMTicket.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMTicket.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMTicket.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMTicket.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMTicket.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMTicket.back_flag");
            }
            interface TICKET_O_T_M_TICKET {
                static String code () {
                    return "ticketOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "ticketOTMTicket.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "ticketOTMTicket.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "ticketOTMTicket.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "ticketOTMTicket.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "ticketOTMTicket.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "ticketOTMTicket.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "ticketOTMTicket.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "ticketOTMTicket.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "ticketOTMTicket.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "ticketOTMTicket.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "ticketOTMTicket.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticketOTMTicket.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "ticketOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.delete_flag");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "ticketOTMTicket.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ticketOTMTicket.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "ticketOTMTicket.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "ticketOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "ticketOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "ticketOTMTicket.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "ticketOTMTicket.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "ticketOTMTicket.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "ticketOTMTicket.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "ticketOTMTicket.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "ticketOTMTicket.reuse_tag");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "ticketOTMTicket.tenant_code");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "ticketOTMTicket.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "ticketOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "ticketOTMTicket.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "ticketOTMTicket.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "ticketOTMTicket.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "ticketOTMTicket.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "ticketOTMTicket.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "ticketOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "ticketOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "ticketOTMTicket.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "ticketOTMTicket.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "ticketOTMTicket.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "ticketOTMTicket.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "ticketOTMTicket.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "ticketOTMTicket.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "ticketOTMTicket.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "ticketOTMTicket.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "ticketOTMTicket.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "ticketOTMTicket.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "ticketOTMTicket.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "ticketOTMTicket.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "ticketOTMTicket.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "ticketOTMTicket.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "ticketOTMTicket.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "ticketOTMTicket.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "ticketOTMTicket.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "ticketOTMTicket.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "ticketOTMTicket.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "ticketOTMTicket.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "ticketOTMTicket.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "ticketOTMTicket.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "ticketOTMTicket.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "ticketOTMTicket.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "ticketOTMTicket.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "ticketOTMTicket.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "ticketOTMTicket.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "ticketOTMTicket.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "ticketOTMTicket.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "ticketOTMTicket.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "ticketOTMTicket.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "ticketOTMTicket.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "ticketOTMTicket.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "ticketOTMTicket.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "ticketOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "ticketOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "ticketOTMTicket.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "ticketOTMTicket.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "ticketOTMTicket.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "ticketOTMTicket.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "ticketOTMTicket.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "ticketOTMTicket.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "ticketOTMTicket.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "ticketOTMTicket.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "ticketOTMTicket.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "ticketOTMTicket.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "ticketOTMTicket.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "ticketOTMTicket.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "ticketOTMTicket.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "ticketOTMTicket.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "ticketOTMTicket.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "ticketOTMTicket.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "ticketOTMTicket.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "ticketOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "ticketOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "ticketOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "ticketOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "ticketOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "ticketOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "ticketOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "ticketOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "ticketOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "ticketOTMTicket.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "ticketOTMTicket.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "ticketOTMTicket.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "ticketOTMTicket.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "ticketOTMTicket.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "ticketOTMTicket.is_replace_order");
            }
            interface AREA {
                static String code () {
                    return "area" ;
                }
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "area.orgName");
                TypedField<Long> ID = new TypedField<>(Long.class, "area.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "area.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "area.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "area.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "area.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "area.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "area.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "area.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "area.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "area.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "area.orgId");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "area.orgCode");
            }
        }
    }
    public interface TicketToll {
        static Long id() {
            return 1295238541565083650L;
        }
        static String code() {
            return "ticketToll";
        }
        TypedField<String> EXIT_PLACE = new TypedField<>(String.class, "exit_place");
        TypedField<String> ENTRANCE_PLACE = new TypedField<>(String.class, "entrance_place");
        TypedField<LocalDateTime> START_DATE = new TypedField<>(LocalDateTime.class, "start_date");
        TypedField<String> PAYMENT = new TypedField<>(String.class, "payment");
        TypedField<String> VEHICLES_TYPE = new TypedField<>(String.class, "vehicles_type");
        TypedField<String> VEHICLES_WEIGHT = new TypedField<>(String.class, "vehicles_weight");
        TypedField<String> TOLL_LIMIT = new TypedField<>(String.class, "toll_limit");
        TypedField<String> TIME = new TypedField<>(String.class, "time");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "scan_time");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "invoice_sheet");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> RECHECK = new TypedField<>(String.class, "recheck");
        TypedField<String> DRAWER = new TypedField<>(String.class, "drawer");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> IS_REPLACE = new TypedField<>(String.class, "is_replace");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "commodity_inspection_no");
        TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "certification_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "import_certificate_no");
        TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "charge_tax_authority_code");
        TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "charge_tax_authority_name");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> DQ_CODE = new TypedField<>(String.class, "dq_code");
        TypedField<String> DQ_NAME = new TypedField<>(String.class, "dq_name");
        TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "is_electric_invoice");
        TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "is_source_file");
        TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "source_file_type");
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> IS_JOIN = new TypedField<>(String.class, "is_join");
        TypedField<String> QRCODE = new TypedField<>(String.class, "qrcode");
        TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "invoice_code_p");
        TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "invoice_no_p");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticket_initial_value");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticket_change_value");
        TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "person_remark");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_STAMPER = new TypedField<>(String.class, "is_stamper");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "is_exist_sheet");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "check_sign_status");
        TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "check_sign_remark");
        TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "check_sign_task_id");
        TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_sign_request_time");
        TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "check_sign_user_id");
        TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "check_sign_user_name");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "charge_up_amount");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "payment_amount");
        TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "used_amount");
        TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "balance_amount");
        TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "charge_up_person");
        TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "payment_user_name");
        TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "is_original_ticket");
        TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "business_key");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "all_system_labels");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "is_collection");
        TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "audit_back_status");
        TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "check_solution");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<String> ROOT_REGION = new TypedField<>(String.class, "root_region");
        TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "custom_region");
        TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "reimbursement_status");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofd_url");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdf_url");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xml_url");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "is_cover_ticket");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "copy_flag");
        TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "main_image_id");
        TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "origin_more_url");
        TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "reimbursement_time");
        TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "bill_system_source");
        TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "is_delete");
        TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "is_replace_order");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> IMAGE_O_T_M_TICKET_ID = new TypedField<>(Long.class, "imageOTMTicket.id");
        /**
         * 对一关联关系 关联对象 baseBill
         */
        TypedField<Long> BILL_O_T_M_TICKET_ID = new TypedField<>(Long.class, "billOTMTicket.id");
        /**
         * 对一关联关系 关联对象 ticket
         */
        TypedField<Long> TICKET_O_T_M_TICKET_ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
        /**
         * 对一关联关系 关联对象 orgInfo
         */
        TypedField<Long> AREA_ID = new TypedField<>(Long.class, "area.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface IMAGE_O_T_M_TICKET {
                static String code () {
                    return "imageOTMTicket" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "imageOTMTicket.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "imageOTMTicket.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "imageOTMTicket.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "imageOTMTicket.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "imageOTMTicket.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "imageOTMTicket.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "imageOTMTicket.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "imageOTMTicket.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "imageOTMTicket.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "imageOTMTicket.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "imageOTMTicket.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "imageOTMTicket.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "imageOTMTicket.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "imageOTMTicket.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "imageOTMTicket.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "imageOTMTicket.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "imageOTMTicket.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "imageOTMTicket.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "imageOTMTicket.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "imageOTMTicket.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "imageOTMTicket.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "imageOTMTicket.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "imageOTMTicket.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "imageOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "imageOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "imageOTMTicket.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "imageOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "imageOTMTicket.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "imageOTMTicket.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "imageOTMTicket.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "imageOTMTicket.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "imageOTMTicket.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "imageOTMTicket.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "imageOTMTicket.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "imageOTMTicket.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "imageOTMTicket.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "imageOTMTicket.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "imageOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "imageOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "imageOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "imageOTMTicket.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "imageOTMTicket.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "imageOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "imageOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "imageOTMTicket.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "imageOTMTicket.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "imageOTMTicket.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "imageOTMTicket.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "imageOTMTicket.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "imageOTMTicket.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "imageOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "imageOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "imageOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "imageOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "imageOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "imageOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "imageOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "imageOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "imageOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "imageOTMTicket.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "imageOTMTicket.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "imageOTMTicket.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "imageOTMTicket.file_all_images");
            }
            interface BILL_O_T_M_TICKET {
                static String code () {
                    return "billOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "billOTMTicket.image_id");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTMTicket.batch_no");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "billOTMTicket.bill_type_code");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTMTicket.bill_code");
                TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_with_tax");
                TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_tax_amount");
                TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.bill_amount_without_tax");
                TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "billOTMTicket.bill_create_user");
                TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_create_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "billOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "billOTMTicket.scan_user_name");
                TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.scan_create_time");
                TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "billOTMTicket.package_code");
                TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "billOTMTicket.logistics_status");
                TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.logistics_time");
                TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "billOTMTicket.sign_status");
                TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.sign_time");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTMTicket.is_public");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billOTMTicket.logistic_remark");
                TypedField<String> HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.hang_type");
                TypedField<String> HANG_REASON = new TypedField<>(String.class, "billOTMTicket.hang_reason");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "billOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "billOTMTicket.back_reason");
                TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_data_status");
                TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_data_time");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "billOTMTicket.verify_status");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.verify_time");
                TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "billOTMTicket.ticket_count");
                TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "billOTMTicket.image_count");
                TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "billOTMTicket.exception_count");
                TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "billOTMTicket.warning_count");
                TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.is_exception");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTMTicket.exception_info");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billOTMTicket.system_orig");
                TypedField<String> IS_SECRET = new TypedField<>(String.class, "billOTMTicket.is_secret");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "billOTMTicket.back_remark");
                TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "billOTMTicket.unquality_type");
                TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "billOTMTicket.unquality_reason");
                TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "billOTMTicket.verify_hang_type");
                TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "billOTMTicket.verify_hang_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTMTicket.delete_flag");
                TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "billOTMTicket.is_prepayment");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "billOTMTicket.ext_fields");
                TypedField<String> EXT_STATUS = new TypedField<>(String.class, "billOTMTicket.ext_status");
                TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "billOTMTicket.prepayment_status");
                TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.prepayment_time");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTMTicket.create_user_code");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOTMTicket.seller_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_tax_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billOTMTicket.purchaser_name");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTMTicket.serial_number");
                TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "billOTMTicket.bill_check_status");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "billOTMTicket.purchaser_code");
                TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.bill_check_time");
                TypedField<String> REMARK = new TypedField<>(String.class, "billOTMTicket.remark");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "billOTMTicket.seller_code");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTMTicket.tenant_code");
                TypedField<String> BACK_ORIG = new TypedField<>(String.class, "billOTMTicket.back_orig");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTMTicket.calculate_status");
                TypedField<String> IS_WARNING = new TypedField<>(String.class, "billOTMTicket.is_warning");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTMTicket.warning_info");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billOTMTicket.purchaser_no");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "billOTMTicket.back_user");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTMTicket.reserved3");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTMTicket.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.commit_time");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "billOTMTicket.upload_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTMTicket.org_code");
                TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "billOTMTicket.is_push_bill");
                TypedField<String> IS_COVER = new TypedField<>(String.class, "billOTMTicket.is_cover");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "billOTMTicket.system_source");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "billOTMTicket.is_add");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "billOTMTicket.is_change");
                TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "billOTMTicket.business_type");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billOTMTicket.settlement_no");
                TypedField<String> BILL_USE = new TypedField<>(String.class, "billOTMTicket.bill_use");
                TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "billOTMTicket.system_orig_external");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "billOTMTicket.compare_status");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billOTMTicket.audit_status");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "billOTMTicket.audit_remark");
                TypedField<String> PAY_STATUS = new TypedField<>(String.class, "billOTMTicket.pay_status");
                TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.complete_time");
                TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "billOTMTicket.settlement_type");
                TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "billOTMTicket.ticket_exception");
                TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "billOTMTicket.ticket_warning");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTMTicket.ext10");
                TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "billOTMTicket.main_bill_data_status");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billOTMTicket.audit_time");
                TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "billOTMTicket.receive_status");
                TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "billOTMTicket.compare_triggered");
                TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "billOTMTicket.electric_count");
                TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "billOTMTicket.paper_count");
                TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "billOTMTicket.commit_remark");
                TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "billOTMTicket.audit_user_id");
                TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "billOTMTicket.audit_user_name");
                TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "billOTMTicket.bill_create_email");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "billOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "billOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "billOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "billOTMTicket.warning_detail");
                TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.normal_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.special_amount_with_tax");
                TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.special_tax_amount");
                TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_normal_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_amount_with_tax");
                TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billOTMTicket.coop_special_tax_amount");
                TypedField<String> BACK_FLAG = new TypedField<>(String.class, "billOTMTicket.back_flag");
            }
            interface TICKET_O_T_M_TICKET {
                static String code () {
                    return "ticketOTMTicket" ;
                }
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "ticketOTMTicket.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "ticketOTMTicket.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "ticketOTMTicket.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "ticketOTMTicket.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "ticketOTMTicket.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "ticketOTMTicket.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "ticketOTMTicket.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "ticketOTMTicket.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "ticketOTMTicket.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "ticketOTMTicket.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "ticketOTMTicket.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticketOTMTicket.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "ticketOTMTicket.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "ticketOTMTicket.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "ticketOTMTicket.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.delete_flag");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "ticketOTMTicket.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ticketOTMTicket.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "ticketOTMTicket.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "ticketOTMTicket.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "ticketOTMTicket.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "ticketOTMTicket.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "ticketOTMTicket.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "ticketOTMTicket.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "ticketOTMTicket.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "ticketOTMTicket.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "ticketOTMTicket.reuse_tag");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "ticketOTMTicket.tenant_code");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "ticketOTMTicket.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "ticketOTMTicket.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "ticketOTMTicket.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "ticketOTMTicket.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "ticketOTMTicket.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "ticketOTMTicket.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "ticketOTMTicket.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "ticketOTMTicket.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "ticketOTMTicket.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "ticketOTMTicket.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "ticketOTMTicket.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "ticketOTMTicket.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "ticketOTMTicket.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "ticketOTMTicket.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "ticketOTMTicket.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "ticketOTMTicket.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "ticketOTMTicket.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "ticketOTMTicket.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "ticketOTMTicket.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "ticketOTMTicket.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "ticketOTMTicket.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "ticketOTMTicket.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "ticketOTMTicket.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "ticketOTMTicket.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "ticketOTMTicket.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "ticketOTMTicket.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "ticketOTMTicket.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "ticketOTMTicket.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "ticketOTMTicket.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "ticketOTMTicket.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "ticketOTMTicket.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "ticketOTMTicket.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "ticketOTMTicket.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "ticketOTMTicket.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "ticketOTMTicket.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "ticketOTMTicket.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "ticketOTMTicket.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "ticketOTMTicket.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "ticketOTMTicket.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "ticketOTMTicket.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "ticketOTMTicket.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "ticketOTMTicket.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "ticketOTMTicket.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "ticketOTMTicket.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "ticketOTMTicket.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "ticketOTMTicket.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "ticketOTMTicket.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "ticketOTMTicket.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "ticketOTMTicket.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "ticketOTMTicket.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "ticketOTMTicket.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "ticketOTMTicket.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "ticketOTMTicket.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "ticketOTMTicket.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "ticketOTMTicket.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "ticketOTMTicket.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "ticketOTMTicket.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "ticketOTMTicket.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "ticketOTMTicket.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "ticketOTMTicket.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "ticketOTMTicket.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "ticketOTMTicket.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "ticketOTMTicket.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "ticketOTMTicket.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "ticketOTMTicket.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "ticketOTMTicket.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "ticketOTMTicket.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "ticketOTMTicket.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "ticketOTMTicket.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "ticketOTMTicket.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "ticketOTMTicket.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "ticketOTMTicket.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "ticketOTMTicket.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "ticketOTMTicket.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "ticketOTMTicket.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "ticketOTMTicket.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "ticketOTMTicket.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "ticketOTMTicket.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "ticketOTMTicket.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "ticketOTMTicket.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "ticketOTMTicket.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "ticketOTMTicket.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "ticketOTMTicket.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "ticketOTMTicket.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "ticketOTMTicket.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "ticketOTMTicket.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "ticketOTMTicket.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "ticketOTMTicket.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "ticketOTMTicket.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "ticketOTMTicket.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "ticketOTMTicket.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "ticketOTMTicket.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "ticketOTMTicket.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "ticketOTMTicket.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "ticketOTMTicket.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "ticketOTMTicket.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "ticketOTMTicket.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "ticketOTMTicket.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "ticketOTMTicket.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "ticketOTMTicket.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "ticketOTMTicket.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "ticketOTMTicket.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "ticketOTMTicket.is_replace_order");
            }
            interface AREA {
                static String code () {
                    return "area" ;
                }
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "area.orgName");
                TypedField<Long> ID = new TypedField<>(Long.class, "area.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "area.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "area.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "area.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "area.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "area.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "area.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "area.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "area.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "area.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "area.orgId");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "area.orgCode");
            }
        }
    }
    public interface ReceiveFiles {
        static Long id() {
            return 1295238550381510657L;
        }
        static String code() {
            return "receiveFiles";
        }
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> VOUCHER_CODE = new TypedField<>(String.class, "voucher_code");
        TypedField<String> IMAGE_FILE_URL = new TypedField<>(String.class, "image_file_url");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> IMAGE_FILE_TYPE = new TypedField<>(String.class, "image_file_type");
        TypedField<String> BILL_CODE_TYPE = new TypedField<>(String.class, "bill_code_type");
        TypedField<String> COMPANY_ID = new TypedField<>(String.class, "company_id");
        TypedField<String> FILE_SUFFIX = new TypedField<>(String.class, "file_suffix");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
    }
    public interface TicketPlaneDetail {
        static Long id() {
            return 1295238564914774018L;
        }
        static String code() {
            return "ticketPlaneDetail";
        }
        TypedField<String> CARRIER = new TypedField<>(String.class, "carrier");
        TypedField<String> PLANE_FROM = new TypedField<>(String.class, "plane_from");
        TypedField<String> PLANE_TO = new TypedField<>(String.class, "plane_to");
        TypedField<String> FLIGHT = new TypedField<>(String.class, "flight");
        TypedField<String> PLANE_DATE = new TypedField<>(String.class, "plane_date");
        TypedField<String> PLANE_TIME = new TypedField<>(String.class, "plane_time");
        TypedField<String> SEAT_CLASS = new TypedField<>(String.class, "seat_class");
        TypedField<String> FARE_BASIS = new TypedField<>(String.class, "fare_basis");
        TypedField<String> NOT_VALID_BEFORE = new TypedField<>(String.class, "not_valid_before");
        TypedField<String> NOT_VALID_AFTER = new TypedField<>(String.class, "not_valid_after");
        TypedField<String> ALLOW = new TypedField<>(String.class, "allow");
        TypedField<Long> TICKET_ID = new TypedField<>(Long.class, "ticket_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> SUMMARY = new TypedField<>(String.class, "summary");
        TypedField<String> EXTRA = new TypedField<>(String.class, "extra");
        /**
         * 对一关联关系 关联对象 ticketPlane
         */
        TypedField<Long> ITEMS_ID = new TypedField<>(Long.class, "items.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ITEMS {
                static String code () {
                    return "items" ;
                }
                TypedField<String> NAME_OF_PASSENGER = new TypedField<>(String.class, "items.name_of_passenger");
                TypedField<String> ID_NO = new TypedField<>(String.class, "items.id_no");
                TypedField<String> E_TICKET_NO = new TypedField<>(String.class, "items.e_ticket_no");
                TypedField<String> ENDORSEMENTS = new TypedField<>(String.class, "items.endorsements");
                TypedField<String> SERIAL_NO = new TypedField<>(String.class, "items.serial_no");
                TypedField<String> INFORMATION = new TypedField<>(String.class, "items.information");
                TypedField<String> AGENT_CODE = new TypedField<>(String.class, "items.agent_code");
                TypedField<String> ISSUED_BY = new TypedField<>(String.class, "items.issued_by");
                TypedField<LocalDateTime> DATE_OF_ISSUE = new TypedField<>(LocalDateTime.class, "items.date_of_issue");
                TypedField<String> INSURANCE = new TypedField<>(String.class, "items.insurance");
                TypedField<BigDecimal> FARE = new TypedField<>(BigDecimal.class, "items.fare");
                TypedField<BigDecimal> CAAC_DEVELOPMENT_FUND = new TypedField<>(BigDecimal.class, "items.caac_development_fund");
                TypedField<BigDecimal> FUEL_SURCHARGE = new TypedField<>(BigDecimal.class, "items.fuel_surcharge");
                TypedField<BigDecimal> TOTAL = new TypedField<>(BigDecimal.class, "items.total");
                TypedField<BigDecimal> TAX = new TypedField<>(BigDecimal.class, "items.tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "items.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "items.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "items.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "items.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "items.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "items.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "items.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "items.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "items.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "items.delete_flag");
                TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "items.image_id");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "items.bill_code");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "items.batch_no");
                TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "items.warning_status");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "items.warning_info");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "items.exception_status");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "items.exception_info");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "items.check_status");
                TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "items.check_remark");
                TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "items.check_task_id");
                TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "items.check_request_time");
                TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "items.check_response_time");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "items.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "items.check_user_name");
                TypedField<String> IS_HOOKED = new TypedField<>(String.class, "items.is_hooked");
                TypedField<Long> X_POINT = new TypedField<>(Long.class, "items.x_point");
                TypedField<Long> Y_POINT = new TypedField<>(Long.class, "items.y_point");
                TypedField<Long> WIDTH = new TypedField<>(Long.class, "items.width");
                TypedField<Long> HEIGHT = new TypedField<>(Long.class, "items.height");
                TypedField<Long> ANGLE = new TypedField<>(Long.class, "items.angle");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "items.ticket_code");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "items.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "items.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "items.amount_with_tax");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "items.is_public");
                TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "items.ext_fields");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "items.is_reuse");
                TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "items.ticket_status");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "items.reserved1");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "items.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "items.reserved3");
                TypedField<String> IS_REPEAT = new TypedField<>(String.class, "items.is_repeat");
                TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "items.repeat_tag");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "items.create_user_code");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "items.system_orig");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "items.bill_entity_code");
                TypedField<String> REUSE_TAG = new TypedField<>(String.class, "items.reuse_tag");
                TypedField<String> BACK_STATUS = new TypedField<>(String.class, "items.back_status");
                TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "items.back_time");
                TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "items.scan_user_id");
                TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "items.scan_user_name");
                TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "items.is_sales_list");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "items.calculate_status");
                TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "items.ticket_check_status");
                TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "items.handle_status");
                TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "items.commit_status");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "items.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "items.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "items.commit_time");
                TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "items.hook_time");
                TypedField<String> BACK_TYPE = new TypedField<>(String.class, "items.back_type");
                TypedField<String> BACK_REASON = new TypedField<>(String.class, "items.back_reason");
                TypedField<String> BACK_REMARK = new TypedField<>(String.class, "items.back_remark");
                TypedField<String> BACK_USER = new TypedField<>(String.class, "items.back_user");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "items.invoice_code");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "items.invoice_no");
                TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "items.invoice_date");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "items.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "items.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "items.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "items.seller_tax_no");
                TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "items.upload_status");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "items.purchaser_no");
                TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "items.purchaser_code");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "items.seller_no");
                TypedField<String> SELLER_CODE = new TypedField<>(String.class, "items.seller_code");
                TypedField<LocalDateTime> SCAN_TIME = new TypedField<>(LocalDateTime.class, "items.scan_time");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "items.invoice_status");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "items.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "items.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "items.org_code");
                TypedField<String> REMARK = new TypedField<>(String.class, "items.remark");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "items.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "items.origin_invoice_no");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "items.invoice_type");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "items.check_code");
                TypedField<String> INVOICE_SHEET = new TypedField<>(String.class, "items.invoice_sheet");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "items.machine_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "items.cipher_text");
                TypedField<String> PAYEE = new TypedField<>(String.class, "items.payee");
                TypedField<String> RECHECK = new TypedField<>(String.class, "items.recheck");
                TypedField<String> DRAWER = new TypedField<>(String.class, "items.drawer");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "items.tax_rate");
                TypedField<String> IS_REPLACE = new TypedField<>(String.class, "items.is_replace");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "items.special_invoice_flag");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "items.purchaser_address");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "items.purchaser_tel");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "items.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "items.purchaser_bank_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "items.purchaser_bank_account");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "items.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "items.seller_address");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "items.seller_tel");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "items.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "items.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "items.seller_bank_account");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "items.seller_bank_name_account");
                TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "items.vehicle_type");
                TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "items.vehicle_brand");
                TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "items.production_area");
                TypedField<String> ENGINE_NO = new TypedField<>(String.class, "items.engine_no");
                TypedField<String> COMMODITY_INSPECTION_NO = new TypedField<>(String.class, "items.commodity_inspection_no");
                TypedField<String> CERTIFICATION_NO = new TypedField<>(String.class, "items.certification_no");
                TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "items.vehicle_no");
                TypedField<String> IMPORT_CERTIFICATE_NO = new TypedField<>(String.class, "items.import_certificate_no");
                TypedField<String> CHARGE_TAX_AUTHORITY_CODE = new TypedField<>(String.class, "items.charge_tax_authority_code");
                TypedField<String> CHARGE_TAX_AUTHORITY_NAME = new TypedField<>(String.class, "items.charge_tax_authority_name");
                TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "items.tax_paid_proof");
                TypedField<String> TONNAGE = new TypedField<>(String.class, "items.tonnage");
                TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "items.max_capacity");
                TypedField<String> DQ_CODE = new TypedField<>(String.class, "items.dq_code");
                TypedField<String> DQ_NAME = new TypedField<>(String.class, "items.dq_name");
                TypedField<String> IS_ELECTRIC_INVOICE = new TypedField<>(String.class, "items.is_electric_invoice");
                TypedField<String> IS_SOURCE_FILE = new TypedField<>(String.class, "items.is_source_file");
                TypedField<String> SOURCE_FILE_TYPE = new TypedField<>(String.class, "items.source_file_type");
                TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "items.currency_type");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "items.paper_drew_date");
                TypedField<String> IS_JOIN = new TypedField<>(String.class, "items.is_join");
                TypedField<String> QRCODE = new TypedField<>(String.class, "items.qrcode");
                TypedField<String> INVOICE_CODE_P = new TypedField<>(String.class, "items.invoice_code_p");
                TypedField<String> INVOICE_NO_P = new TypedField<>(String.class, "items.invoice_no_p");
                TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "items.system_source");
                TypedField<String> TICKET_INITIAL_VALUE = new TypedField<>(String.class, "items.ticket_initial_value");
                TypedField<String> IS_CHANGE = new TypedField<>(String.class, "items.is_change");
                TypedField<String> TICKET_CHANGE_VALUE = new TypedField<>(String.class, "items.ticket_change_value");
                TypedField<String> PERSON_REMARK = new TypedField<>(String.class, "items.person_remark");
                TypedField<String> IS_ADD = new TypedField<>(String.class, "items.is_add");
                TypedField<String> IS_STAMPER = new TypedField<>(String.class, "items.is_stamper");
                TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "items.bill_type_code");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "items.serial_number");
                TypedField<String> IS_EXIST_SHEET = new TypedField<>(String.class, "items.is_exist_sheet");
                TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "items.exception_key");
                TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "items.exception_detail");
                TypedField<String> WARNING_KEY = new TypedField<>(String.class, "items.warning_key");
                TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "items.warning_detail");
                TypedField<String> CHECK_SIGN_STATUS = new TypedField<>(String.class, "items.check_sign_status");
                TypedField<String> CHECK_SIGN_REMARK = new TypedField<>(String.class, "items.check_sign_remark");
                TypedField<String> CHECK_SIGN_TASK_ID = new TypedField<>(String.class, "items.check_sign_task_id");
                TypedField<LocalDateTime> CHECK_SIGN_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "items.check_sign_request_time");
                TypedField<Long> CHECK_SIGN_USER_ID = new TypedField<>(Long.class, "items.check_sign_user_id");
                TypedField<String> CHECK_SIGN_USER_NAME = new TypedField<>(String.class, "items.check_sign_user_name");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "items.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "items.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "items.charge_up_no");
                TypedField<BigDecimal> CHARGE_UP_AMOUNT = new TypedField<>(BigDecimal.class, "items.charge_up_amount");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "items.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "items.payment_no");
                TypedField<BigDecimal> PAYMENT_AMOUNT = new TypedField<>(BigDecimal.class, "items.payment_amount");
                TypedField<BigDecimal> USED_AMOUNT = new TypedField<>(BigDecimal.class, "items.used_amount");
                TypedField<BigDecimal> BALANCE_AMOUNT = new TypedField<>(BigDecimal.class, "items.balance_amount");
                TypedField<String> CHARGE_UP_PERSON = new TypedField<>(String.class, "items.charge_up_person");
                TypedField<String> PAYMENT_USER_NAME = new TypedField<>(String.class, "items.payment_user_name");
                TypedField<String> IS_ORIGINAL_TICKET = new TypedField<>(String.class, "items.is_original_ticket");
                TypedField<String> BUSINESS_KEY = new TypedField<>(String.class, "items.business_key");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "items.sign_for_status");
                TypedField<String> ALL_SYSTEM_LABELS = new TypedField<>(String.class, "items.all_system_labels");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "items.payment_date");
                TypedField<String> IS_COLLECTION = new TypedField<>(String.class, "items.is_collection");
                TypedField<String> AUDIT_BACK_STATUS = new TypedField<>(String.class, "items.audit_back_status");
                TypedField<String> CHECK_SOLUTION = new TypedField<>(String.class, "items.check_solution");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "items.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "items.area_name");
                TypedField<String> ROOT_REGION = new TypedField<>(String.class, "items.root_region");
                TypedField<String> CUSTOM_REGION = new TypedField<>(String.class, "items.custom_region");
                TypedField<String> REIMBURSEMENT_STATUS = new TypedField<>(String.class, "items.reimbursement_status");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "items.ofd_url");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "items.pdf_url");
                TypedField<String> XML_URL = new TypedField<>(String.class, "items.xml_url");
                TypedField<String> EXT1 = new TypedField<>(String.class, "items.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "items.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "items.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "items.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "items.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "items.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "items.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "items.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "items.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "items.ext10");
                TypedField<Boolean> IS_COVER_TICKET = new TypedField<>(Boolean.class, "items.is_cover_ticket");
                TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "items.compare_status");
                TypedField<Boolean> COPY_FLAG = new TypedField<>(Boolean.class, "items.copy_flag");
                TypedField<Long> MAIN_IMAGE_ID = new TypedField<>(Long.class, "items.main_image_id");
                TypedField<String> ORIGIN_MORE_URL = new TypedField<>(String.class, "items.origin_more_url");
                TypedField<LocalDateTime> REIMBURSEMENT_TIME = new TypedField<>(LocalDateTime.class, "items.reimbursement_time");
                TypedField<String> BILL_SYSTEM_SOURCE = new TypedField<>(String.class, "items.bill_system_source");
                TypedField<Boolean> IS_DELETE = new TypedField<>(Boolean.class, "items.is_delete");
                TypedField<Boolean> IS_REPLACE_ORDER = new TypedField<>(Boolean.class, "items.is_replace_order");
            }
        }
    }
    public interface BillTicketRelation {
        static Long id() {
            return 1295238583474569217L;
        }
        static String code() {
            return "billTicketRelation";
        }
        TypedField<Long> TENANT = new TypedField<>(Long.class, "tenant");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<Long> TICKET_ID = new TypedField<>(Long.class, "ticket_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> REPEAT_USER_NAME = new TypedField<>(String.class, "repeat_user_name");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "scan_create_time");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
    }
    public interface PublicBill {
        static Long id() {
            return 1295238599056408578L;
        }
        static String code() {
            return "publicBill";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "bill_amount_with_tax");
        TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "bill_tax_amount");
        TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "bill_amount_without_tax");
        TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "bill_create_user");
        TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "bill_create_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "scan_create_time");
        TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "package_code");
        TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "logistics_status");
        TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "logistics_time");
        TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "sign_status");
        TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "sign_time");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logistic_remark");
        TypedField<String> HANG_TYPE = new TypedField<>(String.class, "hang_type");
        TypedField<String> HANG_REASON = new TypedField<>(String.class, "hang_reason");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "bill_data_status");
        TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "bill_data_time");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "verify_time");
        TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "ticket_count");
        TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "image_count");
        TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "exception_count");
        TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "warning_count");
        TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "is_exception");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> IS_SECRET = new TypedField<>(String.class, "is_secret");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "unquality_type");
        TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "unquality_reason");
        TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "verify_hang_type");
        TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "verify_hang_reason");
        TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "is_prepayment");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> EXT_STATUS = new TypedField<>(String.class, "ext_status");
        TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "prepayment_status");
        TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "prepayment_time");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "bill_check_status");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "bill_check_time");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> BACK_ORIG = new TypedField<>(String.class, "back_orig");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> IS_WARNING = new TypedField<>(String.class, "is_warning");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "is_push_bill");
        TypedField<String> IS_COVER = new TypedField<>(String.class, "is_cover");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "business_type");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> BILL_USE = new TypedField<>(String.class, "bill_use");
        TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "system_orig_external");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "audit_remark");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "pay_status");
        TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "complete_time");
        TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "settlement_type");
        TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "ticket_exception");
        TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "ticket_warning");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "main_bill_data_status");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "receive_status");
        TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "compare_triggered");
        TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "electric_count");
        TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "paper_count");
        TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "commit_remark");
        TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "audit_user_id");
        TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "audit_user_name");
        TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "bill_create_email");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "normal_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "special_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "special_tax_amount");
        TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_normal_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_special_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "coop_special_tax_amount");
        TypedField<String> BACK_FLAG = new TypedField<>(String.class, "back_flag");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> BILL_O_T_O_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_O_T_O_IMAGE {
                static String code () {
                    return "billOTOImage" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "billOTOImage.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "billOTOImage.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "billOTOImage.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "billOTOImage.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "billOTOImage.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "billOTOImage.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "billOTOImage.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "billOTOImage.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "billOTOImage.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "billOTOImage.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "billOTOImage.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "billOTOImage.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "billOTOImage.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "billOTOImage.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "billOTOImage.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTOImage.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "billOTOImage.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "billOTOImage.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTOImage.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "billOTOImage.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "billOTOImage.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "billOTOImage.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTOImage.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTOImage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTOImage.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTOImage.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTOImage.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTOImage.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTOImage.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "billOTOImage.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "billOTOImage.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "billOTOImage.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "billOTOImage.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTOImage.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "billOTOImage.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTOImage.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTOImage.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTOImage.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTOImage.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTOImage.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTOImage.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "billOTOImage.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTOImage.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTOImage.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTOImage.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTOImage.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "billOTOImage.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "billOTOImage.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "billOTOImage.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTOImage.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTOImage.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTOImage.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTOImage.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTOImage.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTOImage.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTOImage.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTOImage.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTOImage.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTOImage.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTOImage.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTOImage.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "billOTOImage.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "billOTOImage.file_all_images");
            }
        }
    }
    public interface PrivateBill {
        static Long id() {
            return 1295238601375858690L;
        }
        static String code() {
            return "privateBill";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "bill_amount_with_tax");
        TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "bill_tax_amount");
        TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "bill_amount_without_tax");
        TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "bill_create_user");
        TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "bill_create_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "scan_create_time");
        TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "package_code");
        TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "logistics_status");
        TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "logistics_time");
        TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "sign_status");
        TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "sign_time");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logistic_remark");
        TypedField<String> HANG_TYPE = new TypedField<>(String.class, "hang_type");
        TypedField<String> HANG_REASON = new TypedField<>(String.class, "hang_reason");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "bill_data_status");
        TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "bill_data_time");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "verify_time");
        TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "ticket_count");
        TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "image_count");
        TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "exception_count");
        TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "warning_count");
        TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "is_exception");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> IS_SECRET = new TypedField<>(String.class, "is_secret");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "unquality_type");
        TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "unquality_reason");
        TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "verify_hang_type");
        TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "verify_hang_reason");
        TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "is_prepayment");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> EXT_STATUS = new TypedField<>(String.class, "ext_status");
        TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "prepayment_status");
        TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "prepayment_time");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "bill_check_status");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "bill_check_time");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> BACK_ORIG = new TypedField<>(String.class, "back_orig");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> IS_WARNING = new TypedField<>(String.class, "is_warning");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "is_push_bill");
        TypedField<String> IS_COVER = new TypedField<>(String.class, "is_cover");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "business_type");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> BILL_USE = new TypedField<>(String.class, "bill_use");
        TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "system_orig_external");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "audit_remark");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "pay_status");
        TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "complete_time");
        TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "settlement_type");
        TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "ticket_exception");
        TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "ticket_warning");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "main_bill_data_status");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "receive_status");
        TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "compare_triggered");
        TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "electric_count");
        TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "paper_count");
        TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "commit_remark");
        TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "audit_user_id");
        TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "audit_user_name");
        TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "bill_create_email");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "normal_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "special_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "special_tax_amount");
        TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_normal_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_special_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "coop_special_tax_amount");
        TypedField<String> BACK_FLAG = new TypedField<>(String.class, "back_flag");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> BILL_O_T_O_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_O_T_O_IMAGE {
                static String code () {
                    return "billOTOImage" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "billOTOImage.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "billOTOImage.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "billOTOImage.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "billOTOImage.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "billOTOImage.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "billOTOImage.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "billOTOImage.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "billOTOImage.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "billOTOImage.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "billOTOImage.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "billOTOImage.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "billOTOImage.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "billOTOImage.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "billOTOImage.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "billOTOImage.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTOImage.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "billOTOImage.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "billOTOImage.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTOImage.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "billOTOImage.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "billOTOImage.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "billOTOImage.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTOImage.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTOImage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTOImage.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTOImage.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTOImage.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTOImage.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTOImage.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "billOTOImage.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "billOTOImage.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "billOTOImage.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "billOTOImage.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTOImage.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "billOTOImage.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTOImage.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTOImage.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTOImage.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTOImage.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTOImage.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTOImage.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "billOTOImage.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTOImage.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTOImage.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTOImage.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTOImage.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "billOTOImage.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "billOTOImage.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "billOTOImage.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTOImage.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTOImage.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTOImage.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTOImage.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTOImage.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTOImage.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTOImage.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTOImage.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTOImage.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTOImage.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTOImage.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTOImage.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "billOTOImage.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "billOTOImage.file_all_images");
            }
        }
    }
    public interface PurchaseBill {
        static Long id() {
            return 1295238603737251842L;
        }
        static String code() {
            return "purchaseBill";
        }
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<String> CONTACT_TEL = new TypedField<>(String.class, "contact_tel");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "bill_amount_with_tax");
        TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "bill_tax_amount");
        TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "bill_amount_without_tax");
        TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "bill_create_user");
        TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "bill_create_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "scan_create_time");
        TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "package_code");
        TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "logistics_status");
        TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "logistics_time");
        TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "sign_status");
        TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "sign_time");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logistic_remark");
        TypedField<String> HANG_TYPE = new TypedField<>(String.class, "hang_type");
        TypedField<String> HANG_REASON = new TypedField<>(String.class, "hang_reason");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "bill_data_status");
        TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "bill_data_time");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "verify_time");
        TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "ticket_count");
        TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "image_count");
        TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "exception_count");
        TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "warning_count");
        TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "is_exception");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> IS_SECRET = new TypedField<>(String.class, "is_secret");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "unquality_type");
        TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "unquality_reason");
        TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "verify_hang_type");
        TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "verify_hang_reason");
        TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "is_prepayment");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> EXT_STATUS = new TypedField<>(String.class, "ext_status");
        TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "prepayment_status");
        TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "prepayment_time");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "bill_check_status");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "bill_check_time");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> BACK_ORIG = new TypedField<>(String.class, "back_orig");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> IS_WARNING = new TypedField<>(String.class, "is_warning");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "is_push_bill");
        TypedField<String> IS_COVER = new TypedField<>(String.class, "is_cover");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "business_type");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> BILL_USE = new TypedField<>(String.class, "bill_use");
        TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "system_orig_external");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "audit_remark");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "pay_status");
        TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "complete_time");
        TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "settlement_type");
        TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "ticket_exception");
        TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "ticket_warning");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "main_bill_data_status");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "receive_status");
        TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "compare_triggered");
        TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "electric_count");
        TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "paper_count");
        TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "commit_remark");
        TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "audit_user_id");
        TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "audit_user_name");
        TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "bill_create_email");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "normal_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "special_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "special_tax_amount");
        TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_normal_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_special_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "coop_special_tax_amount");
        TypedField<String> BACK_FLAG = new TypedField<>(String.class, "back_flag");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> BILL_O_T_O_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_O_T_O_IMAGE {
                static String code () {
                    return "billOTOImage" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "billOTOImage.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "billOTOImage.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "billOTOImage.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "billOTOImage.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "billOTOImage.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "billOTOImage.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "billOTOImage.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "billOTOImage.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "billOTOImage.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "billOTOImage.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "billOTOImage.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "billOTOImage.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "billOTOImage.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "billOTOImage.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "billOTOImage.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTOImage.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "billOTOImage.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "billOTOImage.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTOImage.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "billOTOImage.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "billOTOImage.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "billOTOImage.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTOImage.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTOImage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTOImage.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTOImage.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTOImage.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTOImage.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTOImage.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "billOTOImage.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "billOTOImage.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "billOTOImage.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "billOTOImage.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTOImage.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "billOTOImage.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTOImage.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTOImage.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTOImage.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTOImage.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTOImage.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTOImage.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "billOTOImage.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTOImage.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTOImage.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTOImage.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTOImage.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "billOTOImage.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "billOTOImage.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "billOTOImage.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTOImage.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTOImage.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTOImage.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTOImage.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTOImage.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTOImage.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTOImage.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTOImage.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTOImage.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTOImage.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTOImage.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTOImage.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "billOTOImage.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "billOTOImage.file_all_images");
            }
        }
    }
    public interface BankBill {
        static Long id() {
            return 1295238606794899457L;
        }
        static String code() {
            return "bankBill";
        }
        TypedField<String> CURRENCY_TYPE = new TypedField<>(String.class, "currency_type");
        TypedField<String> CONTACT_TEL = new TypedField<>(String.class, "contact_tel");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "bill_amount_with_tax");
        TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "bill_tax_amount");
        TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "bill_amount_without_tax");
        TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "bill_create_user");
        TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "bill_create_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "scan_create_time");
        TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "package_code");
        TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "logistics_status");
        TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "logistics_time");
        TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "sign_status");
        TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "sign_time");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logistic_remark");
        TypedField<String> HANG_TYPE = new TypedField<>(String.class, "hang_type");
        TypedField<String> HANG_REASON = new TypedField<>(String.class, "hang_reason");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "bill_data_status");
        TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "bill_data_time");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "verify_time");
        TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "ticket_count");
        TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "image_count");
        TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "exception_count");
        TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "warning_count");
        TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "is_exception");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> IS_SECRET = new TypedField<>(String.class, "is_secret");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "unquality_type");
        TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "unquality_reason");
        TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "verify_hang_type");
        TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "verify_hang_reason");
        TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "is_prepayment");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> EXT_STATUS = new TypedField<>(String.class, "ext_status");
        TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "prepayment_status");
        TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "prepayment_time");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "bill_check_status");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "bill_check_time");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> BACK_ORIG = new TypedField<>(String.class, "back_orig");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> IS_WARNING = new TypedField<>(String.class, "is_warning");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "is_push_bill");
        TypedField<String> IS_COVER = new TypedField<>(String.class, "is_cover");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "business_type");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> BILL_USE = new TypedField<>(String.class, "bill_use");
        TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "system_orig_external");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "audit_remark");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "pay_status");
        TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "complete_time");
        TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "settlement_type");
        TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "ticket_exception");
        TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "ticket_warning");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "main_bill_data_status");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "receive_status");
        TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "compare_triggered");
        TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "electric_count");
        TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "paper_count");
        TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "commit_remark");
        TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "audit_user_id");
        TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "audit_user_name");
        TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "bill_create_email");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "normal_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "special_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "special_tax_amount");
        TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_normal_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_special_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "coop_special_tax_amount");
        TypedField<String> BACK_FLAG = new TypedField<>(String.class, "back_flag");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> BILL_O_T_O_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_O_T_O_IMAGE {
                static String code () {
                    return "billOTOImage" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "billOTOImage.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "billOTOImage.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "billOTOImage.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "billOTOImage.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "billOTOImage.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "billOTOImage.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "billOTOImage.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "billOTOImage.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "billOTOImage.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "billOTOImage.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "billOTOImage.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "billOTOImage.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "billOTOImage.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "billOTOImage.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "billOTOImage.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTOImage.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "billOTOImage.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "billOTOImage.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTOImage.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "billOTOImage.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "billOTOImage.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "billOTOImage.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTOImage.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTOImage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTOImage.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTOImage.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTOImage.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTOImage.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTOImage.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "billOTOImage.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "billOTOImage.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "billOTOImage.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "billOTOImage.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTOImage.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "billOTOImage.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTOImage.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTOImage.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTOImage.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTOImage.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTOImage.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTOImage.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "billOTOImage.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTOImage.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTOImage.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTOImage.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTOImage.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "billOTOImage.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "billOTOImage.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "billOTOImage.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTOImage.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTOImage.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTOImage.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTOImage.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTOImage.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTOImage.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTOImage.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTOImage.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTOImage.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTOImage.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTOImage.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTOImage.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "billOTOImage.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "billOTOImage.file_all_images");
            }
        }
    }
    public interface OtherBill {
        static Long id() {
            return 1295238609709940737L;
        }
        static String code() {
            return "otherBill";
        }
        TypedField<String> YEAR = new TypedField<>(String.class, "year");
        TypedField<String> MONTH = new TypedField<>(String.class, "month");
        TypedField<String> CONTRACT_TYPE = new TypedField<>(String.class, "contract_type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> BILL_TYPE_CODE = new TypedField<>(String.class, "bill_type_code");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<BigDecimal> BILL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "bill_amount_with_tax");
        TypedField<BigDecimal> BILL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "bill_tax_amount");
        TypedField<BigDecimal> BILL_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "bill_amount_without_tax");
        TypedField<String> BILL_CREATE_USER = new TypedField<>(String.class, "bill_create_user");
        TypedField<LocalDateTime> BILL_CREATE_TIME = new TypedField<>(LocalDateTime.class, "bill_create_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<LocalDateTime> SCAN_CREATE_TIME = new TypedField<>(LocalDateTime.class, "scan_create_time");
        TypedField<String> PACKAGE_CODE = new TypedField<>(String.class, "package_code");
        TypedField<String> LOGISTICS_STATUS = new TypedField<>(String.class, "logistics_status");
        TypedField<LocalDateTime> LOGISTICS_TIME = new TypedField<>(LocalDateTime.class, "logistics_time");
        TypedField<String> SIGN_STATUS = new TypedField<>(String.class, "sign_status");
        TypedField<LocalDateTime> SIGN_TIME = new TypedField<>(LocalDateTime.class, "sign_time");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logistic_remark");
        TypedField<String> HANG_TYPE = new TypedField<>(String.class, "hang_type");
        TypedField<String> HANG_REASON = new TypedField<>(String.class, "hang_reason");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BILL_DATA_STATUS = new TypedField<>(String.class, "bill_data_status");
        TypedField<LocalDateTime> BILL_DATA_TIME = new TypedField<>(LocalDateTime.class, "bill_data_time");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "verify_time");
        TypedField<Long> TICKET_COUNT = new TypedField<>(Long.class, "ticket_count");
        TypedField<Long> IMAGE_COUNT = new TypedField<>(Long.class, "image_count");
        TypedField<Long> EXCEPTION_COUNT = new TypedField<>(Long.class, "exception_count");
        TypedField<Long> WARNING_COUNT = new TypedField<>(Long.class, "warning_count");
        TypedField<String> IS_EXCEPTION = new TypedField<>(String.class, "is_exception");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> IS_SECRET = new TypedField<>(String.class, "is_secret");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> UNQUALITY_TYPE = new TypedField<>(String.class, "unquality_type");
        TypedField<String> UNQUALITY_REASON = new TypedField<>(String.class, "unquality_reason");
        TypedField<String> VERIFY_HANG_TYPE = new TypedField<>(String.class, "verify_hang_type");
        TypedField<String> VERIFY_HANG_REASON = new TypedField<>(String.class, "verify_hang_reason");
        TypedField<String> IS_PREPAYMENT = new TypedField<>(String.class, "is_prepayment");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> EXT_STATUS = new TypedField<>(String.class, "ext_status");
        TypedField<String> PREPAYMENT_STATUS = new TypedField<>(String.class, "prepayment_status");
        TypedField<LocalDateTime> PREPAYMENT_TIME = new TypedField<>(LocalDateTime.class, "prepayment_time");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> BILL_CHECK_STATUS = new TypedField<>(String.class, "bill_check_status");
        TypedField<String> PURCHASER_CODE = new TypedField<>(String.class, "purchaser_code");
        TypedField<LocalDateTime> BILL_CHECK_TIME = new TypedField<>(LocalDateTime.class, "bill_check_time");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> SELLER_CODE = new TypedField<>(String.class, "seller_code");
        TypedField<String> BACK_ORIG = new TypedField<>(String.class, "back_orig");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> IS_WARNING = new TypedField<>(String.class, "is_warning");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_COMMIT = new TypedField<>(String.class, "is_commit");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> ORG_NAME = new TypedField<>(String.class, "org_name");
        TypedField<String> ORG_CODE = new TypedField<>(String.class, "org_code");
        TypedField<String> IS_PUSH_BILL = new TypedField<>(String.class, "is_push_bill");
        TypedField<String> IS_COVER = new TypedField<>(String.class, "is_cover");
        TypedField<String> SYSTEM_SOURCE = new TypedField<>(String.class, "system_source");
        TypedField<String> IS_ADD = new TypedField<>(String.class, "is_add");
        TypedField<String> IS_CHANGE = new TypedField<>(String.class, "is_change");
        TypedField<String> BUSINESS_TYPE = new TypedField<>(String.class, "business_type");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> BILL_USE = new TypedField<>(String.class, "bill_use");
        TypedField<String> SYSTEM_ORIG_EXTERNAL = new TypedField<>(String.class, "system_orig_external");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compare_status");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "audit_remark");
        TypedField<String> PAY_STATUS = new TypedField<>(String.class, "pay_status");
        TypedField<LocalDateTime> COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "complete_time");
        TypedField<String> SETTLEMENT_TYPE = new TypedField<>(String.class, "settlement_type");
        TypedField<String> TICKET_EXCEPTION = new TypedField<>(String.class, "ticket_exception");
        TypedField<String> TICKET_WARNING = new TypedField<>(String.class, "ticket_warning");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> MAIN_BILL_DATA_STATUS = new TypedField<>(String.class, "main_bill_data_status");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "receive_status");
        TypedField<Boolean> COMPARE_TRIGGERED = new TypedField<>(Boolean.class, "compare_triggered");
        TypedField<Long> ELECTRIC_COUNT = new TypedField<>(Long.class, "electric_count");
        TypedField<Long> PAPER_COUNT = new TypedField<>(Long.class, "paper_count");
        TypedField<String> COMMIT_REMARK = new TypedField<>(String.class, "commit_remark");
        TypedField<Long> AUDIT_USER_ID = new TypedField<>(Long.class, "audit_user_id");
        TypedField<String> AUDIT_USER_NAME = new TypedField<>(String.class, "audit_user_name");
        TypedField<String> BILL_CREATE_EMAIL = new TypedField<>(String.class, "bill_create_email");
        TypedField<String> EXCEPTION_KEY = new TypedField<>(String.class, "exception_key");
        TypedField<String> EXCEPTION_DETAIL = new TypedField<>(String.class, "exception_detail");
        TypedField<String> WARNING_KEY = new TypedField<>(String.class, "warning_key");
        TypedField<String> WARNING_DETAIL = new TypedField<>(String.class, "warning_detail");
        TypedField<BigDecimal> NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "normal_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "special_amount_with_tax");
        TypedField<BigDecimal> SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "special_tax_amount");
        TypedField<BigDecimal> COOP_NORMAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_normal_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "coop_special_amount_with_tax");
        TypedField<BigDecimal> COOP_SPECIAL_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "coop_special_tax_amount");
        TypedField<String> BACK_FLAG = new TypedField<>(String.class, "back_flag");
        /**
         * 对一关联关系 关联对象 image
         */
        TypedField<Long> BILL_O_T_O_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_O_T_O_IMAGE {
                static String code () {
                    return "billOTOImage" ;
                }
                TypedField<String> IMAGE_TYPE = new TypedField<>(String.class, "billOTOImage.image_type");
                TypedField<String> IMAGE_SOURCE = new TypedField<>(String.class, "billOTOImage.image_source");
                TypedField<String> REQUIRE_OCR_FLAG = new TypedField<>(String.class, "billOTOImage.require_ocr_flag");
                TypedField<String> FILE_URL = new TypedField<>(String.class, "billOTOImage.file_url");
                TypedField<String> FILE_URL_HANDLE = new TypedField<>(String.class, "billOTOImage.file_url_handle");
                TypedField<String> FILE_URL_ORIGIN = new TypedField<>(String.class, "billOTOImage.file_url_origin");
                TypedField<String> FILE_TYPE = new TypedField<>(String.class, "billOTOImage.file_type");
                TypedField<String> FILE_TYPE_HANDLE = new TypedField<>(String.class, "billOTOImage.file_type_handle");
                TypedField<String> FILE_ORDER = new TypedField<>(String.class, "billOTOImage.file_order");
                TypedField<Long> FILE_LEVEL = new TypedField<>(Long.class, "billOTOImage.file_level");
                TypedField<String> REC_STATUS = new TypedField<>(String.class, "billOTOImage.rec_status");
                TypedField<String> TASK_ID = new TypedField<>(String.class, "billOTOImage.task_id");
                TypedField<Long> COPY_COUNT = new TypedField<>(Long.class, "billOTOImage.copy_count");
                TypedField<LocalDateTime> REC_START_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_start_time");
                TypedField<LocalDateTime> REC_END_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.rec_end_time");
                TypedField<Long> BILL_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.bill_image_id");
                TypedField<Long> TICKET_IMAGE_ID = new TypedField<>(Long.class, "billOTOImage.ticket_image_id");
                TypedField<String> STATUS = new TypedField<>(String.class, "billOTOImage.status");
                TypedField<String> IS_MANUAL_UNHOOK = new TypedField<>(String.class, "billOTOImage.is_manual_unhook");
                TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "billOTOImage.is_public");
                TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "billOTOImage.exception_status");
                TypedField<String> RETURN_STATUS = new TypedField<>(String.class, "billOTOImage.return_status");
                TypedField<String> BATCH_NO = new TypedField<>(String.class, "billOTOImage.batch_no");
                TypedField<String> IMAGE_CATEGORY = new TypedField<>(String.class, "billOTOImage.image_category");
                TypedField<String> RETURN_REASON = new TypedField<>(String.class, "billOTOImage.return_reason");
                TypedField<String> RETURN_REMARK = new TypedField<>(String.class, "billOTOImage.return_remark");
                TypedField<String> RESERVED1 = new TypedField<>(String.class, "billOTOImage.reserved1");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOTOImage.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOTOImage.tenant_id");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOTOImage.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOTOImage.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOTOImage.delete_flag");
                TypedField<String> BILL_CODE = new TypedField<>(String.class, "billOTOImage.bill_code");
                TypedField<String> RESERVED2 = new TypedField<>(String.class, "billOTOImage.reserved2");
                TypedField<String> RESERVED3 = new TypedField<>(String.class, "billOTOImage.reserved3");
                TypedField<String> FILE_URL_LOCAL = new TypedField<>(String.class, "billOTOImage.file_url_local");
                TypedField<String> IS_REUSE = new TypedField<>(String.class, "billOTOImage.is_reuse");
                TypedField<String> PAGE_CODE = new TypedField<>(String.class, "billOTOImage.page_code");
                TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "billOTOImage.bill_entity_code");
                TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "billOTOImage.create_user_code");
                TypedField<String> MORE_FILE_URL = new TypedField<>(String.class, "billOTOImage.more_file_url");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOTOImage.tenant_code");
                TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "billOTOImage.exception_info");
                TypedField<String> WARNING_INFO = new TypedField<>(String.class, "billOTOImage.warning_info");
                TypedField<String> IS_COMMIT = new TypedField<>(String.class, "billOTOImage.is_commit");
                TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "billOTOImage.commit_user_id");
                TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "billOTOImage.commit_user_name");
                TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "billOTOImage.commit_time");
                TypedField<String> RETURN_TYPE = new TypedField<>(String.class, "billOTOImage.return_type");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "billOTOImage.org_id");
                TypedField<String> ORG_NAME = new TypedField<>(String.class, "billOTOImage.org_name");
                TypedField<String> ORG_CODE = new TypedField<>(String.class, "billOTOImage.org_code");
                TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "billOTOImage.calculate_status");
                TypedField<String> FILE_NAME = new TypedField<>(String.class, "billOTOImage.file_name");
                TypedField<String> TICKET_CODE = new TypedField<>(String.class, "billOTOImage.ticket_code");
                TypedField<Long> FILE_ID = new TypedField<>(Long.class, "billOTOImage.file_id");
                TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "billOTOImage.serial_number");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billOTOImage.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billOTOImage.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billOTOImage.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billOTOImage.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billOTOImage.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billOTOImage.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billOTOImage.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billOTOImage.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billOTOImage.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billOTOImage.ext10");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOTOImage.seller_tax_no");
                TypedField<String> TICKET_PRE_DATA = new TypedField<>(String.class, "billOTOImage.ticket_pre_data");
                TypedField<String> FILE_ALL_IMAGES = new TypedField<>(String.class, "billOTOImage.file_all_images");
            }
        }
    }
    public interface TicketUsedCar {
        static Long id() {
            return 1295238639594356738L;
        }
        static String code() {
            return "ticketUsedCar";
        }
        TypedField<String> REGISTRATION_NO = new TypedField<>(String.class, "registration_no");
        TypedField<String> AUCTIONEERS_NAME = new TypedField<>(String.class, "auctioneers_name");
        TypedField<String> AUCTIONEERS_ADDRESS = new TypedField<>(String.class, "auctioneers_address");
        TypedField<String> AUCTIONEERS_TAX_NO = new TypedField<>(String.class, "auctioneers_tax_no");
        TypedField<String> AUCTIONEERS_BANK_INFO = new TypedField<>(String.class, "auctioneers_bank_info");
        TypedField<String> AUCTIONEERS_TEL = new TypedField<>(String.class, "auctioneers_tel");
        TypedField<String> USED_CAR_MARKET_NAME = new TypedField<>(String.class, "used_car_market_name");
        TypedField<String> USED_CAR_MARKET_ADDRESS = new TypedField<>(String.class, "used_car_market_address");
        TypedField<String> USED_CAR_MARKET_TAX_NO = new TypedField<>(String.class, "used_car_market_tax_no");
        TypedField<String> USED_CAR_MARKET_BANK_INFO = new TypedField<>(String.class, "used_car_market_bank_info");
        TypedField<String> USED_CAR_MARKET_TEL = new TypedField<>(String.class, "used_car_market_tel");
        TypedField<String> CAR_NUMBER = new TypedField<>(String.class, "car_number");
        TypedField<String> DP_NAME = new TypedField<>(String.class, "dp_name");
        TypedField<String> VEHICLE_PLACE_NAME = new TypedField<>(String.class, "vehicle_place_name");
        TypedField<String> AUCTIONEERS_BANK = new TypedField<>(String.class, "auctioneers_bank");
        TypedField<String> USED_CAR_MARKET_BANK = new TypedField<>(String.class, "used_car_market_bank");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> IMAGE_ID = new TypedField<>(Long.class, "image_id");
        TypedField<String> BILL_CODE = new TypedField<>(String.class, "bill_code");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> WARNING_STATUS = new TypedField<>(String.class, "warning_status");
        TypedField<String> WARNING_INFO = new TypedField<>(String.class, "warning_info");
        TypedField<String> EXCEPTION_STATUS = new TypedField<>(String.class, "exception_status");
        TypedField<String> EXCEPTION_INFO = new TypedField<>(String.class, "exception_info");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> CHECK_REMARK = new TypedField<>(String.class, "check_remark");
        TypedField<String> CHECK_TASK_ID = new TypedField<>(String.class, "check_task_id");
        TypedField<LocalDateTime> CHECK_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "check_request_time");
        TypedField<LocalDateTime> CHECK_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "check_response_time");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<String> IS_HOOKED = new TypedField<>(String.class, "is_hooked");
        TypedField<Long> X_POINT = new TypedField<>(Long.class, "x_point");
        TypedField<Long> Y_POINT = new TypedField<>(Long.class, "y_point");
        TypedField<Long> WIDTH = new TypedField<>(Long.class, "width");
        TypedField<Long> HEIGHT = new TypedField<>(Long.class, "height");
        TypedField<Long> ANGLE = new TypedField<>(Long.class, "angle");
        TypedField<String> TICKET_CODE = new TypedField<>(String.class, "ticket_code");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> IS_PUBLIC = new TypedField<>(String.class, "is_public");
        TypedField<String> EXT_FIELDS = new TypedField<>(String.class, "ext_fields");
        TypedField<String> IS_REUSE = new TypedField<>(String.class, "is_reuse");
        TypedField<String> TICKET_STATUS = new TypedField<>(String.class, "ticket_status");
        TypedField<String> RESERVED1 = new TypedField<>(String.class, "reserved1");
        TypedField<String> RESERVED2 = new TypedField<>(String.class, "reserved2");
        TypedField<String> RESERVED3 = new TypedField<>(String.class, "reserved3");
        TypedField<String> IS_REPEAT = new TypedField<>(String.class, "is_repeat");
        TypedField<String> REPEAT_TAG = new TypedField<>(String.class, "repeat_tag");
        TypedField<String> CREATE_USER_CODE = new TypedField<>(String.class, "create_user_code");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BILL_ENTITY_CODE = new TypedField<>(String.class, "bill_entity_code");
        TypedField<String> REUSE_TAG = new TypedField<>(String.class, "reuse_tag");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<Long> SCAN_USER_ID = new TypedField<>(Long.class, "scan_user_id");
        TypedField<String> SCAN_USER_NAME = new TypedField<>(String.class, "scan_user_name");
        TypedField<String> IS_SALES_LIST = new TypedField<>(String.class, "is_sales_list");
        TypedField<String> CALCULATE_STATUS = new TypedField<>(String.class, "calculate_status");
        TypedField<String> TICKET_CHECK_STATUS = new TypedField<>(String.class, "ticket_check_status");
        TypedField<String> HANDLE_STATUS = new TypedField<>(String.class, "handle_status");
        TypedField<String> COMMIT_STATUS = new TypedField<>(String.class, "commit_status");
        TypedField<Long> COMMIT_USER_ID = new TypedField<>(Long.class, "commit_user_id");
        TypedField<String> COMMIT_USER_NAME = new TypedField<>(String.class, "commit_user_name");
        TypedField<LocalDateTime> COMMIT_TIME = new TypedField<>(LocalDateTime.class, "commit_time");
        TypedField<LocalDateTime> HOOK_TIME = new TypedField<>(LocalDateTime.class, "hook_time");
        TypedField<String> BACK_TYPE = new TypedField<>(String.class, "back_type");
        TypedField<String> BACK_REASON = new TypedField<>(String.class, "back_reason");
        TypedField<String> BACK_REMARK = new TypedField<>(String.class, "back_remark");
        TypedField<String> BACK_USER = new TypedField<>(String.class, "back_user");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<LocalDateTime> INVOICE_DATE = new TypedField<>(LocalDateTime.class, "invoice_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> PURCHAS