package com.xforceplus.ultraman.app.imagesaas.metadata.validator;

import com.xforceplus.ultraman.app.imagesaas.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.imagesaas.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-11-06
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(ImageType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageType.class.getSimpleName());
            }
        }
        if(clazz.equals(SignStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SignStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SignStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillDataStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillDataStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillDataStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VerifyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VerifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsPublic.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsPublic.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsPublic.class.getSimpleName());
            }
        }
        if(clazz.equals(IsSecret.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsSecret.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsSecret.class.getSimpleName());
            }
        }
        if(clazz.equals(BackType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BackType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BackType.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageSource.class.getSimpleName());
            }
        }
        if(clazz.equals(RecStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FileType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FileType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FileType.class.getSimpleName());
            }
        }
        if(clazz.equals(YesNo.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YesNo.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YesNo.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LogisticsStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LogisticsStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LogisticsStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSheet.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceSheet.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceSheet.class.getSimpleName());
            }
        }
        if(clazz.equals(TicketType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TicketType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TicketType.class.getSimpleName());
            }
        }
        if(clazz.equals(ExceptionStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExceptionStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExceptionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BackStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BackStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfigDataMappingType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConfigDataMappingType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConfigDataMappingType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(UseStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UseStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageCategory.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageCategory.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(UnqualityType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UnqualityType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UnqualityType.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyHangType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VerifyHangType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VerifyHangType.class.getSimpleName());
            }
        }
        if(clazz.equals(BackReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BackReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BackReason.class.getSimpleName());
            }
        }
        if(clazz.equals(HangType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HangType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HangType.class.getSimpleName());
            }
        }
        if(clazz.equals(TicketStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TicketStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TicketStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageFileType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageFileType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageFileType.class.getSimpleName());
            }
        }
        if(clazz.equals(ExtStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExtStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExtStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PrepaymentStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PrepaymentStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PrepaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PageCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PageCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PageCode.class.getSimpleName());
            }
        }
        if(clazz.equals(MacthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MacthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MacthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CurrencyType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CurrencyType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CurrencyType.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialInvoiceFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SpecialInvoiceFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SpecialInvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(BillCheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillCheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillCheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SalesListConfig.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SalesListConfig.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SalesListConfig.class.getSimpleName());
            }
        }
        if(clazz.equals(BackOrig.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BackOrig.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BackOrig.class.getSimpleName());
            }
        }
        if(clazz.equals(CalculateStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CalculateStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CalculateStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OkOrFail.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OkOrFail.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OkOrFail.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UploadStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UploadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ExpensesType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExpensesType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExpensesType.class.getSimpleName());
            }
        }
        if(clazz.equals(CommitStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CommitStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CommitStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillCodeSubType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillCodeSubType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillCodeSubType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaskType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskHistoryType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaskHistoryType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaskHistoryType.class.getSimpleName());
            }
        }
        if(clazz.equals(OperationEntity.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OperationEntity.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OperationEntity.class.getSimpleName());
            }
        }
        if(clazz.equals(OperationType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OperationType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OperationType.class.getSimpleName());
            }
        }
        if(clazz.equals(VehicleSheet.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VehicleSheet.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VehicleSheet.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(FileOperationType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FileOperationType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FileOperationType.class.getSimpleName());
            }
        }
        if(clazz.equals(TransformStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TransformStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TransformStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillUse.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillUse.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillUse.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemOrigExternal.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SystemOrigExternal.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SystemOrigExternal.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CompareStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CompareStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ManyModel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ManyModel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ManyModel.class.getSimpleName());
            }
        }
        if(clazz.equals(BillTypeCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillTypeCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillTypeCode.class.getSimpleName());
            }
        }
        if(clazz.equals(PayStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PayStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PayStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MachineCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MachineCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MachineCode.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleDefineEnums.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RuleDefineEnums.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RuleDefineEnums.class.getSimpleName());
            }
        }
        if(clazz.equals(DeployMode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DeployMode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DeployMode.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageExt2.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageExt2.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageExt2.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageExt4.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageExt4.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageExt4.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageExt6.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageExt6.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageExt6.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageExt8.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageExt8.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageExt8.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageExt10.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageExt10.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageExt10.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessLogType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessLogType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessLogType.class.getSimpleName());
            }
        }
        if(clazz.equals(SettlementType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SettlementType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SettlementType.class.getSimpleName());
            }
        }
        if(clazz.equals(TicketCheckOptions.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TicketCheckOptions.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TicketCheckOptions.class.getSimpleName());
            }
        }
        if(clazz.equals(TicketCheckIcons.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TicketCheckIcons.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TicketCheckIcons.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckSignStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckSignStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckSignStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeUpStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditBackStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditBackStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditBackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IncomeSystem.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IncomeSystem.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IncomeSystem.class.getSimpleName());
            }
        }
        if(clazz.equals(PayeeSubject.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PayeeSubject.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PayeeSubject.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckCategory.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckCategory.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckType.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckGroup.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckGroup.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckGroup.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomsFormType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CustomsFormType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CustomsFormType.class.getSimpleName());
            }
        }
        if(clazz.equals(HttpMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HttpMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HttpMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(ReimbursementStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReimbursementStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReimbursementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsHooked.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsHooked.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsHooked.class.getSimpleName());
            }
        }
        if(clazz.equals(TransformScene.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TransformScene.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TransformScene.class.getSimpleName());
            }
        }
        if(clazz.equals(SnaphostFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnaphostFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnaphostFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MultipurposeTicketModel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MultipurposeTicketModel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MultipurposeTicketModel.class.getSimpleName());
            }
        }
        if(clazz.equals(ManySplitUrlModel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ManySplitUrlModel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ManySplitUrlModel.class.getSimpleName());
            }
        }
        if(clazz.equals(IsConfirm.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsConfirm.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsConfirm.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiveStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceiveStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceiveStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(BillCheckOptions.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillCheckOptions.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillCheckOptions.class.getSimpleName());
            }
        }
        if(clazz.equals(BillCheckIcons.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillCheckIcons.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillCheckIcons.class.getSimpleName());
            }
        }
        if(clazz.equals(VoucherType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VoucherType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VoucherType.class.getSimpleName());
            }
        }
        if(clazz.equals(BackFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BackFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BackFlag.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
