package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketVehicle;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareTicketVehicleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的机动车销售统一发票前端控制器
 *
 * @author ultraman
 * @date 2021-11-04
 */
@RestController
public class CompareTicketVehicleController {

  @Autowired
  private ICompareTicketVehicleService compareTicketVehicleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketVehicle 数据比对用途的机动车销售统一发票
   * @return
   */
  @GetMapping("/compareticketvehicles" )
  public XfR getCompareTicketVehicles(XfPage page, CompareTicketVehicle compareTicketVehicle) {
    return XfR.ok(compareTicketVehicleServiceImpl.page(page, Wrappers.query(compareTicketVehicle)));
  }

  /**
   * 通过id查询数据比对用途的机动车销售统一发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketvehicles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketVehicleServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的机动车销售统一发票
   * @param compareTicketVehicle 数据比对用途的机动车销售统一发票
   * @return XfR
   */
  @PostMapping("/compareticketvehicles")
  public XfR save(@RequestBody CompareTicketVehicle compareTicketVehicle) {
     return XfR.ok(compareTicketVehicleServiceImpl.save(compareTicketVehicle));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的机动车销售统一发票
   * @param compareTicketVehicle 数据比对用途的机动车销售统一发票
   * @return XfR
   */
  @PutMapping("/compareticketvehicles/{id}")
  public XfR putUpdate(@RequestBody CompareTicketVehicle compareTicketVehicle,@PathVariable Long id) {
      compareTicketVehicle.setId(id);
      return XfR.ok(compareTicketVehicleServiceImpl.updateById(compareTicketVehicle));
  }

  /**
   * 修改-传入修改的数据数据比对用途的机动车销售统一发票
   * @param compareTicketVehicle 数据比对用途的机动车销售统一发票
   * @return XfR
   */
  @PatchMapping("/compareticketvehicles/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketVehicle compareTicketVehicle,@PathVariable Long id) {
      CompareTicketVehicle upcompareTicketVehicle = compareTicketVehicleServiceImpl.getById(id);
      if(upcompareTicketVehicle != null){
        upcompareTicketVehicle = ObjectCopyUtils.copyProperties(compareTicketVehicle,upcompareTicketVehicle,true);
      }
      return XfR.ok(compareTicketVehicleServiceImpl.updateById(upcompareTicketVehicle));
  }

  /**
   * 通过id删除数据比对用途的机动车销售统一发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketvehicles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketVehicleServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketvehicles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_vehicle");
     params.put("request", condition);

     return XfR.ok(compareTicketVehicleServiceImpl.querys(params));
  }

}
