package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketInvoiceDetail;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketInvoiceDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-11-04
 */
@RestController
public class TicketInvoiceDetailController {

  @Autowired
  private ITicketInvoiceDetailService ticketInvoiceDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketInvoiceDetail ${table.comment}
   * @return
   */
  @GetMapping("/ticketinvoicedetails" )
  public XfR getTicketInvoiceDetails(XfPage page, TicketInvoiceDetail ticketInvoiceDetail) {
    return XfR.ok(ticketInvoiceDetailServiceImpl.page(page, Wrappers.query(ticketInvoiceDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketinvoicedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketInvoiceDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketinvoicedetails")
  public XfR save(@RequestBody TicketInvoiceDetail ticketInvoiceDetail) {
     return XfR.ok(ticketInvoiceDetailServiceImpl.save(ticketInvoiceDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketinvoicedetails/{id}")
  public XfR putUpdate(@RequestBody TicketInvoiceDetail ticketInvoiceDetail,@PathVariable Long id) {
      ticketInvoiceDetail.setId(id);
      return XfR.ok(ticketInvoiceDetailServiceImpl.updateById(ticketInvoiceDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketinvoicedetails/{id}")
  public XfR patchUpdate(@RequestBody TicketInvoiceDetail ticketInvoiceDetail,@PathVariable Long id) {
      TicketInvoiceDetail upticketInvoiceDetail = ticketInvoiceDetailServiceImpl.getById(id);
      if(upticketInvoiceDetail != null){
        upticketInvoiceDetail = ObjectCopyUtils.copyProperties(ticketInvoiceDetail,upticketInvoiceDetail,true);
      }
      return XfR.ok(ticketInvoiceDetailServiceImpl.updateById(upticketInvoiceDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketinvoicedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketInvoiceDetailServiceImpl.removeById(id));
  }

  @PostMapping("/ticketinvoicedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_invoice_detail");
     params.put("request", condition);

     return XfR.ok(ticketInvoiceDetailServiceImpl.querys(params));
  }

}
