package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TravelExpenseBill;
import com.xforceplus.ultraman.app.imagesaas.service.ITravelExpenseBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-11-04
 */
@RestController
public class TravelExpenseBillController {

  @Autowired
  private ITravelExpenseBillService travelExpenseBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param travelExpenseBill ${table.comment}
   * @return
   */
  @GetMapping("/travelexpensebills" )
  public XfR getTravelExpenseBills(XfPage page, TravelExpenseBill travelExpenseBill) {
    return XfR.ok(travelExpenseBillServiceImpl.page(page, Wrappers.query(travelExpenseBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/travelexpensebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(travelExpenseBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param travelExpenseBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/travelexpensebills")
  public XfR save(@RequestBody TravelExpenseBill travelExpenseBill) {
     return XfR.ok(travelExpenseBillServiceImpl.save(travelExpenseBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param travelExpenseBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/travelexpensebills/{id}")
  public XfR putUpdate(@RequestBody TravelExpenseBill travelExpenseBill,@PathVariable Long id) {
      travelExpenseBill.setId(id);
      return XfR.ok(travelExpenseBillServiceImpl.updateById(travelExpenseBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param travelExpenseBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/travelexpensebills/{id}")
  public XfR patchUpdate(@RequestBody TravelExpenseBill travelExpenseBill,@PathVariable Long id) {
      TravelExpenseBill uptravelExpenseBill = travelExpenseBillServiceImpl.getById(id);
      if(uptravelExpenseBill != null){
        uptravelExpenseBill = ObjectCopyUtils.copyProperties(travelExpenseBill,uptravelExpenseBill,true);
      }
      return XfR.ok(travelExpenseBillServiceImpl.updateById(uptravelExpenseBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/travelexpensebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(travelExpenseBillServiceImpl.removeById(id));
  }

  @PostMapping("/travelexpensebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "travel_expense_bill");
     params.put("request", condition);

     return XfR.ok(travelExpenseBillServiceImpl.querys(params));
  }

}
