package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketAudit;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketAuditService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 审批单证前端控制器
 *
 * @author ultraman
 * @date 2021-11-29
 */
@RestController
public class TicketAuditController {

  @Autowired
  private ITicketAuditService ticketAuditServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketAudit 审批单证
   * @return
   */
  @GetMapping("/ticketaudits" )
  public XfR getTicketAudits(XfPage page, TicketAudit ticketAudit) {
    return XfR.ok(ticketAuditServiceImpl.page(page, Wrappers.query(ticketAudit)));
  }

  /**
   * 通过id查询审批单证
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketaudits/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketAuditServiceImpl.getById(id));
  }

  /**
   * 新增审批单证
   * @param ticketAudit 审批单证
   * @return XfR
   */
  @PostMapping("/ticketaudits")
  public XfR save(@RequestBody TicketAudit ticketAudit) {
     return XfR.ok(ticketAuditServiceImpl.save(ticketAudit));
  }

  /**
   * 修改-传入修改后的全部数据审批单证
   * @param ticketAudit 审批单证
   * @return XfR
   */
  @PutMapping("/ticketaudits/{id}")
  public XfR putUpdate(@RequestBody TicketAudit ticketAudit,@PathVariable Long id) {
      ticketAudit.setId(id);
      return XfR.ok(ticketAuditServiceImpl.updateById(ticketAudit));
  }

  /**
   * 修改-传入修改的数据审批单证
   * @param ticketAudit 审批单证
   * @return XfR
   */
  @PatchMapping("/ticketaudits/{id}")
  public XfR patchUpdate(@RequestBody TicketAudit ticketAudit,@PathVariable Long id) {
      TicketAudit upticketAudit = ticketAuditServiceImpl.getById(id);
      if(upticketAudit != null){
        upticketAudit = ObjectCopyUtils.copyProperties(ticketAudit,upticketAudit,true);
      }
      return XfR.ok(ticketAuditServiceImpl.updateById(upticketAudit));
  }

  /**
   * 通过id删除审批单证
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketaudits/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketAuditServiceImpl.removeById(id));
  }

  @PostMapping("/ticketaudits/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_audit");
     params.put("request", condition);

     return XfR.ok(ticketAuditServiceImpl.querys(params));
  }

}
