package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketMany;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketManyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-11-29
 */
@RestController
public class TicketManyController {

  @Autowired
  private ITicketManyService ticketManyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketMany ${table.comment}
   * @return
   */
  @GetMapping("/ticketmanys" )
  public XfR getTicketManys(XfPage page, TicketMany ticketMany) {
    return XfR.ok(ticketManyServiceImpl.page(page, Wrappers.query(ticketMany)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketmanys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketManyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketMany ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketmanys")
  public XfR save(@RequestBody TicketMany ticketMany) {
     return XfR.ok(ticketManyServiceImpl.save(ticketMany));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketMany ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketmanys/{id}")
  public XfR putUpdate(@RequestBody TicketMany ticketMany,@PathVariable Long id) {
      ticketMany.setId(id);
      return XfR.ok(ticketManyServiceImpl.updateById(ticketMany));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketMany ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketmanys/{id}")
  public XfR patchUpdate(@RequestBody TicketMany ticketMany,@PathVariable Long id) {
      TicketMany upticketMany = ticketManyServiceImpl.getById(id);
      if(upticketMany != null){
        upticketMany = ObjectCopyUtils.copyProperties(ticketMany,upticketMany,true);
      }
      return XfR.ok(ticketManyServiceImpl.updateById(upticketMany));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketmanys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketManyServiceImpl.removeById(id));
  }

  @PostMapping("/ticketmanys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_many");
     params.put("request", condition);

     return XfR.ok(ticketManyServiceImpl.querys(params));
  }

}
