package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.BillTicketReuse;
import com.xforceplus.ultraman.app.imagesaas.service.IBillTicketReuseService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-24
 */
@RestController
public class BillTicketReuseController {

  @Autowired
  private IBillTicketReuseService billTicketReuseServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billTicketReuse ${table.comment}
   * @return
   */
  @GetMapping("/billticketreuses" )
  public XfR getBillTicketReuses(XfPage page, BillTicketReuse billTicketReuse) {
    return XfR.ok(billTicketReuseServiceImpl.page(page, Wrappers.query(billTicketReuse)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billticketreuses/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billTicketReuseServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billTicketReuse ${table.comment}
   * @return XfR
   */
  @PostMapping("/billticketreuses")
  public XfR save(@RequestBody BillTicketReuse billTicketReuse) {
     return XfR.ok(billTicketReuseServiceImpl.save(billTicketReuse));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billTicketReuse ${table.comment}
   * @return XfR
   */
  @PutMapping("/billticketreuses/{id}")
  public XfR putUpdate(@RequestBody BillTicketReuse billTicketReuse,@PathVariable Long id) {
      billTicketReuse.setId(id);
      return XfR.ok(billTicketReuseServiceImpl.updateById(billTicketReuse));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billTicketReuse ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billticketreuses/{id}")
  public XfR patchUpdate(@RequestBody BillTicketReuse billTicketReuse,@PathVariable Long id) {
      BillTicketReuse upbillTicketReuse = billTicketReuseServiceImpl.getById(id);
      if(upbillTicketReuse != null){
        upbillTicketReuse = ObjectCopyUtils.copyProperties(billTicketReuse,upbillTicketReuse,true);
      }
      return XfR.ok(billTicketReuseServiceImpl.updateById(upbillTicketReuse));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billticketreuses/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billTicketReuseServiceImpl.removeById(id));
  }

  @PostMapping("/billticketreuses/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_ticket_reuse");
     params.put("request", condition);

     return XfR.ok(billTicketReuseServiceImpl.querys(params));
  }

}
