package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareImage;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareImageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据对比用途的影像前端控制器
 *
 * @author ultraman
 * @date 2022-01-24
 */
@RestController
public class CompareImageController {

  @Autowired
  private ICompareImageService compareImageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareImage 数据对比用途的影像
   * @return
   */
  @GetMapping("/compareimages" )
  public XfR getCompareImages(XfPage page, CompareImage compareImage) {
    return XfR.ok(compareImageServiceImpl.page(page, Wrappers.query(compareImage)));
  }

  /**
   * 通过id查询数据对比用途的影像
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareimages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareImageServiceImpl.getById(id));
  }

  /**
   * 新增数据对比用途的影像
   * @param compareImage 数据对比用途的影像
   * @return XfR
   */
  @PostMapping("/compareimages")
  public XfR save(@RequestBody CompareImage compareImage) {
     return XfR.ok(compareImageServiceImpl.save(compareImage));
  }

  /**
   * 修改-传入修改后的全部数据数据对比用途的影像
   * @param compareImage 数据对比用途的影像
   * @return XfR
   */
  @PutMapping("/compareimages/{id}")
  public XfR putUpdate(@RequestBody CompareImage compareImage,@PathVariable Long id) {
      compareImage.setId(id);
      return XfR.ok(compareImageServiceImpl.updateById(compareImage));
  }

  /**
   * 修改-传入修改的数据数据对比用途的影像
   * @param compareImage 数据对比用途的影像
   * @return XfR
   */
  @PatchMapping("/compareimages/{id}")
  public XfR patchUpdate(@RequestBody CompareImage compareImage,@PathVariable Long id) {
      CompareImage upcompareImage = compareImageServiceImpl.getById(id);
      if(upcompareImage != null){
        upcompareImage = ObjectCopyUtils.copyProperties(compareImage,upcompareImage,true);
      }
      return XfR.ok(compareImageServiceImpl.updateById(upcompareImage));
  }

  /**
   * 通过id删除数据对比用途的影像
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareimages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareImageServiceImpl.removeById(id));
  }

  @PostMapping("/compareimages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_image");
     params.put("request", condition);

     return XfR.ok(compareImageServiceImpl.querys(params));
  }

}
