package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketPlaneDetail;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareTicketPlaneDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的飞机票明细前端控制器
 *
 * @author ultraman
 * @date 2022-01-24
 */
@RestController
public class CompareTicketPlaneDetailController {

  @Autowired
  private ICompareTicketPlaneDetailService compareTicketPlaneDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketPlaneDetail 数据比对用途的飞机票明细
   * @return
   */
  @GetMapping("/compareticketplanedetails" )
  public XfR getCompareTicketPlaneDetails(XfPage page, CompareTicketPlaneDetail compareTicketPlaneDetail) {
    return XfR.ok(compareTicketPlaneDetailServiceImpl.page(page, Wrappers.query(compareTicketPlaneDetail)));
  }

  /**
   * 通过id查询数据比对用途的飞机票明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketplanedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketPlaneDetailServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的飞机票明细
   * @param compareTicketPlaneDetail 数据比对用途的飞机票明细
   * @return XfR
   */
  @PostMapping("/compareticketplanedetails")
  public XfR save(@RequestBody CompareTicketPlaneDetail compareTicketPlaneDetail) {
     return XfR.ok(compareTicketPlaneDetailServiceImpl.save(compareTicketPlaneDetail));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的飞机票明细
   * @param compareTicketPlaneDetail 数据比对用途的飞机票明细
   * @return XfR
   */
  @PutMapping("/compareticketplanedetails/{id}")
  public XfR putUpdate(@RequestBody CompareTicketPlaneDetail compareTicketPlaneDetail,@PathVariable Long id) {
      compareTicketPlaneDetail.setId(id);
      return XfR.ok(compareTicketPlaneDetailServiceImpl.updateById(compareTicketPlaneDetail));
  }

  /**
   * 修改-传入修改的数据数据比对用途的飞机票明细
   * @param compareTicketPlaneDetail 数据比对用途的飞机票明细
   * @return XfR
   */
  @PatchMapping("/compareticketplanedetails/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketPlaneDetail compareTicketPlaneDetail,@PathVariable Long id) {
      CompareTicketPlaneDetail upcompareTicketPlaneDetail = compareTicketPlaneDetailServiceImpl.getById(id);
      if(upcompareTicketPlaneDetail != null){
        upcompareTicketPlaneDetail = ObjectCopyUtils.copyProperties(compareTicketPlaneDetail,upcompareTicketPlaneDetail,true);
      }
      return XfR.ok(compareTicketPlaneDetailServiceImpl.updateById(upcompareTicketPlaneDetail));
  }

  /**
   * 通过id删除数据比对用途的飞机票明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketplanedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketPlaneDetailServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketplanedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_plane_detail");
     params.put("request", condition);

     return XfR.ok(compareTicketPlaneDetailServiceImpl.querys(params));
  }

}
