package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketToll;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareTicketTollService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的过路费发票前端控制器
 *
 * @author ultraman
 * @date 2022-01-24
 */
@RestController
public class CompareTicketTollController {

  @Autowired
  private ICompareTicketTollService compareTicketTollServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketToll 数据比对用途的过路费发票
   * @return
   */
  @GetMapping("/comparetickettolls" )
  public XfR getCompareTicketTolls(XfPage page, CompareTicketToll compareTicketToll) {
    return XfR.ok(compareTicketTollServiceImpl.page(page, Wrappers.query(compareTicketToll)));
  }

  /**
   * 通过id查询数据比对用途的过路费发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparetickettolls/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketTollServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的过路费发票
   * @param compareTicketToll 数据比对用途的过路费发票
   * @return XfR
   */
  @PostMapping("/comparetickettolls")
  public XfR save(@RequestBody CompareTicketToll compareTicketToll) {
     return XfR.ok(compareTicketTollServiceImpl.save(compareTicketToll));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的过路费发票
   * @param compareTicketToll 数据比对用途的过路费发票
   * @return XfR
   */
  @PutMapping("/comparetickettolls/{id}")
  public XfR putUpdate(@RequestBody CompareTicketToll compareTicketToll,@PathVariable Long id) {
      compareTicketToll.setId(id);
      return XfR.ok(compareTicketTollServiceImpl.updateById(compareTicketToll));
  }

  /**
   * 修改-传入修改的数据数据比对用途的过路费发票
   * @param compareTicketToll 数据比对用途的过路费发票
   * @return XfR
   */
  @PatchMapping("/comparetickettolls/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketToll compareTicketToll,@PathVariable Long id) {
      CompareTicketToll upcompareTicketToll = compareTicketTollServiceImpl.getById(id);
      if(upcompareTicketToll != null){
        upcompareTicketToll = ObjectCopyUtils.copyProperties(compareTicketToll,upcompareTicketToll,true);
      }
      return XfR.ok(compareTicketTollServiceImpl.updateById(upcompareTicketToll));
  }

  /**
   * 通过id删除数据比对用途的过路费发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparetickettolls/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketTollServiceImpl.removeById(id));
  }

  @PostMapping("/comparetickettolls/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_toll");
     params.put("request", condition);

     return XfR.ok(compareTicketTollServiceImpl.querys(params));
  }

}
