package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.ConfigBillTicketRel;
import com.xforceplus.ultraman.app.imagesaas.service.IConfigBillTicketRelService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-24
 */
@RestController
public class ConfigBillTicketRelController {

  @Autowired
  private IConfigBillTicketRelService configBillTicketRelServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configBillTicketRel ${table.comment}
   * @return
   */
  @GetMapping("/configbillticketrels" )
  public XfR getConfigBillTicketRels(XfPage page, ConfigBillTicketRel configBillTicketRel) {
    return XfR.ok(configBillTicketRelServiceImpl.page(page, Wrappers.query(configBillTicketRel)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/configbillticketrels/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configBillTicketRelServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param configBillTicketRel ${table.comment}
   * @return XfR
   */
  @PostMapping("/configbillticketrels")
  public XfR save(@RequestBody ConfigBillTicketRel configBillTicketRel) {
     return XfR.ok(configBillTicketRelServiceImpl.save(configBillTicketRel));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param configBillTicketRel ${table.comment}
   * @return XfR
   */
  @PutMapping("/configbillticketrels/{id}")
  public XfR putUpdate(@RequestBody ConfigBillTicketRel configBillTicketRel,@PathVariable Long id) {
      configBillTicketRel.setId(id);
      return XfR.ok(configBillTicketRelServiceImpl.updateById(configBillTicketRel));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param configBillTicketRel ${table.comment}
   * @return XfR
   */
  @PatchMapping("/configbillticketrels/{id}")
  public XfR patchUpdate(@RequestBody ConfigBillTicketRel configBillTicketRel,@PathVariable Long id) {
      ConfigBillTicketRel upconfigBillTicketRel = configBillTicketRelServiceImpl.getById(id);
      if(upconfigBillTicketRel != null){
        upconfigBillTicketRel = ObjectCopyUtils.copyProperties(configBillTicketRel,upconfigBillTicketRel,true);
      }
      return XfR.ok(configBillTicketRelServiceImpl.updateById(upconfigBillTicketRel));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configbillticketrels/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configBillTicketRelServiceImpl.removeById(id));
  }

  @PostMapping("/configbillticketrels/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_bill_ticket_rel");
     params.put("request", condition);

     return XfR.ok(configBillTicketRelServiceImpl.querys(params));
  }

}
