package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.FyHtfkBl;
import com.xforceplus.ultraman.app.imagesaas.service.IFyHtfkBlService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 中南置地-费控合同付款补录前端控制器
 *
 * @author ultraman
 * @date 2022-01-24
 */
@RestController
public class FyHtfkBlController {

  @Autowired
  private IFyHtfkBlService fyHtfkBlServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fyHtfkBl 中南置地-费控合同付款补录
   * @return
   */
  @GetMapping("/fyhtfkbls" )
  public XfR getFyHtfkBls(XfPage page, FyHtfkBl fyHtfkBl) {
    return XfR.ok(fyHtfkBlServiceImpl.page(page, Wrappers.query(fyHtfkBl)));
  }

  /**
   * 通过id查询中南置地-费控合同付款补录
   * @param  id
   * @return XfR
   */
  @GetMapping("/fyhtfkbls/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fyHtfkBlServiceImpl.getById(id));
  }

  /**
   * 新增中南置地-费控合同付款补录
   * @param fyHtfkBl 中南置地-费控合同付款补录
   * @return XfR
   */
  @PostMapping("/fyhtfkbls")
  public XfR save(@RequestBody FyHtfkBl fyHtfkBl) {
     return XfR.ok(fyHtfkBlServiceImpl.save(fyHtfkBl));
  }

  /**
   * 修改-传入修改后的全部数据中南置地-费控合同付款补录
   * @param fyHtfkBl 中南置地-费控合同付款补录
   * @return XfR
   */
  @PutMapping("/fyhtfkbls/{id}")
  public XfR putUpdate(@RequestBody FyHtfkBl fyHtfkBl,@PathVariable Long id) {
      fyHtfkBl.setId(id);
      return XfR.ok(fyHtfkBlServiceImpl.updateById(fyHtfkBl));
  }

  /**
   * 修改-传入修改的数据中南置地-费控合同付款补录
   * @param fyHtfkBl 中南置地-费控合同付款补录
   * @return XfR
   */
  @PatchMapping("/fyhtfkbls/{id}")
  public XfR patchUpdate(@RequestBody FyHtfkBl fyHtfkBl,@PathVariable Long id) {
      FyHtfkBl upfyHtfkBl = fyHtfkBlServiceImpl.getById(id);
      if(upfyHtfkBl != null){
        upfyHtfkBl = ObjectCopyUtils.copyProperties(fyHtfkBl,upfyHtfkBl,true);
      }
      return XfR.ok(fyHtfkBlServiceImpl.updateById(upfyHtfkBl));
  }

  /**
   * 通过id删除中南置地-费控合同付款补录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fyhtfkbls/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fyHtfkBlServiceImpl.removeById(id));
  }

  @PostMapping("/fyhtfkbls/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fy_htfk_bl");
     params.put("request", condition);

     return XfR.ok(fyHtfkBlServiceImpl.querys(params));
  }

}
