package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketTrain;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketTrainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-24
 */
@RestController
public class TicketTrainController {

  @Autowired
  private ITicketTrainService ticketTrainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketTrain ${table.comment}
   * @return
   */
  @GetMapping("/tickettrains" )
  public XfR getTicketTrains(XfPage page, TicketTrain ticketTrain) {
    return XfR.ok(ticketTrainServiceImpl.page(page, Wrappers.query(ticketTrain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tickettrains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketTrainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketTrain ${table.comment}
   * @return XfR
   */
  @PostMapping("/tickettrains")
  public XfR save(@RequestBody TicketTrain ticketTrain) {
     return XfR.ok(ticketTrainServiceImpl.save(ticketTrain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketTrain ${table.comment}
   * @return XfR
   */
  @PutMapping("/tickettrains/{id}")
  public XfR putUpdate(@RequestBody TicketTrain ticketTrain,@PathVariable Long id) {
      ticketTrain.setId(id);
      return XfR.ok(ticketTrainServiceImpl.updateById(ticketTrain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketTrain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tickettrains/{id}")
  public XfR patchUpdate(@RequestBody TicketTrain ticketTrain,@PathVariable Long id) {
      TicketTrain upticketTrain = ticketTrainServiceImpl.getById(id);
      if(upticketTrain != null){
        upticketTrain = ObjectCopyUtils.copyProperties(ticketTrain,upticketTrain,true);
      }
      return XfR.ok(ticketTrainServiceImpl.updateById(upticketTrain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tickettrains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketTrainServiceImpl.removeById(id));
  }

  @PostMapping("/tickettrains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_train");
     params.put("request", condition);

     return XfR.ok(ticketTrainServiceImpl.querys(params));
  }

}
