package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketVehicle;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketVehicleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 机动车销售统一发票前端控制器
 *
 * @author ultraman
 * @date 2022-01-24
 */
@RestController
public class TicketVehicleController {

  @Autowired
  private ITicketVehicleService ticketVehicleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketVehicle 机动车销售统一发票
   * @return
   */
  @GetMapping("/ticketvehicles" )
  public XfR getTicketVehicles(XfPage page, TicketVehicle ticketVehicle) {
    return XfR.ok(ticketVehicleServiceImpl.page(page, Wrappers.query(ticketVehicle)));
  }

  /**
   * 通过id查询机动车销售统一发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketvehicles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketVehicleServiceImpl.getById(id));
  }

  /**
   * 新增机动车销售统一发票
   * @param ticketVehicle 机动车销售统一发票
   * @return XfR
   */
  @PostMapping("/ticketvehicles")
  public XfR save(@RequestBody TicketVehicle ticketVehicle) {
     return XfR.ok(ticketVehicleServiceImpl.save(ticketVehicle));
  }

  /**
   * 修改-传入修改后的全部数据机动车销售统一发票
   * @param ticketVehicle 机动车销售统一发票
   * @return XfR
   */
  @PutMapping("/ticketvehicles/{id}")
  public XfR putUpdate(@RequestBody TicketVehicle ticketVehicle,@PathVariable Long id) {
      ticketVehicle.setId(id);
      return XfR.ok(ticketVehicleServiceImpl.updateById(ticketVehicle));
  }

  /**
   * 修改-传入修改的数据机动车销售统一发票
   * @param ticketVehicle 机动车销售统一发票
   * @return XfR
   */
  @PatchMapping("/ticketvehicles/{id}")
  public XfR patchUpdate(@RequestBody TicketVehicle ticketVehicle,@PathVariable Long id) {
      TicketVehicle upticketVehicle = ticketVehicleServiceImpl.getById(id);
      if(upticketVehicle != null){
        upticketVehicle = ObjectCopyUtils.copyProperties(ticketVehicle,upticketVehicle,true);
      }
      return XfR.ok(ticketVehicleServiceImpl.updateById(upticketVehicle));
  }

  /**
   * 通过id删除机动车销售统一发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketvehicles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketVehicleServiceImpl.removeById(id));
  }

  @PostMapping("/ticketvehicles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_vehicle");
     params.put("request", condition);

     return XfR.ok(ticketVehicleServiceImpl.querys(params));
  }

}
