package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CbFHtfkBl;
import com.xforceplus.ultraman.app.imagesaas.service.ICbFHtfkBlService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 中南置地-成本非合同付款补录前端控制器
 *
 * @author ultraman
 * @date 2022-02-25
 */
@RestController
public class CbFHtfkBlController {

  @Autowired
  private ICbFHtfkBlService cbFHtfkBlServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cbFHtfkBl 中南置地-成本非合同付款补录
   * @return
   */
  @GetMapping("/cbfhtfkbls" )
  public XfR getCbFHtfkBls(XfPage page, CbFHtfkBl cbFHtfkBl) {
    return XfR.ok(cbFHtfkBlServiceImpl.page(page, Wrappers.query(cbFHtfkBl)));
  }

  /**
   * 通过id查询中南置地-成本非合同付款补录
   * @param  id
   * @return XfR
   */
  @GetMapping("/cbfhtfkbls/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(cbFHtfkBlServiceImpl.getById(id));
  }

  /**
   * 新增中南置地-成本非合同付款补录
   * @param cbFHtfkBl 中南置地-成本非合同付款补录
   * @return XfR
   */
  @PostMapping("/cbfhtfkbls")
  public XfR save(@RequestBody CbFHtfkBl cbFHtfkBl) {
     return XfR.ok(cbFHtfkBlServiceImpl.save(cbFHtfkBl));
  }

  /**
   * 修改-传入修改后的全部数据中南置地-成本非合同付款补录
   * @param cbFHtfkBl 中南置地-成本非合同付款补录
   * @return XfR
   */
  @PutMapping("/cbfhtfkbls/{id}")
  public XfR putUpdate(@RequestBody CbFHtfkBl cbFHtfkBl,@PathVariable Long id) {
      cbFHtfkBl.setId(id);
      return XfR.ok(cbFHtfkBlServiceImpl.updateById(cbFHtfkBl));
  }

  /**
   * 修改-传入修改的数据中南置地-成本非合同付款补录
   * @param cbFHtfkBl 中南置地-成本非合同付款补录
   * @return XfR
   */
  @PatchMapping("/cbfhtfkbls/{id}")
  public XfR patchUpdate(@RequestBody CbFHtfkBl cbFHtfkBl,@PathVariable Long id) {
      CbFHtfkBl upcbFHtfkBl = cbFHtfkBlServiceImpl.getById(id);
      if(upcbFHtfkBl != null){
        upcbFHtfkBl = ObjectCopyUtils.copyProperties(cbFHtfkBl,upcbFHtfkBl,true);
      }
      return XfR.ok(cbFHtfkBlServiceImpl.updateById(upcbFHtfkBl));
  }

  /**
   * 通过id删除中南置地-成本非合同付款补录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cbfhtfkbls/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(cbFHtfkBlServiceImpl.removeById(id));
  }

  @PostMapping("/cbfhtfkbls/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cb_f_htfk_bl");
     params.put("request", condition);

     return XfR.ok(cbFHtfkBlServiceImpl.querys(params));
  }

}
