package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.ComparePrivateBill;
import com.xforceplus.ultraman.app.imagesaas.service.IComparePrivateBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的对私业务单前端控制器
 *
 * @author ultraman
 * @date 2022-02-25
 */
@RestController
public class ComparePrivateBillController {

  @Autowired
  private IComparePrivateBillService comparePrivateBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param comparePrivateBill 数据比对用途的对私业务单
   * @return
   */
  @GetMapping("/compareprivatebills" )
  public XfR getComparePrivateBills(XfPage page, ComparePrivateBill comparePrivateBill) {
    return XfR.ok(comparePrivateBillServiceImpl.page(page, Wrappers.query(comparePrivateBill)));
  }

  /**
   * 通过id查询数据比对用途的对私业务单
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareprivatebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(comparePrivateBillServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的对私业务单
   * @param comparePrivateBill 数据比对用途的对私业务单
   * @return XfR
   */
  @PostMapping("/compareprivatebills")
  public XfR save(@RequestBody ComparePrivateBill comparePrivateBill) {
     return XfR.ok(comparePrivateBillServiceImpl.save(comparePrivateBill));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的对私业务单
   * @param comparePrivateBill 数据比对用途的对私业务单
   * @return XfR
   */
  @PutMapping("/compareprivatebills/{id}")
  public XfR putUpdate(@RequestBody ComparePrivateBill comparePrivateBill,@PathVariable Long id) {
      comparePrivateBill.setId(id);
      return XfR.ok(comparePrivateBillServiceImpl.updateById(comparePrivateBill));
  }

  /**
   * 修改-传入修改的数据数据比对用途的对私业务单
   * @param comparePrivateBill 数据比对用途的对私业务单
   * @return XfR
   */
  @PatchMapping("/compareprivatebills/{id}")
  public XfR patchUpdate(@RequestBody ComparePrivateBill comparePrivateBill,@PathVariable Long id) {
      ComparePrivateBill upcomparePrivateBill = comparePrivateBillServiceImpl.getById(id);
      if(upcomparePrivateBill != null){
        upcomparePrivateBill = ObjectCopyUtils.copyProperties(comparePrivateBill,upcomparePrivateBill,true);
      }
      return XfR.ok(comparePrivateBillServiceImpl.updateById(upcomparePrivateBill));
  }

  /**
   * 通过id删除数据比对用途的对私业务单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareprivatebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(comparePrivateBillServiceImpl.removeById(id));
  }

  @PostMapping("/compareprivatebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_private_bill");
     params.put("request", condition);

     return XfR.ok(comparePrivateBillServiceImpl.querys(params));
  }

}
