package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketVirtual;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareTicketVirtualService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 比对虚拟单证前端控制器
 *
 * @author ultraman
 * @date 2022-02-25
 */
@RestController
public class CompareTicketVirtualController {

  @Autowired
  private ICompareTicketVirtualService compareTicketVirtualServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketVirtual 比对虚拟单证
   * @return
   */
  @GetMapping("/compareticketvirtuals" )
  public XfR getCompareTicketVirtuals(XfPage page, CompareTicketVirtual compareTicketVirtual) {
    return XfR.ok(compareTicketVirtualServiceImpl.page(page, Wrappers.query(compareTicketVirtual)));
  }

  /**
   * 通过id查询比对虚拟单证
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketvirtuals/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketVirtualServiceImpl.getById(id));
  }

  /**
   * 新增比对虚拟单证
   * @param compareTicketVirtual 比对虚拟单证
   * @return XfR
   */
  @PostMapping("/compareticketvirtuals")
  public XfR save(@RequestBody CompareTicketVirtual compareTicketVirtual) {
     return XfR.ok(compareTicketVirtualServiceImpl.save(compareTicketVirtual));
  }

  /**
   * 修改-传入修改后的全部数据比对虚拟单证
   * @param compareTicketVirtual 比对虚拟单证
   * @return XfR
   */
  @PutMapping("/compareticketvirtuals/{id}")
  public XfR putUpdate(@RequestBody CompareTicketVirtual compareTicketVirtual,@PathVariable Long id) {
      compareTicketVirtual.setId(id);
      return XfR.ok(compareTicketVirtualServiceImpl.updateById(compareTicketVirtual));
  }

  /**
   * 修改-传入修改的数据比对虚拟单证
   * @param compareTicketVirtual 比对虚拟单证
   * @return XfR
   */
  @PatchMapping("/compareticketvirtuals/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketVirtual compareTicketVirtual,@PathVariable Long id) {
      CompareTicketVirtual upcompareTicketVirtual = compareTicketVirtualServiceImpl.getById(id);
      if(upcompareTicketVirtual != null){
        upcompareTicketVirtual = ObjectCopyUtils.copyProperties(compareTicketVirtual,upcompareTicketVirtual,true);
      }
      return XfR.ok(compareTicketVirtualServiceImpl.updateById(upcompareTicketVirtual));
  }

  /**
   * 通过id删除比对虚拟单证
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketvirtuals/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketVirtualServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketvirtuals/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_virtual");
     params.put("request", condition);

     return XfR.ok(compareTicketVirtualServiceImpl.querys(params));
  }

}
