package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.PublicBill;
import com.xforceplus.ultraman.app.imagesaas.service.IPublicBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-02-25
 */
@RestController
public class PublicBillController {

  @Autowired
  private IPublicBillService publicBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param publicBill ${table.comment}
   * @return
   */
  @GetMapping("/publicbills" )
  public XfR getPublicBills(XfPage page, PublicBill publicBill) {
    return XfR.ok(publicBillServiceImpl.page(page, Wrappers.query(publicBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/publicbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(publicBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param publicBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/publicbills")
  public XfR save(@RequestBody PublicBill publicBill) {
     return XfR.ok(publicBillServiceImpl.save(publicBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param publicBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/publicbills/{id}")
  public XfR putUpdate(@RequestBody PublicBill publicBill,@PathVariable Long id) {
      publicBill.setId(id);
      return XfR.ok(publicBillServiceImpl.updateById(publicBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param publicBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/publicbills/{id}")
  public XfR patchUpdate(@RequestBody PublicBill publicBill,@PathVariable Long id) {
      PublicBill uppublicBill = publicBillServiceImpl.getById(id);
      if(uppublicBill != null){
        uppublicBill = ObjectCopyUtils.copyProperties(publicBill,uppublicBill,true);
      }
      return XfR.ok(publicBillServiceImpl.updateById(uppublicBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/publicbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(publicBillServiceImpl.removeById(id));
  }

  @PostMapping("/publicbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "public_bill");
     params.put("request", condition);

     return XfR.ok(publicBillServiceImpl.querys(params));
  }

}
