package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.SalesBill;
import com.xforceplus.ultraman.app.imagesaas.service.ISalesBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-02-25
 */
@RestController
public class SalesBillController {

  @Autowired
  private ISalesBillService salesBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesBill ${table.comment}
   * @return
   */
  @GetMapping("/salesbills" )
  public XfR getSalesBills(XfPage page, SalesBill salesBill) {
    return XfR.ok(salesBillServiceImpl.page(page, Wrappers.query(salesBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesbills")
  public XfR save(@RequestBody SalesBill salesBill) {
     return XfR.ok(salesBillServiceImpl.save(salesBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesbills/{id}")
  public XfR putUpdate(@RequestBody SalesBill salesBill,@PathVariable Long id) {
      salesBill.setId(id);
      return XfR.ok(salesBillServiceImpl.updateById(salesBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesbills/{id}")
  public XfR patchUpdate(@RequestBody SalesBill salesBill,@PathVariable Long id) {
      SalesBill upsalesBill = salesBillServiceImpl.getById(id);
      if(upsalesBill != null){
        upsalesBill = ObjectCopyUtils.copyProperties(salesBill,upsalesBill,true);
      }
      return XfR.ok(salesBillServiceImpl.updateById(upsalesBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesBillServiceImpl.removeById(id));
  }

  @PostMapping("/salesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_bill");
     params.put("request", condition);

     return XfR.ok(salesBillServiceImpl.querys(params));
  }

}
