package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.Ticket;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-02-25
 */
@RestController
public class TicketController {

  @Autowired
  private ITicketService ticketServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticket ${table.comment}
   * @return
   */
  @GetMapping("/tickets" )
  public XfR getTickets(XfPage page, Ticket ticket) {
    return XfR.ok(ticketServiceImpl.page(page, Wrappers.query(ticket)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tickets/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticket ${table.comment}
   * @return XfR
   */
  @PostMapping("/tickets")
  public XfR save(@RequestBody Ticket ticket) {
     return XfR.ok(ticketServiceImpl.save(ticket));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticket ${table.comment}
   * @return XfR
   */
  @PutMapping("/tickets/{id}")
  public XfR putUpdate(@RequestBody Ticket ticket,@PathVariable Long id) {
      ticket.setId(id);
      return XfR.ok(ticketServiceImpl.updateById(ticket));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticket ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tickets/{id}")
  public XfR patchUpdate(@RequestBody Ticket ticket,@PathVariable Long id) {
      Ticket upticket = ticketServiceImpl.getById(id);
      if(upticket != null){
        upticket = ObjectCopyUtils.copyProperties(ticket,upticket,true);
      }
      return XfR.ok(ticketServiceImpl.updateById(upticket));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tickets/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketServiceImpl.removeById(id));
  }

  @PostMapping("/tickets/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket");
     params.put("request", condition);

     return XfR.ok(ticketServiceImpl.querys(params));
  }

}
